/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;

public class Window2
extends XLSRecord {
    private static final long serialVersionUID = -8316509425117672619L;
    int grbit = -1;
    int rwTop = -1;
    int colLeft = -1;
    int icvHdr = -1;
    int wScaleSLV = -1;
    int wScaleNorm = -1;
    static final int BITMASK_SHOWFORMULARESULTS = 1;
    static final int BITMASK_SHOWGRIDLINES = 2;
    static final int BITMASK_SHOWSHEETHEADERS = 4;
    static final int BITMASK_FREEZEPANES = 8;
    static final int BITMASK_SHOWZEROVALUES = 16;
    static final int BITMASK_GRIDLINECOLOR = 32;
    static final int BITMASK_COLUMNDIRECTION = 64;
    static final int BITMASK_SHOWOUTLINESYMBOLS = 128;
    static final int BITMASK_KEEPSPLITS = 256;
    static final int BITMASK_SHEETSELECTED = 512;
    static final int BITMASK_SHEETVISIBLE = 1024;
    static final int BITMASK_SHOWINPRINTPREVIEW = 2048;

    @Override
    public void init() {
        super.init();
        this.grbit = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.rwTop = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.colLeft = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        short s1 = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        short s2 = ByteTools.readShort(this.getByteAt(8), this.getByteAt(9));
        this.icvHdr = ByteTools.readInt(s1, (int)s2);
        if (this.getLength() > 10) {
            this.wScaleSLV = ByteTools.readShort(this.getByteAt(10), this.getByteAt(11));
            this.wScaleNorm = ByteTools.readShort(this.getByteAt(12), this.getByteAt(13));
        }
    }

    void setSelected(boolean b) {
        if (b) {
            byte[] byArray = this.getData();
            byArray[1] = (byte)(byArray[1] | 2);
        } else {
            byte[] byArray = this.getData();
            byArray[1] = (byte)(byArray[1] & 0xFD);
        }
        this.grbit = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
    }

    public String getTopLeftCell() {
        return ExcelTools.formatLocation(new int[]{this.rwTop, this.colLeft});
    }

    public void setGrbit() {
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes((short)this.grbit);
        System.arraycopy(b, 0, data, 0, 2);
        this.setData(data);
    }

    public boolean getShowFormulaResults() {
        return (this.grbit & 1) == 1;
    }

    public void setShowFormulaResults(boolean b) {
        this.grbit = b ? (this.grbit |= 1) : (this.grbit &= 0xFFFFFFFE);
        this.setGrbit();
    }

    public boolean getShowGridlines() {
        return (this.grbit & 2) == 2;
    }

    public void setShowGridlines(boolean b) {
        this.grbit = b ? (this.grbit |= 2) : (this.grbit &= 0xFFFFFFFD);
        this.setGrbit();
    }

    public boolean getShowSheetHeaders() {
        return (this.grbit & 4) == 4;
    }

    public void setShowSheetHeaders(boolean b) {
        this.grbit = b ? (this.grbit |= 4) : (this.grbit &= 0xFFFFFFFB);
        this.setGrbit();
    }

    public int getScaleNorm() {
        return this.wScaleNorm;
    }

    public void setScaleNorm(int zm) {
        this.wScaleNorm = zm;
        byte[] data = this.getData();
        byte[] b = ByteTools.shortToLEBytes((short)zm);
        System.arraycopy(b, 0, data, 12, 2);
        this.setData(data);
    }

    public boolean getShowZeroValues() {
        return (this.grbit & 0x10) == 16;
    }

    public void setShowZeroValues(boolean b) {
        this.grbit = b ? (this.grbit |= 0x10) : (this.grbit &= 0xFFFFFFEF);
        this.setGrbit();
    }

    public boolean getShowOutlineSymbols() {
        return (this.grbit & 0x80) == 128;
    }

    public void setShowOutlineSymbols(boolean b) {
        this.grbit = b ? (this.grbit |= 0x80) : (this.grbit &= 0xFFFFFF7F);
        this.setGrbit();
    }

    public boolean getShowInNormalView() {
        return (this.grbit & 0x800) == 0;
    }

    public void setShowInNormalView(boolean b) {
        this.grbit = b ? (this.grbit &= 0xFFFFF7FF) : (this.grbit |= 0x800);
        this.setGrbit();
    }

    public boolean getFreezePanes() {
        return (this.grbit & 8) == 8;
    }

    public void setFreezePanes(boolean b) {
        this.grbit = b ? (this.grbit |= 8) : (this.grbit &= 0xFFFFFFF7);
        this.setGrbit();
    }

    public boolean getManualGridLineColor() {
        return (this.grbit & 0x20) == 32;
    }

    public void setManualGridLineColor(boolean b) {
        this.grbit = b ? (this.grbit |= 0x20) : (this.grbit &= 0xFFFFFFDF);
        this.setGrbit();
    }
}

