/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.formats.OOXML.Fill;
import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.Format;
import com.extentech.formats.XLS.FormatConstants;
import com.extentech.formats.XLS.FormatConstantsImpl;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.awt.Color;

public class Xf
extends XLSRecord {
    private static final long serialVersionUID = -419388613530529316L;
    int tableidx = -1;
    private short ifnt;
    private short ifmt;
    private short fLocked;
    private short fHidden;
    private short fStyle;
    private short f123Prefix = 0;
    private short ixfParent;
    private short alc;
    private short fWrap = 0;
    private short alcV;
    private short cIndent;
    private short trot;
    private short fShrinkToFit = 0;
    private short fMergeCell = 0;
    private short iReadingOrder;
    private short fAtrNum = 0;
    private short fAtrFnt = 0;
    private short fAtrAlc = 0;
    private short fAtrBdr = 0;
    private short fAtrPat = 0;
    private short fAtrProt = 0;
    private short dgLeft;
    private short dgRight;
    private short dgTop;
    private short dgBottom;
    private short icvLeft;
    private short icvRight;
    private short grbitDiag;
    private short icvTop;
    private short icvBottom;
    private short icvDiag;
    private short dgDiag;
    private short fls;
    private short icvFore;
    private short icvBack;
    private short fSxButton = 0;
    private short icvColorFlag = 0;
    int Iflag = 0;
    byte mystery;
    public static final int NDEFAULTXFS = 20;
    private String pat = null;
    public Fill fill = null;
    private Font myFont;
    private Format myFormat;
    private short useCount = 0;
    public static final int PATTERN_SOLID = 1;

    public Xf() {
    }

    public Xf(int f) {
        byte[] byArray = new byte[20];
        byArray[4] = 1;
        byArray[6] = 32;
        byArray[9] = 64;
        byArray[18] = -64;
        byArray[19] = 32;
        byte[] bl = byArray;
        this.setOpcode((short)224);
        this.setLength((short)bl.length);
        this.setData(bl);
        this.setFont(f);
        this.init();
    }

    public Xf(int f, WorkBook wkbook) {
        byte[] byArray = new byte[20];
        byArray[4] = 1;
        byArray[6] = 32;
        byArray[9] = 64;
        byArray[18] = -64;
        byArray[19] = 32;
        byte[] bl = byArray;
        this.setOpcode((short)224);
        this.setLength((short)bl.length);
        this.setData(bl);
        super.setWorkBook(wkbook);
        this.setFont(f);
        this.init();
    }

    public Xf(Font f, WorkBook wkbook) {
        byte[] byArray = new byte[20];
        byArray[4] = 1;
        byArray[6] = 32;
        byArray[9] = 64;
        byArray[18] = -64;
        byArray[19] = 32;
        byte[] bl = byArray;
        this.setOpcode((short)224);
        this.setLength((short)bl.length);
        this.myFont = f;
        System.arraycopy(ByteTools.shortToLEBytes((short)f.getIdx()), 0, bl, 0, 2);
        this.setData(bl);
        super.setWorkBook(wkbook);
        this.init();
    }

    @Override
    public void setWorkBook(WorkBook b) {
        super.setWorkBook(b);
    }

    @Override
    public String toString() {
        String f = "unknown";
        try {
            f = this.getFormatPattern();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String thisToString = " format:" + f + " fill:" + this.getFillPattern() + " fg:" + this.getForegroundColor() + " bg:" + this.getBackgroundColor() + " border:[" + this.getTopBorderLineStyle() + "-" + this.getTopBorderColor() + ":" + this.getLeftBorderLineStyle() + "-" + this.getLeftBorderColor() + ":" + this.getBottomBorderLineStyle() + "-" + this.getBottomBorderColor() + ":" + this.getRightBorderLineStyle() + "-" + this.getRightBorderColor() + "]" + "W:" + this.getWrapText() + "R:" + this.getRotation() + "H:" + this.getHorizontalAlignment() + "V:" + this.getVerticalAlignment() + "I:" + this.getIndent() + "L:" + this.isLocked() + "F:" + this.isFormulaHidden() + "D:" + this.getRightToLeftReadingOrder();
        return String.valueOf(this.getFont().toString()) + thisToString;
    }

    public void incUseCount() {
        this.useCount = (short)(this.useCount + 1);
    }

    public void decUseCoount() {
        this.useCount = (short)(this.useCount - 1);
    }

    public short getUseCount() {
        return this.useCount;
    }

    protected void populateForTransfer() {
        this.myFont = this.getFont();
        this.myFormat = this.getWorkBook().getFormat(this.ifmt);
        this.getData();
    }

    public boolean getMerged() {
        return this.fMergeCell == 1;
    }

    public void setMerged(boolean mgd) {
        byte[] rkdata = this.getData();
        rkdata[9] = 120;
        if (this.DEBUGLEVEL > 1) {
            Logger.logInfo("Xf The merge style bit is: " + this.fMergeCell);
        }
    }

    @Override
    public void init() {
        super.init();
        this.ifnt = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.ifnt = (short)(this.ifnt & 0xFFFF);
        this.ifmt = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.ifmt = (short)(this.ifmt & 0xFFFF);
        short flag = ByteTools.readShort(this.getByteAt(4), this.getByteAt(5));
        this.fLocked = (flag & 1) == 1 ? (short)1 : 0;
        this.fHidden = (flag & 2) == 2 ? (short)1 : 0;
        this.fStyle = (flag & 4) == 4 ? (short)1 : 0;
        if ((flag & 8) == 8) {
            this.f123Prefix = 1;
        }
        this.ixfParent = (short)((flag & 0xFFF0) >> 4);
        this.initXF();
        this.pat = null;
        if (this.DEBUGLEVEL > 50) {
            Logger.logInfo("Xf.init() ifnt: " + this.ifnt + " ifmt: " + this.ifmt + ":" + this.toString() + " border: " + "l:" + this.getLeftBorderColor() + ":" + "b:" + this.getBottomBorderColor() + ":" + "r:" + this.getRightBorderColor() + ":" + "t:" + this.getTopBorderColor() + ":");
        }
    }

    void initXF() {
        short flag = ByteTools.readShort(this.getByteAt(6), this.getByteAt(7));
        this.alc = (short)(flag & 7);
        if ((flag & 8) == 8) {
            this.fWrap = 1;
        }
        this.alcV = (short)((flag & 0x70) >> 4);
        this.trot = (short)((flag & 0xFF00) >> 8);
        flag = this.getByteAt(8);
        this.cIndent = (short)(flag & 0xF);
        if ((flag & 0x10) == 16) {
            this.fShrinkToFit = 1;
        }
        if ((flag & 0x20) == 32) {
            this.fMergeCell = 1;
        }
        if (this.DEBUGLEVEL > 5) {
            Logger.logInfo("Xf The merge cell bit is: " + this.fMergeCell + " and the int is " + flag);
        }
        this.iReadingOrder = (short)(flag & 0xC0);
        flag = this.getByteAt(9);
        if ((flag & 4) == 4) {
            this.fAtrNum = 1;
        }
        if ((flag & 8) == 8) {
            this.fAtrFnt = 1;
        }
        if ((flag & 0x10) == 16) {
            this.fAtrAlc = 1;
        }
        if ((flag & 0x20) == 32) {
            this.fAtrBdr = 1;
        }
        if ((flag & 0x40) == 64) {
            this.fAtrPat = 1;
        }
        if ((flag & 0x80) == 128) {
            this.fAtrProt = 1;
        }
        flag = ByteTools.readShort(this.getByteAt(10), this.getByteAt(11));
        this.dgLeft = (short)(flag & 0xF);
        this.dgRight = (short)((flag & 0xF0) >> 4);
        this.dgTop = (short)((flag & 0xF00) >> 8);
        this.dgBottom = (short)((flag & 0xF000) >> 12);
        flag = ByteTools.readShort(this.getByteAt(12), this.getByteAt(13));
        this.icvLeft = (short)(flag & 0x7F);
        this.icvRight = (short)((flag & 0x3F80) >> 7);
        this.grbitDiag = (short)((flag & 0xC000) >> 15);
        this.Iflag = ByteTools.readInt(this.getByteAt(14), this.getByteAt(15), this.getByteAt(16), this.getByteAt(17));
        this.icvTop = (short)(this.Iflag & 0x7F);
        this.icvBottom = (short)((this.Iflag & 0x3F80) >> 7);
        this.icvDiag = (short)((this.Iflag & 0x1FC000) >> 14);
        this.dgDiag = (short)((this.Iflag & 0x1E00000) >> 21);
        this.mystery = (byte)((this.Iflag & 0x3800000) >> 25);
        this.fls = (short)((this.Iflag & 0xFC000000) >> 26);
        if (this.DEBUGLEVEL > 5 && this.icvTop > 0) {
            Logger.logInfo("Xf The cell outline is true");
        }
        this.icvColorFlag = ByteTools.readShort(this.getByteAt(18), this.getByteAt(19));
        this.icvFore = (short)(this.icvColorFlag & 0x7F);
        this.icvBack = (short)((this.icvColorFlag & 0x3F80) >> 7);
        if ((this.icvColorFlag & 0x4000) == 16384) {
            this.fSxButton = 1;
        }
    }

    @Override
    public Font getFont() {
        if (this.myFont != null) {
            return this.myFont;
        }
        this.myFont = this.getWorkBook().getFont(this.ifnt);
        return this.myFont;
    }

    public boolean isDatePattern() {
        int x = 0;
        while (x < FormatConstants.DATE_FORMATS.length) {
            short sxt = (short)Integer.parseInt(FormatConstants.DATE_FORMATS[x][1], 16);
            if (this.ifmt == sxt) {
                return true;
            }
            ++x;
        }
        Format fmt = this.getWorkBook().getFormat(this.ifmt);
        if (fmt == null) {
            return false;
        }
        String myfmt = fmt.getFormat().toLowerCase();
        return Xf.isDatePattern(myfmt);
    }

    public static boolean isDatePattern(String myfmt) {
        int x = 0;
        while (x < FormatConstants.DATE_FORMATS.length) {
            if (FormatConstants.DATE_FORMATS[x][0].equals(myfmt)) {
                return true;
            }
            ++x;
        }
        return myfmt.indexOf("mm") > -1 || myfmt.indexOf("yy") > -1 || myfmt.indexOf("dd") > -1;
    }

    public static String unescapeFormatPattern(String xmlFormatPattern) {
        xmlFormatPattern = xmlFormatPattern.replace("\"$\"", "$");
        xmlFormatPattern = xmlFormatPattern.replace("_);", ";");
        xmlFormatPattern = xmlFormatPattern.replace("\\(", "(");
        xmlFormatPattern = xmlFormatPattern.replace("\\)", ")");
        return xmlFormatPattern;
    }

    public boolean isCurrencyPattern() {
        if (this.pat == null) {
            this.setFormatPattern(this.getFormatPattern());
        }
        int x = 0;
        while (x < FormatConstants.CURRENCY_FORMATS.length) {
            short cpt = (short)Integer.parseInt(FormatConstants.CURRENCY_FORMATS[x][1], 16);
            if (this.ifmt == cpt) {
                String ptx = FormatConstants.CURRENCY_FORMATS[x][0];
                if (cpt == 1) {
                    return this.pat.equals(ptx);
                }
                return true;
            }
            ++x;
        }
        Format fmt = this.getWorkBook().getFormat(this.ifmt);
        if (fmt == null) {
            return false;
        }
        String myfmt = fmt.getFormat();
        int x2 = 0;
        while (x2 < FormatConstants.CURRENCY_FORMATS.length) {
            if (FormatConstants.CURRENCY_FORMATS[x2][0].equals(myfmt)) {
                return true;
            }
            ++x2;
        }
        return false;
    }

    public short getForegroundColor() {
        if (this.fill != null) {
            return (short)this.fill.getFgColorAsInt(this.getWorkBook().getTheme());
        }
        return this.icvFore;
    }

    public String getForegroundColorHEX() {
        if (this.fill != null) {
            return this.fill.getFgColorAsRGB(this.getWorkBook().getTheme());
        }
        return FormatHandle.colorToHexString(FormatHandle.getColor(this.icvFore));
    }

    public String getBackgroundColorHEX() {
        if (this.fill != null) {
            return this.fill.getBgColorAsRGB(this.getWorkBook().getTheme());
        }
        if (this.icvBack == 65) {
            return "#FFFFFF";
        }
        return FormatHandle.colorToHexString(FormatHandle.getColor(this.icvBack));
    }

    public short getBackgroundColor() {
        if (this.fill != null) {
            return (short)this.fill.getBgColorAsInt(this.getWorkBook().getTheme());
        }
        if (this.icvBack == 65) {
            return 64;
        }
        return this.icvBack;
    }

    @Override
    public String getFormatPattern() {
        if (this.pat != null) {
            return this.pat;
        }
        String[][] fmts = FormatConstantsImpl.getBuiltinFormats();
        int x = 0;
        while (x < fmts.length) {
            if (this.ifmt == Integer.parseInt(fmts[x][1], 16)) {
                this.pat = fmts[x][0];
                return this.pat;
            }
            ++x;
        }
        Format fmt = this.getWorkBook().getFormat(this.ifmt);
        if (fmt != null) {
            this.pat = fmt.toString();
            return fmt.getFormat();
        }
        return null;
    }

    public void setFormatPattern(String pattern) {
        this.pat = pattern;
        if (this.getWorkBook() == null) {
            throw new IllegalStateException("attempting to set format pattern but workbook is null");
        }
        this.setFormat(Xf.addFormatPattern(this.getWorkBook(), pattern));
    }

    public static short addFormatPattern(WorkBook book, String pattern) {
        short ifmt = -1;
        ifmt = book.getFormatId(pattern);
        if (ifmt == -1) {
            Format format = new Format(book, pattern);
            ifmt = format.getIfmt();
        }
        return ifmt;
    }

    public void setFormat(short ifm) {
        this.ifmt = ifm;
        byte[] nef = ByteTools.shortToLEBytes(this.ifmt);
        this.getData()[2] = nef[0];
        this.getData()[3] = nef[1];
        this.pat = null;
    }

    public void setFont(int ifn) {
        this.ifnt = (short)ifn;
        byte[] nef = ByteTools.shortToLEBytes(this.ifnt);
        this.getData()[0] = nef[0];
        this.getData()[1] = nef[1];
        if (this.getWorkBook() != null) {
            this.myFont = this.getWorkBook().getFont(ifn);
        }
    }

    public void setMyFont(Font f) {
        this.myFont = f;
    }

    public void setPattern(int t) {
        this.fls = (short)t;
        this.updatePattern();
        if (this.fill != null) {
            this.fill.setFillPattern(t);
        }
    }

    public int getFillPattern() {
        if (this.fill != null) {
            return this.fill.getFillPatternInt();
        }
        return this.fls;
    }

    public short getBottomBorderLineStyle() {
        return this.dgBottom;
    }

    public short getTopBorderLineStyle() {
        return this.dgTop;
    }

    public short getLeftBorderLineStyle() {
        return this.dgLeft;
    }

    public short getRightBorderLineStyle() {
        return this.dgRight;
    }

    public short getDiagBorderLineStyle() {
        return this.dgDiag;
    }

    public void setTopBorderColor(int t) {
        if (t == 0) {
            t = 64;
        }
        this.icvTop = (short)t;
        this.updateBorderColors();
    }

    public int getTopBorderColor() {
        if (this.icvTop == 64) {
            return 65;
        }
        return this.icvTop;
    }

    public void setBottomBorderColor(int t) {
        if (t == 0) {
            t = 64;
        }
        this.icvBottom = (short)t;
        this.updateBorderColors();
    }

    public int getBottomBorderColor() {
        if (this.icvBottom == 64) {
            return 65;
        }
        return this.icvBottom;
    }

    public void setLeftBorderColor(int t) {
        if (t == 0) {
            t = 64;
        }
        this.icvLeft = (short)t;
        this.updateBorderColors();
    }

    public int getLeftBorderColor() {
        if (this.icvLeft == 64) {
            return 65;
        }
        return this.icvLeft;
    }

    public void setRightBorderColor(int t) {
        if (t == 0) {
            t = 64;
        }
        this.icvRight = (short)t;
        this.updateBorderColors();
    }

    public short getRightBorderColor() {
        if (this.icvRight == 64) {
            return 65;
        }
        return this.icvRight;
    }

    public void setDiagBorderColor(int t) {
        if (t == 0) {
            t = 64;
        }
        this.icvDiag = (short)t;
        this.updateBorderColors();
    }

    public short getDiagBorderColor() {
        if (this.icvDiag == 64) {
            return 65;
        }
        return this.icvDiag;
    }

    public void setLeftBorderColor(short t) {
        if (t == 0) {
            t = (short)64;
        }
        this.icvLeft = t;
        this.updateBorderColors();
    }

    public void setBorderDiag(int t) {
        this.Iflag = 0;
        this.Iflag |= this.icvTop;
        this.Iflag |= this.icvBottom << 7;
        this.Iflag |= (short)t << 14;
        this.Iflag |= this.dgDiag << 21;
        this.Iflag |= (short)this.mystery << 25;
        this.Iflag |= this.fls << 26;
        this.updatePattern();
    }

    public void setBorderLineStyle(short t) {
        this.dgLeft = t;
        this.dgRight = t;
        this.dgTop = t;
        this.dgBottom = t;
        this.updateBorders();
    }

    public void setAllBorderLineStyles(int[] b) {
        try {
            if (b[0] > -1) {
                this.dgTop = (short)b[0];
            }
            if (b[1] > -1) {
                this.dgLeft = (short)b[1];
            }
            if (b[2] > -1) {
                this.dgBottom = (short)b[2];
            }
            if (b[3] > -1) {
                this.dgRight = (short)b[3];
            }
            if (b[4] > -1) {
                this.dgDiag = (short)b[4];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.updateBorders();
    }

    public void setAllBorderColors(int[] b) {
        try {
            if (b[0] > -1) {
                this.icvTop = (short)b[0];
            }
            if (b[1] > -1) {
                this.icvLeft = (short)b[1];
            }
            if (b[2] > -1) {
                this.icvBottom = (short)b[2];
            }
            if (b[3] > -1) {
                this.icvRight = (short)b[3];
            }
            if (b[4] > -1) {
                this.icvDiag = (short)b[4];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.updateBorderColors();
    }

    public void setTopBorderLineStyle(short t) {
        this.dgTop = t;
        this.updateBorders();
    }

    public void setBottomBorderLineStyle(short t) {
        this.dgBottom = t;
        this.updateBorders();
    }

    public void setLeftBorderLineStyle(short t) {
        this.dgLeft = t;
        this.updateBorders();
    }

    public void setRightBorderLineStyle(short t) {
        this.dgRight = t;
        this.updateBorders();
    }

    public void updateBorders() {
        short borderflag = 0;
        borderflag = this.dgLeft;
        borderflag = (short)(borderflag | this.dgRight << 4);
        borderflag = (short)(borderflag | this.dgTop << 8);
        borderflag = (short)(borderflag | this.dgBottom << 12);
        byte[] bords = ByteTools.shortToLEBytes(borderflag);
        this.getData()[10] = bords[0];
        this.getData()[11] = bords[1];
        this.setAttributeFlag();
    }

    public void removeBorders() {
        this.dgBottom = 0;
        this.dgTop = 0;
        this.dgDiag = 0;
        this.dgLeft = 0;
        this.dgRight = 0;
        this.dgBottom = 0;
        this.updateBorders();
    }

    public void updateBorderColors() {
        this.setAttributeFlag();
    }

    public void updatePattern() {
        byte[] rkdata = this.getData();
        short thisFlag = 0;
        thisFlag = (short)(thisFlag | this.icvLeft);
        thisFlag = (short)(thisFlag | this.icvRight << 7);
        thisFlag = (short)(thisFlag | this.grbitDiag << 14);
        byte[] bytes = ByteTools.shortToLEBytes(thisFlag);
        rkdata[12] = bytes[0];
        rkdata[13] = bytes[1];
        this.Iflag = 0;
        this.Iflag |= this.icvTop;
        this.Iflag |= this.icvBottom << 7;
        this.Iflag |= this.icvDiag << 14;
        this.Iflag |= this.dgDiag << 21;
        this.Iflag |= (short)this.mystery << 25;
        this.Iflag |= this.fls << 26;
        byte[] nef = ByteTools.cLongToLEBytes(this.Iflag);
        rkdata[14] = nef[0];
        rkdata[15] = nef[1];
        rkdata[16] = nef[2];
        rkdata[17] = nef[3];
        this.pat = null;
        this.wkbook.updateFormatCache(this);
    }

    public void setForeColor(int t, Color clr) {
        this.icvColorFlag = 0;
        this.icvColorFlag = (short)(this.icvColorFlag | (short)t);
        this.icvColorFlag = (short)(this.icvColorFlag | this.icvBack << 7);
        if (clr != null) {
            if (!clr.equals(FormatHandle.COLORTABLE[t])) {
                if (this.fill == null) {
                    this.fill = new Fill(this.getFillPattern(), t, FormatHandle.colorToHexString(clr), this.icvBack, null, this.getWorkBook().getTheme());
                } else {
                    this.fill.setFgColor(t, FormatHandle.colorToHexString(clr));
                }
            }
        } else if (this.fill != null) {
            this.fill.setFgColor(t);
        }
        this.updateColors();
    }

    public void setBackColor(int t, Color clr) {
        this.icvColorFlag = 0;
        this.icvColorFlag = (short)(this.icvColorFlag | this.icvFore);
        this.icvColorFlag = (short)(this.icvColorFlag | (short)t << 7);
        if (clr != null) {
            if (!clr.equals(FormatHandle.COLORTABLE[t])) {
                if (this.fill == null) {
                    this.fill = new Fill(this.getFillPattern(), this.icvFore, null, t, FormatHandle.colorToHexString(clr), this.getWorkBook().getTheme());
                } else {
                    this.fill.setBgColor(t, FormatHandle.colorToHexString(clr));
                }
            }
        } else if (this.fill != null) {
            this.fill.setBgColor(t);
        }
        this.updateColors();
    }

    void updateColors() {
        byte[] rkdata = this.getData();
        byte[] nef = ByteTools.shortToLEBytes(this.icvColorFlag);
        rkdata[18] = nef[0];
        rkdata[19] = nef[1];
        this.icvFore = (short)(this.icvColorFlag & 0x7F);
        this.icvBack = (short)((this.icvColorFlag & 0x3F80) >> 7);
        this.pat = null;
        this.wkbook.updateFormatCache(this);
    }

    public void setBackgroundSolid() {
        this.setPattern(1);
        this.setBackColor(64, null);
        if (this.fill != null) {
            this.fill.setFillPattern(1);
        }
    }

    public boolean isBackgroundSolid() {
        if (this.fill != null) {
            return this.fill.isBackgroundSolid();
        }
        byte[] rkdata = this.getData();
        return rkdata[17] == 1;
    }

    private void setAttributeFlag() {
        this.setToCellXF();
        byte[] rkdata = this.getData();
        byte used_attrib = rkdata[9];
        byte borderFlag = (byte)(this.dgBottom > 0 || this.dgTop > 0 || this.dgLeft > 0 || this.dgRight > 0 || this.dgDiag > 0 ? 1 : 0);
        used_attrib = borderFlag == 1 ? (byte)(used_attrib | 0x20) : (byte)(used_attrib & 0xDF);
        used_attrib = this.cIndent != 0 || this.iReadingOrder != 0 || this.alc != 0 || this.alcV != 0 || this.fWrap != 0 || this.trot != 0 ? (byte)(used_attrib | 0x10) : (byte)(used_attrib & 0xEF);
        rkdata[9] = used_attrib;
        this.fAtrNum = (short)((used_attrib & 4) == 4 ? 1 : 0);
        this.fAtrFnt = (short)((used_attrib & 8) == 8 ? 1 : 0);
        this.fAtrAlc = (short)((used_attrib & 0x10) == 16 ? 1 : 0);
        this.fAtrBdr = (short)((used_attrib & 0x20) == 32 ? 1 : 0);
        this.fAtrPat = (short)((used_attrib & 0x40) == 64 ? 1 : 0);
        this.fAtrProt = (short)((used_attrib & 0x80) == 128 ? 1 : 0);
        if (this.dgTop > 0 && this.icvTop == 0) {
            this.icvTop = (short)64;
        }
        if (this.dgBottom > 0 && this.icvBottom == 0) {
            this.icvBottom = (short)64;
        }
        if (this.dgRight > 0 && this.icvRight == 0) {
            this.icvRight = (short)64;
        }
        if (this.dgLeft > 0 && this.icvLeft == 0) {
            this.icvLeft = (short)64;
        }
        if (this.dgDiag > 0 && this.icvDiag == 0) {
            this.icvDiag = (short)64;
        }
        this.updatePattern();
    }

    public void setToCellXF() {
        if (this.fStyle != 0) {
            this.fStyle = 0;
            byte flag = (byte)this.fLocked;
            this.getData()[4] = flag = (byte)(flag | this.fHidden << 1);
            this.getData()[5] = 0;
        }
    }

    public short getIfnt() {
        return this.ifnt;
    }

    public void setIfnt(short ifnt) {
        this.ifnt = ifnt;
    }

    public short getIfmt() {
        return this.ifmt;
    }

    public void setHorizontalAlignment(int hAlign) {
        this.alc = (short)hAlign;
        this.updateAlignment();
        this.setAttributeFlag();
    }

    public void setIndent(int indent) {
        this.cIndent = (short)indent;
        byte b = (byte)(this.getData()[8] & 0xF0);
        this.getData()[8] = b = (byte)(b | this.cIndent);
        if (this.alc != 1 || this.alc != 3) {
            this.setHorizontalAlignment(1);
        }
        this.setAttributeFlag();
    }

    public int getIndent() {
        return this.cIndent;
    }

    public void setRightToLeftReadingOrder(int rtl) {
        this.iReadingOrder = rtl == 2 ? (short)128 : (rtl == 1 ? (short)64 : (short)0);
        byte b = this.getData()[8];
        this.getData()[8] = b = (byte)(b | this.iReadingOrder);
        this.wkbook.updateFormatCache(this);
        this.setAttributeFlag();
    }

    public int getRightToLeftReadingOrder() {
        return this.iReadingOrder >> 6;
    }

    public int getHorizontalAlignment() {
        return this.alc;
    }

    public void setWrapText(boolean wraptext) {
        this.fWrap = wraptext ? (short)1 : 0;
        this.updateAlignment();
        this.setAttributeFlag();
    }

    public boolean getWrapText() {
        return this.fWrap == 1;
    }

    public void setVerticalAlignment(int vAlign) {
        this.alcV = (short)vAlign;
        this.updateAlignment();
        this.setAttributeFlag();
    }

    public int getVerticalAlignment() {
        return this.alcV;
    }

    public void setRotation(int rot) {
        this.trot = (short)rot;
        this.updateAlignment();
        this.setAttributeFlag();
    }

    public int getRotation() {
        return this.trot;
    }

    private void updateAlignment() {
        short tempfWrap = (short)(this.fWrap << 3);
        short tempAlcV = (short)(this.alcV << 4);
        short tempTrot = (short)(this.trot << 8);
        short res = 0;
        res = (short)(res | this.alc);
        res = (short)(res | tempfWrap);
        res = (short)(res | tempAlcV);
        res = (short)(res | tempTrot);
        byte[] rkdata = this.getData();
        byte[] bords = ByteTools.shortToLEBytes(res);
        rkdata[6] = bords[0];
        rkdata[7] = bords[1];
        this.wkbook.updateFormatCache(this);
    }

    public String getXML() {
        StringBuffer sb = new StringBuffer("<XF");
        sb.append(">");
        Font myf = this.getFont();
        sb.append("<font name=\"" + myf.getFontName());
        sb.append("\" size=\"" + myf.getFontHeightInPoints());
        sb.append("\" color=\"" + FormatHandle.colorToHexString(myf.getColorAsColor()));
        sb.append("\" weight=\"" + myf.getFontWeight());
        if (myf.getIsBold()) {
            sb.append("\" bold=\"1");
        }
        sb.append("\" />");
        sb.append("<format id=\"" + this.ifmt);
        sb.append("\" />");
        sb.append("<fill id=\"" + this.fls);
        sb.append("\" />");
        sb.append("<Borders>");
        if (this.getRightBorderLineStyle() != 0) {
            sb.append("<Border");
            sb.append(" Position=\"right\"");
            sb.append(" LineStyle=\"" + FormatHandle.BORDER_NAMES[this.getRightBorderLineStyle()] + "\"");
            sb.append(" Color=\"" + FormatHandle.colorToHexString(this.wkbook.colorTable[this.getRightBorderColor()]) + "\"");
            sb.append("/>");
        }
        if (this.getBottomBorderLineStyle() != 0) {
            sb.append("<Border");
            sb.append(" Position=\"bottom\"");
            sb.append(" LineStyle=\"" + FormatHandle.BORDER_NAMES[this.getBottomBorderLineStyle()] + "\"");
            sb.append(" Color=\"" + FormatHandle.colorToHexString(this.wkbook.colorTable[this.getBottomBorderColor()]) + "\"");
            sb.append("/>");
        }
        if (this.getLeftBorderLineStyle() != 0) {
            sb.append("<Border");
            sb.append(" Position=\"left\"");
            sb.append(" LineStyle=\"" + FormatHandle.BORDER_NAMES[this.getLeftBorderLineStyle()] + "\"");
            sb.append(" Color=\"" + FormatHandle.colorToHexString(this.wkbook.colorTable[this.getLeftBorderColor()]) + "\"");
            sb.append("/>");
        }
        if (this.getTopBorderLineStyle() != 0) {
            sb.append("<Border");
            sb.append(" Position=\"top\"");
            sb.append(" LineStyle=\"" + FormatHandle.BORDER_NAMES[this.getTopBorderLineStyle()] + "\"");
            sb.append(" Color=\"" + FormatHandle.colorToHexString(this.wkbook.colorTable[this.getTopBorderColor()]) + "\"");
            sb.append("/>");
        }
        sb.append("</Borders>");
        sb.append("<Alignment");
        sb.append(" Horizontal=\"" + FormatHandle.HORIZONTAL_ALIGNMENTS[this.getHorizontalAlignment()] + "\"");
        sb.append(" />");
        if (this.wkbook.colorTable[this.getForegroundColor()] != Color.WHITE) {
            sb.append("<Interior Color=\"" + FormatHandle.colorToHexString(this.wkbook.colorTable[this.getForegroundColor()]) + "\"/>");
        }
        sb.append("</XF>");
        return sb.toString();
    }

    public Format getFormat() {
        return this.myFormat;
    }

    public void setFormat(Format myFormat) {
        this.myFormat = myFormat;
    }

    public boolean isFormulaHidden() {
        return this.fHidden == 1;
    }

    public void setFormulaHidden(boolean hd) {
        this.fHidden = hd ? (short)1 : 0;
        this.updateLockedHidden();
    }

    public boolean isLocked() {
        return this.fLocked == 1;
    }

    public boolean isShrinkToFit() {
        return this.fShrinkToFit == 1;
    }

    public void setShrinkToFit(boolean b) {
        if (b) {
            this.fShrinkToFit = 1;
            byte[] byArray = this.getData();
            byArray[9] = (byte)(byArray[9] | 0x10);
        } else {
            this.fShrinkToFit = 0;
            byte[] byArray = this.getData();
            byArray[9] = (byte)(byArray[9] & 0xF7);
        }
    }

    public void setLocked(boolean lk) {
        this.fLocked = lk ? (short)1 : 0;
        this.updateLockedHidden();
    }

    private void updateLockedHidden() {
        short tempFL = (short)(this.fLocked << 0);
        short tempFH = (short)(this.fHidden << 1);
        short tempST = (short)(this.fStyle << 2);
        short flag = 0;
        flag = (short)(flag | tempFL);
        flag = (short)(flag | tempFH);
        flag = (short)(flag | tempST);
        byte[] dx = this.getData();
        byte[] nef = ByteTools.shortToLEBytes(flag);
        dx[4] = nef[0];
        dx[5] = nef[1];
        this.pat = null;
        this.wkbook.updateFormatCache(this);
    }

    public boolean getStricken() {
        if (this.myFont != null) {
            return this.myFont.getStricken();
        }
        return false;
    }

    public void setStricken(boolean b) {
        if (this.myFont != null) {
            this.myFont.setStricken(b);
        }
    }

    public boolean getItalic() {
        if (this.myFont != null) {
            return this.myFont.getItalic();
        }
        return false;
    }

    public void setItalic(boolean b) {
        if (this.myFont != null) {
            this.myFont.setItalic(b);
        }
    }

    public boolean getUnderlined() {
        if (this.myFont != null) {
            return this.myFont.getUnderlined();
        }
        return false;
    }

    public void setUnderlined(boolean b) {
        if (this.myFont != null) {
            this.myFont.setUnderlined(b);
        }
    }

    public boolean getBold() {
        if (this.myFont != null) {
            return this.myFont.getBold();
        }
        return false;
    }

    public void setBold(boolean b) {
        if (this.myFont != null) {
            this.myFont.setBold(b);
        }
    }

    public int getIdx() {
        return this.tableidx;
    }

    public boolean isStyleXf() {
        return this.fStyle == 1;
    }

    private static Xf cloneXf(Xf xf, WorkBook wkbook) {
        Xf clone;
        if (xf.getIdx() > -1) {
            clone = new Xf(xf.ifnt, wkbook);
            byte[] xfbytes = xf.getBytesAt(0, xf.getLength() - 4);
            clone.setData(xfbytes);
            clone.init();
        } else {
            clone = xf;
        }
        clone.fill = xf.fill;
        clone.setToCellXF();
        clone.tableidx = wkbook.insertXf(clone);
        return clone;
    }

    public static Xf updateXf(Xf xf, int fontIdx, WorkBook wkbook) {
        if (xf == null) {
            xf = new Xf(fontIdx, wkbook);
            xf.tableidx = wkbook.insertXf(xf);
            return xf;
        }
        xf = Xf.cloneXf(xf, wkbook);
        return xf;
    }

    public void setFill(Fill f) {
        this.fill = (Fill)f.cloneElement();
        this.fls = (short)this.fill.getFillPatternInt();
        this.icvFore = (short)this.fill.getFgColorAsInt(this.getWorkBook().getTheme());
        this.icvBack = (short)this.fill.getBgColorAsInt(this.getWorkBook().getTheme());
    }

    public Fill getFill() {
        return this.fill;
    }

    @Override
    public void close() {
        super.close();
        this.myFont.close();
        this.myFormat = null;
    }
}

