/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class Area
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -4600344312324775780L;
    private short grbit = 0;
    protected boolean fStacked = false;
    protected boolean f100 = false;
    protected boolean fHasShadow = false;
    private byte[] PROTOTYPE_BYTES = new byte[2];

    @Override
    public void init() {
        super.init();
        this.grbit = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.fStacked = (this.grbit & 1) == 1;
        this.f100 = (this.grbit & 2) == 2;
        this.fHasShadow = (this.grbit & 4) == 4;
        this.chartType = 4;
    }

    protected void updateRecord() {
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fStacked, 0);
        this.grbit = ByteTools.updateGrBit(this.grbit, this.f100, 1);
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fHasShadow, 2);
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    public static XLSRecord getPrototype() {
        Area b = new Area();
        b.setOpcode((short)4122);
        b.setData(b.PROTOTYPE_BYTES);
        b.init();
        return b;
    }

    @Override
    public void setIsStacked(boolean bIsStacked) {
        this.fStacked = bIsStacked;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fStacked, 0);
        this.updateRecord();
    }

    @Override
    public void setIs100Percent(boolean bOn) {
        this.f100 = bOn;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.f100, 1);
        this.updateRecord();
    }

    @Override
    public boolean isStacked() {
        return this.fStacked;
    }

    @Override
    public boolean is100Percent() {
        return this.f100;
    }

    @Override
    public boolean setChartOption(String op, String val) {
        boolean bHandled = false;
        if (op.equalsIgnoreCase("Stacked")) {
            this.fStacked = val.equals("true");
            bHandled = true;
        } else if (op.equalsIgnoreCase("PercentageDisplay")) {
            this.f100 = val.equals("true");
            bHandled = true;
        } else if (op.equalsIgnoreCase("Shadow")) {
            this.fHasShadow = val.equals("true");
            bHandled = true;
        }
        if (bHandled) {
            this.updateRecord();
        }
        return bHandled;
    }

    @Override
    public String getOptionsXML() {
        StringBuffer sb = new StringBuffer();
        if (this.fStacked) {
            sb.append(" Stacked=\"true\"");
        }
        if (this.f100) {
            sb.append(" PercentageDisplay=\"true\"");
        }
        if (this.fHasShadow) {
            sb.append(" Shadow=\"true\"");
        }
        return sb.toString();
    }
}

