/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.Area;
import com.extentech.formats.XLS.charts.AreaChart;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartLine;
import com.extentech.formats.XLS.charts.GenericChartObject;

public class Area3DChart
extends AreaChart {
    public Area3DChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
        this.area = (Area)charttype;
    }

    @Override
    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        ChartLine cl;
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:area3DChart>");
        cooxml.append("\r\n");
        cooxml.append("<c:grouping val=\"");
        if (this.is100PercentStacked()) {
            cooxml.append("percentStacked");
        } else if (this.isStacked()) {
            cooxml.append("stacked");
        } else {
            cooxml.append("standard");
        }
        cooxml.append("\"/>");
        cooxml.append("\r\n");
        cooxml.append(this.getParentChart().getChartSeries().getOOXML(this.getChartType(), false, 0));
        int gapdepth = this.getGapDepth();
        if (gapdepth != 0 && gapdepth != 150) {
            cooxml.append("<c:gapDepth val=\"" + gapdepth + "\"/>");
        }
        if ((cl = this.cf.getChartLinesRec()) != null) {
            cooxml.append(cl.getOOXML());
        }
        cooxml.append("<c:axId val=\"" + catAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("<c:axId val=\"" + valAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("<c:axId val=\"" + serAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("</c:area3DChart>");
        cooxml.append("\r\n");
        return cooxml;
    }
}

