/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.FormatHandle;
import com.extentech.formats.OOXML.FillGroup;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.XLS.FormatConstants;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;
import java.awt.Color;

public class AreaFormat
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -437132913972684937L;
    private Color rgbFore;
    private Color rgbBack;
    private short fls = 0;
    private short grbit = 0;
    private short icvFore = 0;
    private short icvBack = 0;
    boolean fAuto;
    boolean fInvertNeg;
    private byte[] PROTOTYPE_BYTES;
    private byte[] PROTOTYPE_BYTES_1;
    private byte[] PROTOTYPE_BYTES_2;

    public AreaFormat() {
        byte[] byArray = new byte[16];
        byArray[10] = 1;
        byArray[12] = 77;
        byArray[14] = 77;
        this.PROTOTYPE_BYTES = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = -64;
        byArray2[1] = -64;
        byArray2[2] = -64;
        byArray2[8] = 1;
        byArray2[12] = 22;
        byArray2[14] = 79;
        this.PROTOTYPE_BYTES_1 = byArray2;
        byte[] byArray3 = new byte[16];
        byArray3[4] = -1;
        byArray3[5] = -1;
        byArray3[6] = -1;
        byArray3[8] = 1;
        byArray3[10] = 1;
        byArray3[12] = 77;
        byArray3[14] = 78;
        this.PROTOTYPE_BYTES_2 = byArray3;
    }

    @Override
    public void init() {
        super.init();
        byte[] data = this.getData();
        this.grbit = ByteTools.readShort(data[10], data[11]);
        this.fAuto = (this.grbit & 1) == 1;
        this.fInvertNeg = (this.grbit & 2) == 2;
        this.rgbFore = new Color(data[0] < 0 ? 255 + data[0] : data[0], data[1] < 0 ? 255 + data[1] : data[1], data[2] < 0 ? 255 + data[2] : data[2]);
        this.rgbBack = new Color(data[4] < 0 ? 255 + data[4] : data[4], data[5] < 0 ? 255 + data[5] : data[5], data[6] < 0 ? 255 + data[6] : data[6]);
        this.fls = ByteTools.readShort(data[8], data[9]);
        this.icvFore = ByteTools.readShort(data[12], data[13]);
        this.icvBack = ByteTools.readShort(data[14], data[15]);
    }

    public static XLSRecord getPrototype() {
        AreaFormat af = new AreaFormat();
        af.setOpcode((short)4106);
        af.setData(af.PROTOTYPE_BYTES);
        af.init();
        return af;
    }

    public static XLSRecord getPrototype(int type) {
        AreaFormat af = new AreaFormat();
        af.setOpcode((short)4106);
        if (type == 0) {
            af.setData(af.PROTOTYPE_BYTES_1);
        } else if (type == 1) {
            af.setData(af.PROTOTYPE_BYTES_2);
        } else {
            af.setData(af.PROTOTYPE_BYTES);
        }
        af.init();
        return af;
    }

    private void updateRecord() {
        byte[] b = new byte[]{(byte)this.rgbFore.getRed(), (byte)this.rgbFore.getGreen(), (byte)this.rgbFore.getBlue(), 0};
        System.arraycopy(b, 0, this.getData(), 0, 4);
        b[0] = (byte)this.rgbBack.getRed();
        b[1] = (byte)this.rgbBack.getGreen();
        b[2] = (byte)this.rgbBack.getBlue();
        b[3] = 0;
        System.arraycopy(b, 0, this.getData(), 4, 4);
        b = ByteTools.shortToLEBytes(this.fls);
        this.getData()[8] = b[0];
        this.getData()[9] = b[1];
        this.grbit = 0;
        if (this.fAuto) {
            this.grbit = 1;
        }
        if (this.fInvertNeg) {
            this.grbit = (short)(this.grbit | 2);
        }
        b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[10] = b[0];
        this.getData()[11] = b[1];
        b = ByteTools.shortToLEBytes(this.icvFore);
        this.getData()[12] = b[0];
        this.getData()[13] = b[1];
        b = ByteTools.shortToLEBytes(this.icvBack);
        this.getData()[14] = b[0];
        this.getData()[15] = b[1];
    }

    @Override
    public String toString() {
        return "AreaFormat: Pattern=" + this.fls + " ForeColor=" + this.icvFore + " BackColor=" + this.icvBack + " Automatic Format=" + ((this.grbit & 1) == 1);
    }

    public int geticvBack() {
        if (this.icvBack > this.getColorTable().length) {
            return FormatHandle.interpretSpecialColorIndex(this.icvBack);
        }
        return this.icvBack;
    }

    public int getFillColor() {
        if (this.fls == 0) {
            return 1;
        }
        if (this.fls == 1) {
            return this.geticvFore();
        }
        if (this.fls == 2) {
            return 23;
        }
        if (this.fls == 3) {
            return 63;
        }
        if (this.fls == 4) {
            return 22;
        }
        return this.geticvFore();
    }

    public String getFillColorStr() {
        if (this.fAuto) {
            return null;
        }
        if (this.fls == 0) {
            return "#FFFFFF";
        }
        if (this.fls == 1) {
            return FormatHandle.colorToHexString(this.rgbFore);
        }
        if (this.fls == 2) {
            return FormatHandle.colorToHexString(FormatConstants.Gray50);
        }
        if (this.fls == 3) {
            return FormatHandle.colorToHexString(FormatConstants.Gray80);
        }
        if (this.fls == 4) {
            return FormatHandle.colorToHexString(FormatConstants.Gray25);
        }
        return FormatHandle.colorToHexString(this.rgbFore);
    }

    public int geticvFore() {
        if (this.icvFore > this.getColorTable().length) {
            return FormatHandle.interpretSpecialColorIndex(this.icvFore);
        }
        return this.icvFore;
    }

    public void seticvBack(int clr) {
        if (clr > -1 && clr < this.getColorTable().length) {
            this.icvBack = (short)clr;
            this.rgbBack = this.getColorTable()[clr];
            this.updateRecord();
        } else if (clr == 77) {
            this.icvBack = (short)clr;
            this.rgbBack = this.getColorTable()[0];
            this.updateRecord();
        }
    }

    public void seticvFore(int clr) {
        if (clr > -1 && clr < this.getColorTable().length) {
            this.fAuto = false;
            this.fls = 1;
            this.icvFore = (short)clr;
            this.rgbFore = this.getColorTable()[clr];
            this.seticvBack(9);
        } else if (clr == 78) {
            this.icvFore = (short)clr;
            this.rgbFore = this.getColorTable()[1];
            this.updateRecord();
        }
    }

    public void seticvFore(String clr) {
        this.fAuto = false;
        this.fls = 1;
        this.rgbFore = FormatHandle.HexStringToColor(clr);
        this.icvFore = (short)FormatHandle.HexStringToColorInt(clr, FormatHandle.colorBACKGROUND);
        this.updateRecord();
    }

    public void setFromOOXML(SpPr sp) {
        FillGroup f = sp.getFill();
        if (f != null) {
            this.seticvFore(f.getColor());
        }
    }

    public StringBuffer getOOXML() {
        StringBuffer ooxml = new StringBuffer();
        ooxml.append("<a:solidFill>");
        ooxml.append("</a:solidFill>");
        return ooxml;
    }
}

