/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.charts.Axis;
import com.extentech.formats.XLS.charts.Bar;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartFormatLink;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.Frame;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.PlotArea;
import com.extentech.formats.XLS.charts.SeriesList;
import com.extentech.formats.XLS.charts.TextDisp;
import com.extentech.toolkit.ByteTools;

public class AxisParent
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -2247258217367570732L;
    private short iax = 0;
    private int x = 0;
    private int y = 0;
    private int dx = 0;
    private int dy = 0;

    @Override
    public void init() {
        super.init();
        this.iax = ByteTools.readShort(this.getData()[0], this.getData()[1]);
        this.x = ByteTools.readInt(this.getBytesAt(2, 4));
        this.y = ByteTools.readInt(this.getBytesAt(6, 4));
        this.dx = ByteTools.readInt(this.getBytesAt(10, 4));
        this.dy = ByteTools.readInt(this.getBytesAt(14, 4));
    }

    protected ChartFormat getChartFormat() {
        return this.getChartFormat(0, false);
    }

    protected ChartFormat getChartFormat(int nChart, boolean addNew) {
        int i = 0;
        while (i < this.chartArr.size()) {
            ChartFormat cf;
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4116 && (cf = (ChartFormat)b).getDrawingOrder() == nChart) {
                return cf;
            }
            ++i;
        }
        if (addNew) {
            return this.createNewChart(nChart);
        }
        return null;
    }

    protected ChartFormat createNewChart(int nChart) {
        if (nChart > 0 && nChart <= 9) {
            ChartFormat cf = (ChartFormat)ChartFormat.getPrototype();
            cf.setParentChart(this.getParentChart());
            Bar b = (Bar)Bar.getPrototype();
            cf.chartArr.add(b);
            ChartFormatLink cfl = (ChartFormatLink)ChartFormatLink.getPrototype();
            cf.chartArr.add(cfl);
            SeriesList sl = new SeriesList();
            sl.setOpcode((short)4118);
            sl.setParentChart(this.getParentChart());
            cf.chartArr.add(sl);
            cf.setDrawingOrder(nChart);
            this.chartArr.add(cf);
            return cf;
        }
        return null;
    }

    public void removeAxes() {
        if (this.chartArr.get(1) instanceof Axis) {
            this.chartArr.remove(1);
        }
        if (this.chartArr.get(1) instanceof Axis) {
            this.chartArr.remove(1);
        }
        if (this.chartArr.get(1) instanceof TextDisp) {
            this.chartArr.remove(1);
        }
        if (this.chartArr.get(1) instanceof TextDisp) {
            this.chartArr.remove(1);
        }
        if (this.chartArr.get(1) instanceof PlotArea) {
            this.chartArr.remove(1);
        }
        if (this.chartArr.get(1) instanceof Frame) {
            this.chartArr.remove(1);
        }
    }

    public void removeAxis(int axisType) {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4125 && ((Axis)b).getAxis() == axisType) {
                this.chartArr.remove(i);
                break;
            }
            ++i;
        }
        int tdType = TextDisp.convertType(axisType);
        int i2 = 0;
        while (i2 < this.chartArr.size()) {
            TextDisp td;
            BiffRec b = (BiffRec)this.chartArr.get(i2);
            if (b.getOpcode() == 4133 && tdType == (td = (TextDisp)b).getType()) {
                this.chartArr.remove(i2);
                break;
            }
            ++i2;
        }
    }

    protected void removePlotArea() {
        boolean remove = false;
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4125) {
                remove = true;
            } else {
                if (b.getOpcode() == 4116) break;
                if (remove) {
                    this.chartArr.remove(i);
                    --i;
                }
            }
            ++i;
        }
    }

    protected String getAxisOptionsXML(int axis) {
        boolean bHasAxis = false;
        boolean bHasLabel = false;
        StringBuffer sb = new StringBuffer();
        int tdType = TextDisp.convertType(axis);
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4125) {
                if (((Axis)b).getAxis() == axis) {
                    sb.append(((Axis)b).getOptionsXML());
                    bHasAxis = true;
                }
            } else if (b.getOpcode() == 4133 && ((TextDisp)b).getType() == tdType) {
                sb.append(((TextDisp)b).getOptionsXML());
                bHasLabel = true;
                break;
            }
            ++i;
        }
        if (bHasAxis && !bHasLabel) {
            sb.append(" Label=\"\"");
        }
        return sb.toString();
    }

    public Axis getAxis(int axisType) {
        return this.getAxis(axisType, true);
    }

    public Axis getAxis(int axisType, boolean bCreateIfNecessary) {
        int lastTd = 0;
        int lastAxis = 0;
        Axis a = null;
        TextDisp td = null;
        int tdType = TextDisp.convertType(axisType);
        int i = 0;
        while (i < this.chartArr.size() && td == null) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b.getOpcode() == 4125) {
                lastAxis = i;
                if (((Axis)b).getAxis() == axisType) {
                    a = (Axis)b;
                    a.setAP(this);
                }
            } else if (b.getOpcode() == 4133) {
                lastTd = i;
                if (tdType == ((TextDisp)b).getType()) {
                    td = (TextDisp)b;
                    if (bCreateIfNecessary) {
                        td.setText("");
                    }
                }
            }
            ++i;
        }
        if (a == null && bCreateIfNecessary) {
            td = (TextDisp)TextDisp.getPrototype(axisType, "", this.wkbook);
            td.setParentChart(this.getParentChart());
            this.chartArr.add(lastTd + 1, td);
            a = (Axis)Axis.getPrototype(axisType);
            a.setParentChart(this.getParentChart());
            this.chartArr.add(lastAxis + 1, a);
            a.setAP(this);
        }
        if (a != null) {
            a.setTd(td);
        }
        return a;
    }

    public String getPlotAreaBgColor() {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b instanceof Frame) {
                return ((Frame)b).getBgColor();
            }
            ++i;
        }
        return null;
    }

    public void setPlotAreaBgColor(int bg) {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b instanceof Frame) {
                ((Frame)b).setBgColor(bg);
                break;
            }
            ++i;
        }
    }

    public void setPlotAreaBorder(int lw, int lclr) {
        int i = 0;
        while (i < this.chartArr.size()) {
            BiffRec b = (BiffRec)this.chartArr.get(i);
            if (b instanceof Frame) {
                ((Frame)b).addBox(lw, lclr, -1);
                break;
            }
            ++i;
        }
    }

    public boolean isSecondaryAxis() {
        return this.iax == 1;
    }

    public void setIsSecondaryAxis(boolean b) {
        this.iax = b ? (short)1 : 0;
        this.getData()[0] = (byte)this.iax;
    }
}

