/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.ChartSeriesHandle;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.Bar;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartLine;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class BarChart
extends ChartType {
    protected Bar bar = null;

    public BarChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
        this.bar = (Bar)charttype;
        this.defaultShape = 0;
    }

    public void setDefaultShape(int shape) {
        this.defaultShape = shape;
    }

    public int getDefaultShape() {
        return this.defaultShape;
    }

    @Override
    public boolean isClustered() {
        return !this.isStacked() && !this.is100PercentStacked();
    }

    @Override
    public int getBarShape() {
        return this.cf.getBarShape();
    }

    public String getOptionsXML() {
        StringBuffer sb = new StringBuffer();
        if (this.bar.fStacked) {
            sb.append(" Stacked=\"true\"");
        }
        if (this.bar.f100) {
            sb.append(" PercentageDisplay=\"true\"");
        }
        if (this.bar.fHasShadow) {
            sb.append(" Shadow=\"true\"");
        }
        if (this.bar.pcOverlap != 0) {
            sb.append(" Overlap=\"" + this.bar.pcOverlap + "\"");
        }
        if (this.bar.pcGap != 50 && this.bar.pcGap != 150) {
            sb.append(" Gap=\"" + this.bar.pcGap + "\"");
        }
        return sb.toString();
    }

    @Override
    public JSONObject getTypeJSON() throws JSONException {
        JSONObject typeJSON = new JSONObject();
        return typeJSON;
    }

    public JSONObject getJSON(ChartSeriesHandle[] series, WorkBookHandle wbh, Double[] minMax) throws JSONException {
        JSONObject chartObjectJSON = new JSONObject();
        return chartObjectJSON;
    }

    @Override
    public String getSVG(HashMap<String, Double> chartMetrics, HashMap<String, Object> axisMetrics, ChartSeries s) {
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        double min = chartMetrics.get("min");
        Object[] categories = s.getCategories();
        ArrayList series = s.getSeriesValues();
        String[] seriescolors = s.getSeriesBarColors();
        String[] legends = s.getLegends();
        if (series.size() == 0) {
            Logger.logErr("Bar.getSVG: error in series");
            return "";
        }
        StringBuffer svg = new StringBuffer();
        int shape = this.cf.getBarShape();
        if (shape == 257 || shape == 1 || shape == 256) {
            // empty if block
        }
        int[] dls = this.getDataLabelInts();
        int n = series.size();
        svg.append("<g>\r\n");
        double barw = 0.0;
        double yfactor = 0.0;
        barw = h / (((double)categories.length + 1.0) * (double)(n + 1));
        if (max != 0.0) {
            yfactor = w / max;
        }
        boolean rf = true;
        double y0 = h + y - barw * 0.5;
        int i = 0;
        while (i < n) {
            svg.append("<g>\r\n");
            double[] curseries = (double[])series.get(i);
            String[] curranges = (String[])s.getSeriesRanges().get(i);
            int j = 0;
            while (j < curseries.length) {
                double yy = y0 - barw * (double)(n + 1) * 1.1 * (double)j - barw * (double)(i + 1) - barw * 1.5 * (double)rf;
                double ww = yfactor * curseries[j];
                svg.append("<rect " + BarChart.getScript(curranges[j]) + " fill='" + seriescolors[i] + "' fill-opacity='1' stroke='black' stroke-opacity='1' stroke-width='1' stroke-linecap='butt' stroke-linejoin='miter' stroke-miterlimit='4'" + " x='" + x + "' y='" + yy + "' width='" + ww + "' height='" + barw + "' fill-rule='evenodd'/>");
                String l = this.getSVGDataLabels(dls, axisMetrics, curseries[j], 0.0, i, legends, categories[j].toString());
                if (l != null) {
                    svg.append("<text x='" + (x + ww + 10.0) + "' y='" + (yy + barw * (double)rf) + "' " + BarChart.getDataLabelFontSVG() + ">" + l + "</text>\r\n");
                }
                ++j;
            }
            svg.append("</g>\r\n");
            ++i;
        }
        svg.append("</g>\r\n");
        return svg.toString();
    }

    @Override
    public StringBuffer getOOXML(String catAxisId, String valAxisId, String serAxisId) {
        ChartLine cl;
        StringBuffer cooxml = new StringBuffer();
        cooxml.append("<c:barChart>");
        cooxml.append("\r\n");
        cooxml.append("<c:barDir val=\"bar\"/>");
        cooxml.append("<c:grouping val=\"");
        if (this.is100PercentStacked()) {
            cooxml.append("percentStacked");
        } else if (this.isStacked()) {
            cooxml.append("stacked");
        } else if (this.isClustered()) {
            cooxml.append("clustered");
        } else {
            cooxml.append("standard");
        }
        cooxml.append("\"/>");
        cooxml.append("\r\n");
        cooxml.append(this.getParentChart().getChartSeries().getOOXML(this.getChartType(), false, 0));
        if (!this.getChartOption("Gap").equals("150")) {
            cooxml.append("<c:gapWidth val=\"" + this.getChartOption("Gap") + "\"/>");
        }
        if (!this.getChartOption("Overlap").equals("0")) {
            cooxml.append("<c:overlap val=\"" + this.getChartOption("Overlap") + "\"/>");
        }
        if ((cl = this.cf.getChartLinesRec()) != null) {
            cooxml.append(cl.getOOXML());
        }
        cooxml.append("<c:axId val=\"" + catAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("<c:axId val=\"" + valAxisId + "\"/>");
        cooxml.append("\r\n");
        cooxml.append("</c:barChart>");
        cooxml.append("\r\n");
        return cooxml;
    }
}

