/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.formats.OOXML.SpPr;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.LineFormat;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;

public class ChartLine
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -8311605814020380069L;
    private short id;
    private ChartFormat cf;
    public static byte TYPE_DROPLINE = 0;
    public static byte TYPE_HILOWLINE = 1;
    public static byte TYPE_SERIESLINE = (byte)2;
    public static byte TYPE_LEADERLINE = (byte)3;

    @Override
    public void init() {
        super.init();
        this.id = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
    }

    public static XLSRecord getPrototype() {
        ChartLine cl = new ChartLine();
        cl.setOpcode((short)4124);
        cl.setData(new byte[2]);
        cl.init();
        return cl;
    }

    public int getLineType() {
        return this.id;
    }

    public void setLineType(int id) {
        this.id = (short)id;
        byte[] b = ByteTools.shortToLEBytes(this.id);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    private LineFormat findLineFormatRec() {
        LineFormat lf = null;
        int i = 0;
        while (i < this.cf.chartArr.size()) {
            if (((XLSRecord)this.cf.chartArr.get(i)).equals(this)) {
                lf = (LineFormat)this.cf.chartArr.get(i + 1);
                break;
            }
            ++i;
        }
        return lf;
    }

    public void parseOOXML(XmlPullParser xpp, Stack<String> lastTag, ChartFormat cf, WorkBookHandle bk) {
        this.cf = cf;
        String endTag = lastTag.peek();
        try {
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                block7: {
                    block6: {
                        if (eventType != 2) break block6;
                        String tnm = xpp.getName();
                        if (!tnm.equals("spPr")) break block7;
                        lastTag.push(tnm);
                        SpPr sppr = (SpPr)SpPr.parseOOXML(xpp, lastTag, bk).cloneElement();
                        LineFormat lf = this.findLineFormatRec();
                        if (lf == null) break block7;
                        lf.setFromOOXML(sppr);
                        break block7;
                    }
                    if (eventType == 3) {
                        if (xpp.getName().equals(endTag)) {
                            lastTag.pop();
                        }
                        break;
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            Logger.logErr("ChartLine.parseOOXML: " + e.toString());
        }
    }

    public StringBuffer getOOXML() {
        StringBuffer cooxml = new StringBuffer();
        String tag = null;
        if (this.id == TYPE_DROPLINE) {
            tag = "c:dropLines>";
        } else if (this.id == TYPE_HILOWLINE) {
            tag = "c:hiLowLines>";
        } else if (this.id == TYPE_SERIESLINE) {
            tag = "c:serLines>";
        }
        cooxml.append("<" + tag);
        LineFormat lf = this.findLineFormatRec();
        if (lf != null) {
            cooxml.append(lf.getOOXML());
        }
        cooxml.append("</" + tag);
        return cooxml;
    }
}

