/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.AreaFormat;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.LineFormat;
import com.extentech.toolkit.ByteTools;

public class Dropbar
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 6826327230442065566L;
    short pcGap;

    @Override
    public void init() {
        super.init();
        this.pcGap = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
    }

    public static XLSRecord getPrototype() {
        Dropbar db = new Dropbar();
        db.setOpcode((short)4157);
        byte[] byArray = new byte[2];
        byArray[0] = -106;
        db.setData(byArray);
        db.init();
        return db;
    }

    public void setGapWidth(int gap) {
        this.pcGap = (short)gap;
        byte[] b = ByteTools.shortToLEBytes(this.pcGap);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    public short getGapWidth() {
        return this.pcGap;
    }

    public StringBuffer getOOXML(boolean upBars) {
        StringBuffer cooxml = new StringBuffer();
        String tag = upBars ? "c:upBars>" : "c:downBars>";
        cooxml.append("<" + tag);
        LineFormat lf = (LineFormat)this.chartArr.get(0);
        cooxml.append(lf.getOOXML());
        if (!this.parentChart.getWorkBook().getIsExcel2007()) {
            AreaFormat af = (AreaFormat)this.chartArr.get(1);
            cooxml.append(af.getOOXML());
        }
        cooxml.append("</" + tag);
        return cooxml;
    }
}

