/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.Font;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.Chart;
import com.extentech.formats.XLS.charts.ChartConstants;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.ChartType;
import com.extentech.formats.XLS.charts.CrtLayout12;
import com.extentech.formats.XLS.charts.Fontx;
import com.extentech.formats.XLS.charts.Frame;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.formats.XLS.charts.MarkerFormat;
import com.extentech.formats.XLS.charts.Pos;
import com.extentech.formats.XLS.charts.TextDisp;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.StringTool;
import java.util.HashMap;

public class Legend
extends GenericChartObject
implements ChartObject,
ChartConstants {
    private static final long serialVersionUID = -4041111720696805018L;
    protected int x_defunct = -1;
    protected int y_defunct = -1;
    protected int dx_defunct = -1;
    protected int dy_defunct = -1;
    protected byte wSpacing = (byte)-1;
    protected short grbit = (short)-1;
    protected boolean fAutoPosition;
    protected boolean fAutoSeries;
    protected boolean fAutoPosX;
    protected boolean fAutoPosY;
    protected boolean fVert;
    protected boolean fWasDataTable;
    public static final int BOTTOM = 0;
    public static final int CORNER = 1;
    public static final int TOP = 2;
    public static final int RIGHT = 3;
    public static final int LEFT = 4;
    public static final int NOT_DOCKED = 7;
    int[] legendCoords = null;
    private byte[] PROTOTYPE_BYTES;
    int XOFFSET;

    public Legend() {
        byte[] byArray = new byte[20];
        byArray[0] = -11;
        byArray[1] = 13;
        byArray[4] = -72;
        byArray[5] = 3;
        byArray[8] = -111;
        byArray[9] = 1;
        byArray[12] = -31;
        byArray[13] = 4;
        byArray[16] = 3;
        byArray[17] = 1;
        byArray[18] = 31;
        this.PROTOTYPE_BYTES = byArray;
        this.XOFFSET = 12;
    }

    @Override
    public void init() {
        super.init();
        byte[] rkdata = this.getData();
        this.x_defunct = ByteTools.readInt(this.getBytesAt(0, 4));
        this.y_defunct = ByteTools.readInt(this.getBytesAt(4, 4));
        this.dx_defunct = ByteTools.readInt(this.getBytesAt(8, 4));
        this.dy_defunct = ByteTools.readInt(this.getBytesAt(12, 4));
        this.wSpacing = rkdata[17];
        this.grbit = ByteTools.readShort(rkdata[18], rkdata[19]);
        this.parseGrbit();
    }

    protected void parseGrbit() {
        byte[] grbytes = ByteTools.shortToLEBytes(this.grbit);
        this.fAutoPosition = (grbytes[0] & 1) == 1;
        this.fAutoSeries = (grbytes[0] & 2) == 2;
        this.fAutoPosX = (grbytes[0] & 4) == 4;
        this.fAutoPosY = (grbytes[0] & 8) == 8;
        this.fVert = (grbytes[0] & 0x10) == 16;
        this.fWasDataTable = (grbytes[0] & 0x20) == 32;
    }

    public void setIsDataTable(boolean isDataTable) {
        this.fWasDataTable = isDataTable;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fWasDataTable, 5);
        this.updateRecord();
    }

    public void setVertical(boolean isVertical) {
        this.fVert = isVertical;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fVert, 4);
        this.updateRecord();
    }

    public static Legend createDefaultLegend(WorkBook book) {
        Legend l = (Legend)Legend.getPrototype();
        Pos p = (Pos)Pos.getPrototype(1);
        l.chartArr.add(p);
        TextDisp td = (TextDisp)TextDisp.getPrototype(1, "", book);
        l.chartArr.add(td);
        return l;
    }

    private void updateRecord() {
        System.arraycopy(ByteTools.cLongToLEBytes(this.x_defunct), 0, this.getData(), 0, 4);
        System.arraycopy(ByteTools.cLongToLEBytes(this.y_defunct), 0, this.getData(), 4, 4);
        System.arraycopy(ByteTools.cLongToLEBytes(this.dx_defunct), 0, this.getData(), 8, 4);
        System.arraycopy(ByteTools.cLongToLEBytes(this.dy_defunct), 0, this.getData(), 12, 4);
        this.getData()[17] = this.wSpacing;
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[18] = b[0];
        this.getData()[19] = b[1];
    }

    public static XLSRecord getPrototype() {
        Legend l = new Legend();
        l.setOpcode((short)4117);
        l.setData(l.PROTOTYPE_BYTES);
        l.init();
        return l;
    }

    public short getLegendPosition() {
        CrtLayout12 crt = (CrtLayout12)Chart.findRec(this.chartArr, CrtLayout12.class);
        if (crt != null) {
            return (short)crt.getLayout();
        }
        if (this.fVert || !this.fAutoPosition) {
            return 3;
        }
        return 0;
    }

    public String getLegendPositionString() {
        short lpos = this.getLegendPosition();
        String[] pos = new String[]{"b", "tr", "t", "r", "l"};
        if (lpos >= 0 && lpos < pos.length) {
            return pos[lpos];
        }
        return "r";
    }

    public void setLegendPosition(short pos) {
        CrtLayout12 crt = (CrtLayout12)Chart.findRec(this.chartArr, CrtLayout12.class);
        if (crt != null) {
            crt.setLayout(pos);
        }
    }

    private Fontx getLegendFont() {
        TextDisp td = (TextDisp)Chart.findRec(this.chartArr, TextDisp.class);
        if (td != null) {
            return (Fontx)Chart.findRec(td.chartArr, Fontx.class);
        }
        return null;
    }

    public boolean hasBox() {
        Frame f = (Frame)Chart.findRec(this.chartArr, Frame.class);
        if (f != null) {
            return f.hasBox();
        }
        return false;
    }

    public void addBox() {
        Frame f = (Frame)Chart.findRec(this.chartArr, Frame.class);
        if (f == null) {
            f = (Frame)Frame.getPrototype();
            f.addBox(0, -1, -1);
            this.chartArr.add(f);
        }
    }

    public void setAutoPosition(boolean auto) {
        if (auto && !this.fAutoPosition && this.chartArr.size() > 0) {
            try {
                Pos p = (Pos)this.chartArr.get(0);
                p.setAutosizeLegend();
                Frame f = (Frame)Chart.findRec(this.chartArr, Frame.class);
                if (f != null) {
                    f.setAutosize();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fAutoPosition = auto;
        this.fAutoSeries = auto;
        this.fAutoPosX = auto;
        this.fAutoPosY = auto;
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fAutoPosition, 0);
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fAutoSeries, 1);
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fAutoPosX, 2);
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fAutoPosY, 3);
        this.grbit = ByteTools.updateGrBit(this.grbit, this.fVert, 4);
        this.updateRecord();
    }

    public void incrementHeight(float h) {
        Pos p = (Pos)Chart.findRec(this.chartArr, Pos.class);
        int[] coords = p.getLegendCoords();
        Font f = this.getFnt();
        int fh = 10;
        if (f != null) {
            fh = (int)(f.getFontHeightInPoints() * 1.2);
        }
        if (coords != null) {
            int z = coords[1] - (int)Math.ceil(Pos.convertToSPRC(fh / 2, 0.0f, h));
            p.setY(z);
        }
    }

    public void adjustWidth(HashMap<String, Double> chartMetrics, int chartType, String[] legends) {
        Pos p = (Pos)Chart.findRec(this.chartArr, Pos.class);
        int[] coords = p.getLegendCoords();
        if (coords != null) {
            Font f = this.getFnt();
            short position = this.getLegendPosition();
            float cw = chartMetrics.get("canvasw").floatValue();
            float x = (int)Math.ceil(Pos.convertFromSPRC(coords[0], cw, 0.0f)) - 3;
            float w = chartMetrics.get("w").floatValue();
            double legendsWidth = 0.0;
            java.awt.Font jf = new java.awt.Font(f.getFontName(), f.getFontWeight(), (int)f.getFontHeightInPoints());
            int extras = chartType == 2 || chartType == 6 ? 15 : 5;
            int i = 0;
            while (i < legends.length) {
                legendsWidth = this.fVert ? Math.max(legendsWidth, StringTool.getApproximateStringWidth(jf, " " + legends[i] + " ")) : (legendsWidth += StringTool.getApproximateStringWidth(jf, " " + legends[i] + " ") + (double)extras);
                ++i;
            }
            legendsWidth = !this.fVert ? (legendsWidth -= StringTool.getApproximateStringWidth(jf, " ")) : (legendsWidth += StringTool.getApproximateStringWidth(jf, " "));
            p.setLegendW((int)legendsWidth);
            if ((double)x + legendsWidth > (double)cw || position == 3 || position == 1) {
                x = (float)((double)cw - (legendsWidth + 5.0));
                if (x < 0.0f) {
                    x = 0.0f;
                }
                int z = (int)Math.ceil(Pos.convertToSPRC(x, cw, 0.0f));
                p.setX(z);
            }
        }
    }

    public void resetPos(double y, double h, double ch, int nLines) {
        Pos p = (Pos)Chart.findRec(this.chartArr, Pos.class);
        int z = (int)Math.ceil(Pos.convertToSPRC((float)(ch / 2.0), 0.0f, (float)ch));
        p.setY(z);
    }

    public int[] getCoords(int charttype, HashMap<String, Double> chartMetrics, String[] legends, java.awt.Font f) {
        float overage;
        Pos p = (Pos)Chart.findRec(this.chartArr, Pos.class);
        int[] coords = p.getLegendCoords();
        int[] retcoords = new int[6];
        int fh = f.getSize();
        retcoords[4] = f.getSize();
        retcoords[5] = this.getLegendPosition();
        boolean canMoveCW = false;
        if (coords != null) {
            retcoords[0] = (int)Math.ceil(Pos.convertFromSPRC(coords[0], chartMetrics.get("canvasw").floatValue(), 0.0f)) - 3;
            retcoords[1] = (int)Math.ceil(Pos.convertFromSPRC(coords[1], 0.0f, chartMetrics.get("canvash").floatValue()));
        } else {
            retcoords[0] = (int)(chartMetrics.get("w") + chartMetrics.get("x") + 20.0);
            retcoords[1] = chartMetrics.get("y").intValue() + (int)(chartMetrics.get("h") / 4.0);
            coords = new int[4];
            canMoveCW = true;
        }
        if (coords[2] != 0) {
            retcoords[2] = (int)((double)coords[2] * 1.333);
            retcoords[2] = retcoords[2] + 3;
        } else {
            double len = 0.0;
            int i = 0;
            while (i < legends.length) {
                len = Math.max(len, StringTool.getApproximateStringWidth(f, legends[i]));
                ++i;
            }
            retcoords[2] = (int)Math.ceil(len);
            retcoords[2] = retcoords[2] + (15 + (charttype == 2 || charttype == 6 ? 25 : 5));
            if (!canMoveCW && (float)(retcoords[0] + retcoords[2]) > chartMetrics.get("canvasw").floatValue()) {
                double cw = chartMetrics.get("canvasw");
                double w = chartMetrics.get("w");
                double ldist = (double)retcoords[0] - w;
                retcoords[0] = (int)Math.ceil(cw - (double)retcoords[2]);
                if (ldist > 0.0 && chartMetrics.get("w") + chartMetrics.get("x") > (double)retcoords[0]) {
                    chartMetrics.put("w", (double)retcoords[0] - ldist);
                }
            }
        }
        if (canMoveCW && (overage = (float)(retcoords[0] + retcoords[2] + 10) - chartMetrics.get("canvasw").floatValue()) > 0.0f) {
            chartMetrics.put("canvasw", chartMetrics.get("canvasw") + (double)overage);
        }
        retcoords[3] = coords[3] != 0 ? (int)((double)coords[3] * 1.333) : (legends.length + 2) * (fh + 2);
        return retcoords;
    }

    public Font getFnt() {
        try {
            Fontx fx = this.getLegendFont();
            Font f = this.getParentChart().getWorkBook().getFont(fx.getIfnt());
            if (f != null) {
                return f;
            }
            return this.getParentChart().getDefaultFont();
        }
        catch (NullPointerException e) {
            return this.getParentChart().getDefaultFont();
        }
    }

    public void getMetrics(HashMap<String, Double> chartMetrics, int chartType, ChartSeries s) {
        String[] legends = s.getLegends();
        if (legends == null || legends.length == 0) {
            return;
        }
        Font f = this.getFnt();
        this.legendCoords = f != null ? this.getCoords(chartType, chartMetrics, legends, new java.awt.Font(f.getFontName(), f.getFontWeight(), (int)f.getFontHeightInPoints())) : this.getCoords(chartType, chartMetrics, legends, new java.awt.Font("Arial", 400, 10));
    }

    public int[] getCoords() {
        return this.legendCoords;
    }

    public String getSVG(HashMap<String, Double> chartMetrics, ChartType chartobj, ChartSeries s) {
        int fh;
        String font;
        Font f;
        StringBuffer svg = new StringBuffer();
        String[] legends = s.getLegends();
        String[] seriescolors = s.getSeriesBarColors();
        if (legends == null || legends.length == 0) {
            return "";
        }
        if (this.legendCoords == null) {
            this.getMetrics(chartMetrics, chartobj.getChartType(), s);
        }
        if ((f = this.getFnt()) != null) {
            font = f.getSVG();
            font = "' " + font;
            fh = (int)Math.ceil(f.getFontHeightInPoints());
        } else {
            font = "' font-family='Arial' font-size='9pt'";
            fh = 10;
        }
        int YOFFSET = this.legendCoords[3] / legends.length;
        int x = this.legendCoords[0];
        int y = this.legendCoords[1];
        int boxw = this.legendCoords[2];
        int boxh = this.legendCoords[3];
        svg.append("<g>\r\n");
        if (this.hasBox()) {
            svg.append("<rect x='" + x + "' y='" + y + "' width='" + boxw + "' height='" + boxh + "' fill='#FFFFFF' fill-opacity='1' stroke='black' stroke-opacity='1' stroke-width='1' " + "stroke-linecap='butt' stroke-linejoint='miter' stroke-miterlimit='4' fill-rull='evenodd'" + "/>");
            x += 5;
            y += YOFFSET / 3;
        }
        if (chartobj.getChartType() == 1) {
            int h = 8;
            int i = legends.length - 1;
            while (i >= 0) {
                svg.append("<rect x='" + x + "' y='" + y + "' width='" + h + "' height='" + h + "' fill='" + seriescolors[i] + "' fill-opacity='1' stroke='black' stroke-opacity='1' stroke-width='1' stroke-linecap='butt' stroke-linejoint='miter' stroke-miterlimit='4' fill-rull='evenodd'" + "/>");
                svg.append("<text " + Legend.getScript("legend" + i) + " x='" + (x + this.XOFFSET) + "' y='" + (y + fh) + font + ">" + legends[i] + "</text>");
                y += YOFFSET;
                --i;
            }
        } else if (chartobj.getChartType() != 2 && chartobj.getChartType() != 5 && chartobj.getChartType() != 6 && chartobj.getChartType() != 9) {
            int h = 8;
            int i = 0;
            while (i < legends.length) {
                svg.append("<rect x='" + x + "' y='" + y + "' width='" + h + "' height='" + h + "' fill='" + seriescolors[i] + "' fill-opacity='1' stroke='black' stroke-opacity='1' stroke-width='1' stroke-linecap='butt' stroke-linejoint='miter' stroke-miterlimit='4' fill-rull='evenodd'" + "/>");
                svg.append("<text " + Legend.getScript("legend" + i) + " x='" + (x + this.XOFFSET) + "' y='" + (y + fh) + font + ">" + legends[i] + "</text>");
                y += YOFFSET;
                ++i;
            }
        } else if (chartobj.getChartType() == 9) {
            int i = legends.length - 1;
            while (i >= 0) {
                svg.append("<circle cx='" + (x + 3) + "' cy='" + (y + 6) + "' r='5' stroke='black' stroke-width='1' fill='" + seriescolors[i] + "'/>");
                svg.append("<text " + Legend.getScript("legend" + i) + " x='" + (x + this.XOFFSET) + "' y='" + (y + fh) + font + ">" + legends[i] + "</text>");
                y += YOFFSET;
                --i;
            }
        } else {
            int[] markers = chartobj.getMarkerFormats();
            boolean haslines = true;
            if (chartobj.getChartType() == 5) {
                haslines = chartobj.getHasLines();
            }
            svg.append(MarkerFormat.getMarkerSVGDefs());
            int w = 25;
            if (!haslines) {
                w = 10;
            }
            this.XOFFSET = w + 4;
            y += 2;
            int i = 0;
            while (i < legends.length) {
                if (haslines) {
                    svg.append("<line x1='" + x + "' y1='" + (y + fh / 2) + "' x2='" + (x + w) + "' y2='" + (y + fh / 2) + "' stroke='" + seriescolors[i] + "' stroke-width='2'/>");
                }
                if (markers[i] > 0) {
                    svg.append(MarkerFormat.getMarkerSVG(x + w / 2 - 5, y + fh / 2, seriescolors[i], markers[i]));
                }
                svg.append("<text " + Legend.getScript("legend" + i) + " x='" + (x + this.XOFFSET) + "' y='" + (y + fh) + font + ">" + legends[i] + "</text>");
                y += YOFFSET;
                ++i;
            }
        }
        svg.append("</g>\r\n");
        return svg.toString();
    }
}

