/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class Pos
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 7920967716354683818L;
    short rndTopLt;
    short rndTopRt;
    int x1;
    int y1;
    int x2;
    int y2;
    public static final int TYPE_TEXTDISP = 0;
    public static final int TYPE_LEGEND = 1;
    public static final int TYPE_PLOTAREA = 2;
    public static final int TYPE_DATATABLE = 3;
    private byte[] PROTOTYPE_BYTES;

    public Pos() {
        byte[] byArray = new byte[20];
        byArray[0] = 2;
        byArray[2] = 2;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.rndTopLt = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.rndTopRt = ByteTools.readShort(this.getByteAt(2), this.getByteAt(3));
        this.x1 = ByteTools.readInt(this.getBytesAt(4, 4));
        this.y1 = ByteTools.readInt(this.getBytesAt(8, 4));
        this.x2 = ByteTools.readInt(this.getBytesAt(12, 4));
        this.y2 = ByteTools.readInt(this.getBytesAt(16, 4));
    }

    public static XLSRecord getPrototype(int type) {
        Pos p = new Pos();
        p.setOpcode((short)4175);
        p.setData(p.PROTOTYPE_BYTES);
        p.init();
        p.setType(type);
        return p;
    }

    public void setType(int type) {
        switch (type) {
            case 0: 
            case 2: {
                this.getData()[0] = 2;
                this.getData()[1] = 0;
                break;
            }
            case 1: {
                this.getData()[0] = 5;
                this.getData()[1] = 2;
                break;
            }
            case 3: {
                this.getData()[0] = 3;
                this.getData()[1] = 0;
            }
        }
        this.getData()[2] = 2;
        this.getData()[3] = 0;
    }

    public void setX(int x) {
        this.x1 = x;
        byte[] b = ByteTools.cLongToLEBytes(x);
        System.arraycopy(b, 0, this.getData(), 4, 4);
    }

    public void setY(int y) {
        this.y1 = y;
        byte[] b = ByteTools.cLongToLEBytes(y);
        System.arraycopy(b, 0, this.getData(), 8, 4);
    }

    public void setLegendW(int w) {
        if (this.rndTopLt == 5 && this.rndTopRt == 1) {
            this.x2 = w;
            byte[] b = ByteTools.cLongToLEBytes(this.x2);
            System.arraycopy(b, 0, this.getData(), 12, 4);
        }
    }

    public void setAutosizeLegend() {
        if (this.rndTopLt == 5) {
            this.rndTopRt = (short)2;
            this.getData()[2] = 2;
        }
    }

    public int[] getLegendCoords() {
        if (this.rndTopLt == 5 && this.rndTopRt == 1) {
            return new int[]{this.x1, this.y1, this.x2, this.y2};
        }
        if (this.rndTopLt == 5 && this.rndTopRt == 2) {
            int[] nArray = new int[4];
            nArray[0] = this.x1;
            nArray[1] = this.y1;
            return nArray;
        }
        if (this.rndTopLt == 3 && this.rndTopRt == 2) {
            return null;
        }
        return null;
    }

    public float[] getCoords() {
        if (this.rndTopLt == 2 && this.rndTopRt == 2) {
            return new float[]{this.x1, this.y1, this.x2, this.y2};
        }
        return null;
    }

    public static float convertFromSPRC(float val, float w, float h) {
        if (w != 0.0f) {
            return (float)((double)val / 4000.0) * w;
        }
        return (float)((double)val / 4000.0) * h;
    }

    public static float convertToSPRC(float val, float w, float h) {
        if (w != 0.0f) {
            return (float)((double)val * 4000.0) / w;
        }
        return (float)((double)val * 4000.0) / h;
    }

    public static float convertFromLabelUnits(float val, float w, float h) {
        if (w != 0.0f) {
            return (float)((double)val / 1000.0) * w;
        }
        return (float)((double)val / 1000.0) * h;
    }
}

