/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class Radar
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 3443368503725347910L;
    private short grbit = 0;
    private boolean fRdrAxLab = true;
    private boolean fHasShadow = false;
    private byte[] PROTOTYPE_BYTES;

    public Radar() {
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        byArray[2] = 18;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.chartType = 6;
        this.grbit = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.fRdrAxLab = (this.grbit & 1) == 1;
        this.fHasShadow = (this.grbit & 2) == 2;
    }

    private void updateRecord() {
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    public static XLSRecord getPrototype() {
        Radar b = new Radar();
        b.setOpcode((short)4158);
        b.setData(b.PROTOTYPE_BYTES);
        b.init();
        return b;
    }

    @Override
    public String getOptionsXML() {
        StringBuffer sb = new StringBuffer();
        if (this.fRdrAxLab) {
            sb.append(" AxisLabels=\"true\"");
        }
        if (this.fHasShadow) {
            sb.append(" Shadow=\"true\"");
        }
        return sb.toString();
    }

    @Override
    public boolean setChartOption(String op, String val) {
        boolean bHandled = false;
        if (op.equalsIgnoreCase("AxisLabels")) {
            this.fRdrAxLab = val.equals("true");
            this.grbit = ByteTools.updateGrBit(this.grbit, this.fRdrAxLab, 0);
            bHandled = true;
        } else if (op.equalsIgnoreCase("Shadow")) {
            this.fHasShadow = val.equals("true");
            this.grbit = ByteTools.updateGrBit(this.grbit, this.fHasShadow, 1);
            bHandled = true;
        }
        if (bHandled) {
            this.updateRecord();
        }
        return bHandled;
    }
}

