/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class RadarArea
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 5731720802332312350L;
    private short grbit = 0;
    private boolean fRdrAxLab = false;
    private byte[] PROTOTYPE_BYTES;

    public RadarArea() {
        byte[] byArray = new byte[2];
        byArray[0] = 1;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.chartType = 17;
        this.grbit = ByteTools.readShort(this.getByteAt(0), this.getByteAt(1));
        this.fRdrAxLab = (this.grbit & 1) == 1;
    }

    private void updateRecord() {
        byte[] b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[0] = b[0];
        this.getData()[1] = b[1];
    }

    public static XLSRecord getPrototype() {
        RadarArea r2 = new RadarArea();
        r2.setOpcode((short)4160);
        r2.setData(r2.PROTOTYPE_BYTES);
        r2.init();
        return r2;
    }

    @Override
    public String getOptionsXML() {
        StringBuffer sb = new StringBuffer();
        if (this.fRdrAxLab) {
            sb.append(" AxisLabels=\"true\"");
        }
        return sb.toString();
    }

    @Override
    public boolean setChartOption(String op, String val) {
        boolean bHandled = false;
        if (op.equalsIgnoreCase("AxisLabels")) {
            this.fRdrAxLab = val.equals("true");
            this.grbit = ByteTools.updateGrBit(this.grbit, this.fRdrAxLab, 0);
            bHandled = true;
        }
        if (bHandled) {
            this.updateRecord();
        }
        return bHandled;
    }
}

