/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class SeriesList
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -7852050067799624402L;
    int[] seriesmap = null;

    @Override
    public void init() {
        super.init();
        int nseries = ByteTools.readShort(this.getData()[0], this.getData()[1]);
        this.seriesmap = new int[nseries];
        int i = 0;
        while (i < nseries) {
            int idx = (i + 1) * 2;
            this.seriesmap[i] = ByteTools.readShort(this.getData()[idx], this.getData()[idx + 1]);
            ++i;
        }
    }

    public int[] getSeriesMappings() {
        return this.seriesmap;
    }

    public void setSeriesMappings(int[] smap) {
        int nseries = smap.length;
        this.seriesmap = new int[nseries];
        byte[] data = new byte[(nseries + 1) * 2];
        byte[] b = ByteTools.shortToLEBytes((short)nseries);
        data[0] = b[0];
        data[1] = b[1];
        int i = 0;
        while (i < nseries) {
            int idx = (i + 1) * 2;
            this.seriesmap[i] = smap[i];
            b = ByteTools.shortToLEBytes((short)smap[i]);
            data[idx] = b[0];
            data[idx + 1] = b[1];
            ++i;
        }
        this.setData(data);
    }
}

