/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.Logger;
import java.io.UnsupportedEncodingException;

public final class SeriesText
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = -3794355940075116165L;
    protected int id = -1;
    protected int cch = -1;
    private String text = "";
    private byte[] PROTOTYPE_BYTES;

    public SeriesText() {
        byte[] byArray = new byte[18];
        byArray[2] = 7;
        byArray[3] = 1;
        byArray[4] = 74;
        byArray[6] = 97;
        byArray[8] = 110;
        byArray[10] = 117;
        byArray[12] = 97;
        byArray[14] = 114;
        byArray[16] = 121;
        this.PROTOTYPE_BYTES = byArray;
    }

    public void setText(String t) {
        byte[] strbytes = null;
        byte uni = 0;
        int lent = 0;
        try {
            strbytes = t.getBytes("UTF-16LE");
            uni = 1;
            lent = strbytes.length / 2;
        }
        catch (Exception e) {
            strbytes = t.getBytes();
            lent = strbytes.length;
        }
        byte[] newbytes = new byte[strbytes.length + 4];
        newbytes[0] = 0;
        newbytes[1] = 0;
        newbytes[2] = (byte)lent;
        newbytes[3] = uni;
        System.arraycopy(strbytes, 0, newbytes, 4, strbytes.length);
        this.setData(newbytes);
        this.text = t;
    }

    @Override
    public void init() {
        super.init();
        int multi = 2;
        if (this.getByteAt(3) == 0) {
            multi = 1;
        }
        this.cch = this.getByteAt(2) * multi;
        if (this.cch < 0) {
            this.cch *= -1;
        }
        try {
            byte[] namebytes = this.getBytesAt(4, this.cch);
            try {
                this.text = new String(namebytes, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                Logger.logInfo("Unsupported Encoding error in SeriesText: " + e);
            }
            if (this.DEBUGLEVEL > 10) {
                Logger.logInfo("Series Text Value: " + this.text);
            }
        }
        catch (Exception ex) {
            Logger.logWarn("SeriesText.init failed: " + ex);
        }
    }

    @Override
    public String toString() {
        return this.text;
    }

    public static SeriesText getPrototype(String text) {
        SeriesText st = new SeriesText();
        st.setOpcode((short)4109);
        st.setData(st.PROTOTYPE_BYTES);
        st.init();
        st.setText(text);
        return st;
    }
}

