/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.charts.Area;
import com.extentech.formats.XLS.charts.AreaChart;
import com.extentech.formats.XLS.charts.ChartFormat;
import com.extentech.formats.XLS.charts.ChartSeries;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.HashMap;

public class StackedAreaChart
extends AreaChart {
    public StackedAreaChart(GenericChartObject charttype, ChartFormat cf, WorkBook wb) {
        super(charttype, cf, wb);
        this.area = (Area)charttype;
    }

    @Override
    public boolean isStacked() {
        return true;
    }

    @Override
    public String getSVG(HashMap<String, Double> chartMetrics, HashMap<String, Object> axisMetrics, ChartSeries s) {
        double x = chartMetrics.get("x");
        double y = chartMetrics.get("y");
        double w = chartMetrics.get("w");
        double h = chartMetrics.get("h");
        double max = chartMetrics.get("max");
        double min = chartMetrics.get("min");
        Object[] categories = s.getCategories();
        ArrayList series = s.getSeriesValues();
        String[] seriescolors = s.getSeriesBarColors();
        String[] legends = s.getLegends();
        if (series.size() == 0) {
            Logger.logErr("Area.getSVG: error in series");
            return "";
        }
        StringBuffer svg = new StringBuffer();
        int[] dls = this.getDataLabelInts();
        double xfactor = 0.0;
        double yfactor = 0.0;
        if (categories.length > 1) {
            xfactor = w / (double)(categories.length - 1);
        }
        if (max != 0.0) {
            yfactor = h / max;
        }
        int n = series.size();
        int nSeries = ((double[])series.get(0)).length;
        double[][] areapoints = new double[nSeries][n];
        int i = 0;
        while (i < n) {
            double[] seriesy = (double[])series.get(i);
            int j = 0;
            while (j < seriesy.length) {
                double yval = seriesy[j];
                areapoints[j][i] = yval + (i > 0 ? areapoints[j][i - 1] : 0.0);
                ++j;
            }
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            svg.append("<g>\r\n");
            String points = "";
            double x1 = 0.0;
            double y1 = 0.0;
            String labels = null;
            double[] curseries = (double[])series.get(i);
            int j = 0;
            while (j < curseries.length) {
                x1 = x + (double)j * xfactor;
                double yval = areapoints[j][i];
                points = String.valueOf(points) + (x + (double)j * xfactor) + "," + (y + h - yval * yfactor);
                if (j == 0) {
                    y1 = y + h - yval * yfactor;
                }
                points = String.valueOf(points) + " ";
                String l = this.getSVGDataLabels(dls, axisMetrics, curseries[j], 0.0, i, legends, categories[j].toString());
                if (l != null) {
                    boolean showValue;
                    boolean showCategories = (dls[i] & 0x10) == 16;
                    boolean showValueLabel = (dls[i] & 0x40) == 64;
                    boolean bl = showValue = (dls[i] & 1) == 1;
                    if (showCategories && !showValue && !showValueLabel && j == 0) {
                        double hh = areapoints[areapoints.length / 2][i] * yfactor;
                        double yy = y + h - hh + 10.0;
                        if (labels == null) {
                            labels = "";
                        }
                        labels = "<text x='" + (x + w / 2.0) + "' y='" + yy + "' vertical-align='middle' " + StackedAreaChart.getDataLabelFontSVG() + " style='text-align:middle;'>" + l + "</text>\r\n";
                    } else if (showValue || showValueLabel) {
                        if (labels == null) {
                            labels = "";
                        }
                        double yy = y + h - (yval - curseries[j] * 0.5) * yfactor;
                        labels = String.valueOf(labels) + "<text x='" + x1 + "' y='" + yy + "' style='text-anchor: middle;' " + StackedAreaChart.getDataLabelFontSVG() + ">" + l + "</text>\r\n";
                    }
                }
                ++j;
            }
            double x0 = x;
            String pointsend = String.valueOf(x1) + "," + (y + h) + " " + x0 + "," + (y + h) + " " + x0 + "," + y1;
            svg.append("<polyline  id='series_" + (i + 1) + "' " + StackedAreaChart.getScript("") + " fill='" + seriescolors[i] + "' fill-opacity='1' " + StackedAreaChart.getStrokeSVG() + " points='" + points + pointsend + "' fill-rule='evenodd'/>\r\n");
            if (labels != null) {
                svg.append(labels);
            }
            svg.append("</g>\r\n");
            --i;
        }
        return svg.toString();
    }
}

