/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.charts;

import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.charts.ChartObject;
import com.extentech.formats.XLS.charts.GenericChartObject;
import com.extentech.toolkit.ByteTools;

public class ValueRange
extends GenericChartObject
implements ChartObject {
    private static final long serialVersionUID = 2989883115978826628L;
    double numMin;
    double numMax;
    double numMajor;
    double numMinor;
    double numCross;
    short grbit = 0;
    boolean fAutoMin;
    boolean fAutoMax;
    boolean fAutoMajor;
    boolean fAutoMinor;
    boolean fAutoCross;
    boolean fLogScale;
    boolean fReverse;
    boolean fMaxCross;
    private byte[] PROTOTYPE_BYTES;

    public ValueRange() {
        byte[] byArray = new byte[42];
        byArray[40] = 31;
        byArray[41] = 1;
        this.PROTOTYPE_BYTES = byArray;
    }

    @Override
    public void init() {
        super.init();
        this.numMin = ByteTools.eightBytetoLEDouble(this.getBytesAt(0, 8));
        this.numMax = ByteTools.eightBytetoLEDouble(this.getBytesAt(8, 16));
        this.numMajor = ByteTools.eightBytetoLEDouble(this.getBytesAt(16, 24));
        this.numMinor = ByteTools.eightBytetoLEDouble(this.getBytesAt(24, 32));
        this.numCross = ByteTools.eightBytetoLEDouble(this.getBytesAt(32, 40));
        this.grbit = ByteTools.readShort(this.getByteAt(40), this.getByteAt(41));
        this.fMaxCross = (this.grbit & 0x80) == 128;
        this.fAutoMin = (this.grbit & 1) == 1;
        this.fAutoMax = (this.grbit & 2) == 2;
        this.fAutoMajor = (this.grbit & 4) == 4;
        this.fAutoMinor = (this.grbit & 8) == 8;
        this.fAutoCross = (this.grbit & 0x10) == 16;
        this.fLogScale = (this.grbit & 0x20) == 32;
        this.fReverse = (this.grbit & 0x40) == 64;
    }

    public static XLSRecord getPrototype() {
        ValueRange vr = new ValueRange();
        vr.setOpcode((short)4127);
        vr.setData(vr.PROTOTYPE_BYTES);
        vr.init();
        return vr;
    }

    public double getMin() {
        return this.numMin;
    }

    public double getMax() {
        return this.numMax;
    }

    public double getMajorTick() {
        return this.numMajor;
    }

    public double getMinorTick() {
        return this.numMinor;
    }

    public void setMaxMin(double yMax, double yMin) {
        if (this.fAutoMajor && this.fAutoMinor) {
            int charttype = this.getParentChart().getChartType();
            if (yMax >= 0.0 && yMin >= 0.0 && yMax != yMin) {
                double f;
                double logDiff;
                double diff = yMax * 1.1 - yMin;
                if (this.fAutoMax) {
                    logDiff = Math.floor(Math.log10(diff));
                    f = diff / Math.pow(10.0, logDiff);
                    f = f <= 1.0 ? 1.0 : (f <= 2.0 ? 2.0 : (f <= 5.0 ? 5.0 : 10.0));
                    this.numMajor = (f *= Math.pow(10.0, logDiff)) * 0.1;
                } else {
                    this.numMajor = this.numMax / 10.0;
                }
                if (this.fAutoMax) {
                    if (charttype == 4 || charttype == 0 || charttype == 1 || charttype == 2 || charttype == 5 || charttype == 9) {
                        this.numMax = this.numMajor == (double)((int)this.numMajor) ? Math.ceil(yMax + 0.05 * diff * 1.1) : yMax + 0.05 * diff * 1.1;
                        if (charttype == 9) {
                            this.numMax += this.numMajor;
                        }
                        if (this.numMax % this.numMajor != 0.0) {
                            this.numMax = Math.floor((this.numMax + this.numMajor) / this.numMajor) * this.numMajor;
                        }
                    } else {
                        this.numMax = Math.floor((yMax + this.numMajor) / this.numMajor) * this.numMajor;
                    }
                }
                if (this.fAutoMin) {
                    if (charttype == 5 || charttype == 9) {
                        if (yMin % this.numMajor != 0.0) {
                            this.numMin = Math.floor((yMin - this.numMajor) / this.numMajor) * this.numMajor;
                            this.numMin = Math.round(this.numMin);
                        }
                    } else if (yMax - yMin > this.numMax * 0.16667) {
                        this.numMin = 0.0;
                    } else {
                        this.numMin = yMin - (this.numMax - yMin) / 2.0;
                        if (this.numMin % this.numMajor != 0.0) {
                            this.numMin = Math.floor((this.numMin - this.numMajor) / this.numMajor) * this.numMajor;
                        }
                    }
                }
                if (this.numMin >= 0.0 && this.numMax >= 0.0 && (this.numMax - this.numMin) / this.numMajor > 9.0) {
                    diff = this.numMax * 1.1 - this.numMin;
                    logDiff = Math.floor(Math.log10(diff));
                    f = diff / Math.pow(10.0, logDiff);
                    f = f <= 1.0 ? 1.0 : (f <= 2.0 ? 2.0 : (f <= 5.0 ? 5.0 : 10.0));
                    this.numMajor = (f *= Math.pow(10.0, logDiff)) * 0.1;
                }
                this.numMinor = this.numMajor / 5.0;
            } else if (yMax < 0.0 && yMin < 0.0) {
                double diff = yMin - yMax;
                this.numMin = yMin + 0.05 * diff;
                this.numMax = diff > yMin * 0.16667 ? 0.0 : yMax - diff / 2.0;
                this.numMax = Math.floor((this.numMax + this.numMajor) / this.numMajor) * this.numMajor;
                if (this.fAutoMinor) {
                    this.numMinor = this.numMajor / 5.0;
                } else {
                    this.numMax = yMax + 0.05 * (yMax - yMin);
                    this.numMin = yMin + 0.05 * (yMin - yMax);
                }
            } else {
                this.numMax = yMax;
                this.numMin = yMin;
            }
        }
    }

    public static double[] calcMaxMin(double MaxVal, double MinVal, double area) {
        double ymax = MaxVal;
        double ymin = MinVal;
        double numMajor = ymax - ymin;
        if (numMajor > 0.0 && numMajor < 20.0) {
            numMajor = 2.0;
        } else if (numMajor > 20.0 && numMajor < 100.0) {
            numMajor = 20.0;
        } else if (numMajor > 100.0 && numMajor < 500.0) {
            numMajor = 50.0;
        }
        ymax = ymax >= 0.0 ? Math.floor((ymax + numMajor) / numMajor) * numMajor : Math.floor((ymax + numMajor) / numMajor) * numMajor;
        double numMin = ymin - numMajor;
        if (numMin % numMajor > 0.0) {
            numMin -= numMajor;
        }
        if (ymin >= 0.0) {
            numMin = Math.max(ymin - numMajor, 0.0);
        }
        numMin = Math.round(numMin);
        double numMax = 0.0;
        numMax = ymax >= 0.0 ? (double)((int)Math.floor((ymax + numMajor) / numMajor)) * numMajor : (double)((int)Math.floor((ymax + numMajor) / numMajor)) * numMajor;
        return new double[]{numMin, numMajor, ymax};
    }

    public boolean setOption(String op, String val) {
        if (op.equals("crossesAt")) {
            this.numCross = new Double(val);
        } else if (op.equals("orientation")) {
            this.fReverse = val.equals("maxMin");
            ByteTools.updateGrBit(this.grbit, this.fReverse, 6);
        } else if (op.equals("crosses")) {
            if (val.equals("max")) {
                this.fMaxCross = true;
                ByteTools.updateGrBit(this.grbit, this.fMaxCross, 7);
            } else if (val.equals("autoZero")) {
                this.fAutoCross = true;
                ByteTools.updateGrBit(this.grbit, this.fAutoCross, 4);
            } else if (val.equals("min")) {
                this.fAutoCross = false;
                ByteTools.updateGrBit(this.grbit, this.fAutoCross, 4);
            }
        } else if (op.equals("crossBetween")) {
            if (val.equals("between")) {
                this.fAutoCross = true;
            }
        } else if (op.equals("max")) {
            this.numMax = new Double(val);
            this.grbit = (short)(this.grbit & 0xFD);
        } else if (op.equals("min")) {
            this.numMin = new Double(val);
            this.grbit = (short)(this.grbit & 0xFE);
        } else if (op.equals("majorUnit")) {
            this.numMajor = new Double(val);
        } else if (op.equals("minorUnit")) {
            this.numMinor = new Double(val);
        } else {
            return false;
        }
        this.updateRecord();
        return true;
    }

    public String getOption(String op) {
        if (op.equals("crossesAt")) {
            return String.valueOf(this.numCross);
        }
        if (op.equals("orientation")) {
            return this.fReverse ? "maxMin" : "minMax";
        }
        if (op.equals("crosses")) {
            if (this.fMaxCross) {
                return "max";
            }
            if (this.fAutoCross) {
                return "autoZero";
            }
            return "min";
        }
        if (op.equals("crossBetween")) {
            return "between";
        }
        if (op.equals("max")) {
            return String.valueOf(this.numMax);
        }
        if (op.equals("min")) {
            return String.valueOf(this.numMin);
        }
        if (op.equals("majorUnit")) {
            return String.valueOf(this.numMajor);
        }
        if (op.equals("minorUnit")) {
            return String.valueOf(this.numMinor);
        }
        return null;
    }

    public void setMin(double min) {
        this.numMin = min;
        this.grbit = (short)(this.grbit & 0xFE);
        this.updateRecord();
    }

    public void setMax(double max) {
        this.numMax = max;
        this.grbit = (short)(this.grbit & 0xFD);
        this.updateRecord();
    }

    public boolean isAutomaticScale() {
        return this.fAutoMin || this.fAutoMax || this.fAutoMinor || this.fAutoMajor;
    }

    public boolean isAutomaticMax() {
        return this.fAutoMax;
    }

    public boolean isAutomaticMin() {
        return this.fAutoMin;
    }

    public void setAutomaticMin(boolean b) {
        this.fAutoMin = b;
        if (b) {
            this.grbit = (short)(this.grbit | 1);
            this.numMin = 0.0;
        } else {
            this.grbit = (short)(this.grbit & 0xFE);
        }
        this.updateRecord();
    }

    public void setAutomaticMax(boolean b) {
        this.fAutoMax = b;
        if (b) {
            this.grbit = (short)(this.grbit | 2);
            this.numMax = 0.0;
        } else {
            this.grbit = (short)(this.grbit & 0xFD);
        }
        this.updateRecord();
    }

    private void updateRecord() {
        byte[] b = ByteTools.doubleToLEByteArray(this.numMin);
        System.arraycopy(b, 0, this.getData(), 0, 8);
        b = ByteTools.doubleToLEByteArray(this.numMax);
        System.arraycopy(b, 0, this.getData(), 8, 8);
        b = ByteTools.doubleToLEByteArray(this.numMajor);
        System.arraycopy(b, 0, this.getData(), 16, 8);
        b = ByteTools.doubleToLEByteArray(this.numMinor);
        System.arraycopy(b, 0, this.getData(), 24, 8);
        b = ByteTools.doubleToLEByteArray(this.numCross);
        System.arraycopy(b, 0, this.getData(), 32, 8);
        b = ByteTools.shortToLEBytes(this.grbit);
        this.getData()[40] = b[0];
        this.getData()[41] = b[1];
    }

    public boolean isReversed() {
        return this.fReverse;
    }
}

