/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

public class CalculationException
extends Exception {
    private static final long serialVersionUID = 2028428287133817627L;
    static String[][] errorStrings = new String[][]{{"#DIV/0!", "7"}, {"#N/A", "42"}, {"#NAME?", "29"}, {"#NULL!", "0"}, {"#NUM!", "36"}, {"#REF!", "23"}, {"#VALUE!", "15"}, {"#CIR_ERR!", "15"}};
    public static final byte NULL = 0;
    public static final byte DIV0 = 7;
    public static final byte VALUE = 15;
    public static final byte REF = 23;
    public static final byte NAME = 29;
    public static final byte NUM = 36;
    public static final byte NA = 42;
    public static final byte CIR_ERR = -1;
    private final byte error;

    public CalculationException(byte error) {
        this.error = error;
    }

    public byte getErrorCode() {
        if (this.error == -1) {
            return 15;
        }
        return this.error;
    }

    public static byte getErrorCode(String error) {
        if (error == null) {
            return 0;
        }
        int i = 0;
        while (i < errorStrings.length) {
            if (error.equals(errorStrings[i][0])) {
                return new Byte(errorStrings[i][1]);
            }
            ++i;
        }
        return 0;
    }

    @Override
    public String getMessage() {
        switch (this.error) {
            case 0: {
                return "a range intersection returned no cells";
            }
            case 7: {
                return "attempted to divide by zero";
            }
            case 15: {
                return "operand type mismatch";
            }
            case 23: {
                return "reference to a cell that doesn't exist";
            }
            case 29: {
                return "reference to an unknown function or defined name";
            }
            case 36: {
                return "number storage overflow";
            }
            case 42: {
                return "lookup returned no value for the given criteria";
            }
            case -1: {
                return "circular reference error";
            }
        }
        return "unknown error occurred";
    }

    public String getName() {
        switch (this.error) {
            case 0: {
                return "#NULL!";
            }
            case 7: {
                return "#DIV/0!";
            }
            case 15: {
                return "#VALUE!";
            }
            case 23: {
                return "#REF!";
            }
            case 29: {
                return "#NAME?";
            }
            case 36: {
                return "#NUM!";
            }
            case 42: {
                return "#N/A";
            }
            case -1: {
                return "#CIR_ERR!";
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

