/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.DateConverter;
import com.extentech.formats.XLS.formulas.FinancialCalculator;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgCalculator;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgName;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgStr;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateTimeCalculator {
    private static GregorianCalendar getDateFromPtg(Ptg op) {
        Object o;
        if (op instanceof PtgStr) {
            o = DateTimeCalculator.calcDateValue(new Ptg[]{op}).getValue();
        } else if (op instanceof PtgRef) {
            o = op.getValue();
            if (o instanceof String) {
                o = DateTimeCalculator.calcDateValue(new Ptg[]{new PtgStr(o.toString())}).getValue();
            }
        } else if (op instanceof PtgName) {
            o = ((PtgName)op).getValue();
            o = op.getValue();
            if (o instanceof String) {
                o = DateTimeCalculator.calcDateValue(new Ptg[]{new PtgStr(o.toString())}).getValue();
            }
        } else {
            o = op.getValue();
        }
        return (GregorianCalendar)DateConverter.getCalendarFromNumber(o);
    }

    protected static Ptg calcDate(Ptg[] operands) {
        long[] alloperands = PtgCalculator.getLongValueArray(operands);
        if (alloperands.length != 3) {
            return PtgCalculator.getError();
        }
        int year = (int)alloperands[0];
        int month = (int)alloperands[1];
        int day = (int)alloperands[2];
        GregorianCalendar c = new GregorianCalendar(year, --month, day);
        double date = DateConverter.getXLSDateVal(c);
        int i = (int)date;
        PtgInt pi = new PtgInt(i);
        return pi;
    }

    protected static Ptg calcDateValue(Ptg[] operands) {
        if (operands == null || operands[0].getString() == null) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        String dateString = operands[0].getString();
        Double d = DateConverter.calcDateValue(dateString);
        if (d == null) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        return new PtgNumber(d);
    }

    protected static Ptg calcDay(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getError();
        }
        try {
            Object o = operands[0].getValue();
            GregorianCalendar c = (GregorianCalendar)DateConverter.getCalendarFromNumber(o);
            int retdate = c.get(5);
            PtgInt pint = new PtgInt(retdate);
            return pint;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcDays360(Ptg[] operands) {
        if (operands.length < 2) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        try {
            Object o1 = operands[0].getValue();
            Object o2 = operands[1].getValue();
            GregorianCalendar dt1 = (GregorianCalendar)DateConverter.getCalendarFromNumber(o1);
            GregorianCalendar dt2 = (GregorianCalendar)DateConverter.getCalendarFromNumber(o2);
            int yr1 = dt1.get(1);
            int yr2 = dt2.get(1);
            int diff = yr2 - yr1;
            diff *= 360;
            int mo1 = dt1.get(2);
            int mo2 = dt2.get(2);
            int mos = 0;
            if (mo2 > mo1) {
                mos = mo2 - mo1;
            } else {
                diff -= 360;
                while (mo2 != mo1) {
                    ++mos;
                    if (++mo1 != 12) continue;
                    mo1 = 0;
                }
            }
            diff += mos * 30;
            int dy1 = dt1.get(5);
            int dy2 = dt2.get(5);
            if (dy2 > dy1) {
                diff += dy2 - dy1;
            } else {
                diff -= 30;
                while (dy2 != dy1) {
                    ++diff;
                    if (++dy1 != 30) continue;
                    dy1 = 0;
                }
            }
            PtgInt pint = new PtgInt(diff);
            return pint;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcEdate(Ptg[] operands) {
        try {
            GregorianCalendar startDate = DateTimeCalculator.getDateFromPtg(operands[0]);
            int inc = (int)PtgCalculator.getLongValue(operands[1]);
            int mm = startDate.get(2) + inc;
            int y = startDate.get(1);
            int d = startDate.get(5);
            if (mm < 0) {
                mm += 12;
                --y;
            } else if (mm > 11) {
                mm -= 12;
                ++y;
            }
            GregorianCalendar resultDate = new GregorianCalendar(y, mm, d);
            double retdate = DateConverter.getXLSDateVal(resultDate);
            int i = (int)retdate;
            return new PtgInt(i);
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcEOMonth(Ptg[] operands) {
        try {
            GregorianCalendar startDate = DateTimeCalculator.getDateFromPtg(operands[0]);
            int inc = operands[1].getIntVal();
            int mm = startDate.get(2) + inc;
            int y = startDate.get(1);
            int d = startDate.get(5);
            if (mm < 0) {
                mm += 12;
                --y;
            } else if (mm > 11) {
                mm -= 12;
                ++y;
            }
            d = mm == 3 || mm == 5 || mm == 8 || mm == 10 ? 30 : (mm == 1 ? (y % 4 == 0 ? 29 : 28) : 31);
            GregorianCalendar resultDate = new GregorianCalendar(y, mm, d);
            double retdate = DateConverter.getXLSDateVal(resultDate);
            int i = (int)retdate;
            return new PtgInt(i);
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
    }

    protected static Ptg calcHour(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getError();
        }
        GregorianCalendar dt = DateTimeCalculator.getDateFromPtg(operands[0]);
        int retdate = dt.get(10);
        PtgInt pint = new PtgInt(retdate);
        return pint;
    }

    protected static Ptg calcMinute(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getError();
        }
        try {
            Object o = operands[0].getValue();
            GregorianCalendar dt = (GregorianCalendar)DateConverter.getCalendarFromNumber(o);
            int retdate = dt.get(12);
            PtgInt pint = new PtgInt(retdate);
            return pint;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcMonth(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getError();
        }
        try {
            GregorianCalendar dt = DateTimeCalculator.getDateFromPtg(operands[0]);
            int retdate = dt.get(2);
            PtgInt pint = new PtgInt(++retdate);
            return pint;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
    }

    protected static Ptg calcNetWorkdays(Ptg[] operands) {
        try {
            ArrayList<GregorianCalendar> holidays = new ArrayList<GregorianCalendar>();
            GregorianCalendar startDate = DateTimeCalculator.getDateFromPtg(operands[0]);
            GregorianCalendar endDate = DateTimeCalculator.getDateFromPtg(operands[1]);
            if (operands.length > 2 && operands[2] != null) {
                if (operands[2] instanceof PtgRef) {
                    Ptg[] dts = ((PtgRef)operands[2]).getComponents();
                    int i = 0;
                    while (i < dts.length) {
                        holidays.add(DateTimeCalculator.getDateFromPtg(dts[i]));
                        ++i;
                    }
                } else {
                    holidays.add(DateTimeCalculator.getDateFromPtg(operands[2]));
                }
            }
            int count = 0;
            boolean countUp = endDate.after(startDate);
            while (!startDate.equals(endDate)) {
                int d = startDate.get(7);
                if (d != 7 && d != 1) {
                    boolean OKtoIncrement = true;
                    if (holidays.size() > 0) {
                        int i = 0;
                        while (i < holidays.size()) {
                            if (startDate.equals((Calendar)holidays.get(i))) {
                                OKtoIncrement = false;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (OKtoIncrement) {
                        ++count;
                    }
                }
                if (countUp) {
                    startDate.add(5, 1);
                    continue;
                }
                startDate.add(5, -1);
            }
            return new PtgInt(count);
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcNow(Ptg[] operands) {
        GregorianCalendar gc = new GregorianCalendar(TimeZone.getDefault());
        double retdate = DateConverter.getXLSDateVal(gc);
        return new PtgNumber(retdate);
    }

    protected static Ptg calcSecond(Ptg[] operands) {
        GregorianCalendar dt = DateTimeCalculator.getDateFromPtg(operands[0]);
        int retdate = dt.get(13);
        PtgInt pint = new PtgInt(retdate);
        return pint;
    }

    protected static Ptg calcTime(Ptg[] operands) {
        Ptg o = operands[0] instanceof PtgStr ? DateTimeCalculator.calcDateValue(new Ptg[]{operands[0]}) : operands[0];
        int hour = o.getIntVal();
        int minute = operands[1].getIntVal();
        int second = operands[1].getIntVal();
        GregorianCalendar g = new GregorianCalendar(2000, 1, 1, hour, minute, second);
        GregorianCalendar g2 = new GregorianCalendar(2000, 1, 1, 0, 0, 0);
        double dub = DateConverter.getXLSDateVal(g);
        double dub2 = DateConverter.getXLSDateVal(g2);
        return new PtgNumber(dub -= dub2);
    }

    protected static Ptg calcTimevalue(Ptg[] operands) {
        double result = 0.0;
        try {
            GregorianCalendar d = DateTimeCalculator.getDateFromPtg(operands[0]);
            int h = d.get(11);
            int m = d.get(12);
            int s = d.get(13);
            double t = (double)h + (double)m / 60.0 + (double)s / 3600.0;
            result = t / 24.0;
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        return new PtgNumber(result);
    }

    protected static Ptg calcToday(Ptg[] operands) {
        Date dt = new Date(System.currentTimeMillis());
        double retdate = DateConverter.getXLSDateVal(dt);
        int i = (int)retdate;
        return new PtgInt(i);
    }

    protected static Ptg calcWeekday(Ptg[] operands) {
        if (operands.length != 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        GregorianCalendar dt = DateTimeCalculator.getDateFromPtg(operands[0]);
        int retdate = dt.get(7);
        PtgInt pint = new PtgInt(retdate);
        return pint;
    }

    protected static Ptg calcWeeknum(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        int returnType = 1;
        GregorianCalendar dt = DateTimeCalculator.getDateFromPtg(operands[0]);
        if (operands[1] != null) {
            returnType = operands[1].getIntVal();
        }
        int retdate = dt.get(3) - --returnType;
        PtgInt pint = new PtgInt(retdate);
        return pint;
    }

    protected static Ptg calcWorkday(Ptg[] operands) {
        ArrayList<GregorianCalendar> holidays = new ArrayList<GregorianCalendar>();
        try {
            GregorianCalendar dt = DateTimeCalculator.getDateFromPtg(operands[0]);
            int days = operands[1].getIntVal();
            if (operands.length > 2 && operands[2] != null) {
                if (operands[2] instanceof PtgRef) {
                    Ptg[] dts = ((PtgRef)operands[2]).getComponents();
                    int i = 0;
                    while (i < dts.length) {
                        holidays.add(DateTimeCalculator.getDateFromPtg(dts[i]));
                        ++i;
                    }
                } else {
                    holidays.add(DateTimeCalculator.getDateFromPtg(operands[2]));
                }
            }
            int absDays = Math.abs(days);
            while (absDays > 0) {
                int d = dt.get(7);
                if (d != 7 && d != 1) {
                    boolean OKtoIncrement = true;
                    if (holidays.size() > 0) {
                        int i = 0;
                        while (i < holidays.size()) {
                            if (dt.equals((Calendar)holidays.get(i))) {
                                OKtoIncrement = false;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (OKtoIncrement) {
                        --absDays;
                    }
                }
                if (days > 0) {
                    dt.add(5, 1);
                    continue;
                }
                dt.add(5, -1);
            }
            return new PtgNumber(DateConverter.getXLSDateVal(dt));
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
    }

    protected static Ptg calcYear(Ptg[] operands) {
        if (operands.length != 1) {
            return PtgCalculator.getError();
        }
        try {
            GregorianCalendar dt = DateTimeCalculator.getDateFromPtg(operands[0]);
            int retdate = dt.get(1);
            PtgInt pint = new PtgInt(retdate);
            return pint;
        }
        catch (Exception exception) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
    }

    protected static Ptg calcYearFrac(Ptg[] operands) {
        long endDate;
        long startDate;
        try {
            GregorianCalendar d = DateTimeCalculator.getDateFromPtg(operands[0]);
            startDate = new Double(DateConverter.getXLSDateVal(d)).longValue();
            d = DateTimeCalculator.getDateFromPtg(operands[1]);
            endDate = new Double(DateConverter.getXLSDateVal(d)).longValue();
        }
        catch (Exception e) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        int basis = 0;
        if (operands.length > 2) {
            basis = operands[2].getIntVal();
        }
        if (basis < 0 || basis > 4) {
            return new PtgErr(PtgErr.ERROR_NUM);
        }
        double yf = FinancialCalculator.yearFrac(basis, startDate, endDate);
        if (yf < 0.0) {
            yf *= -1.0;
        }
        return new PtgNumber(yf);
    }
}

