/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.CellNotFoundException;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.Labelsst;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgCalculator;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.formats.XLS.formulas.PtgStr;
import com.extentech.toolkit.Logger;
import java.io.File;
import java.text.DecimalFormat;

public class InformationCalculator {
    protected static Ptg calcCell(Ptg[] operands) throws FunctionNotSupportedException {
        String sh;
        String type = operands[0].getValue().toString().toLowerCase();
        PtgRef ref = null;
        BiffRec cell = null;
        if (operands.length > 1) {
            ref = (PtgRef)operands[1];
            try {
                cell = ref.getParentRec().getWorkBook().getCell(ref.getLocationWithSheet());
            }
            catch (CellNotFoundException e) {
                try {
                    sh = null;
                    try {
                        sh = ref.getSheetName();
                    }
                    catch (WorkSheetNotFoundException workSheetNotFoundException) {
                        // empty catch block
                    }
                    if (sh == null) {
                        sh = ref.getParentRec().getSheet().getSheetName();
                    }
                    cell = ref.getParentRec().getWorkBook().getWorkSheetByName(sh).addValue(null, ref.getLocation());
                }
                catch (Exception ex) {
                    return new PtgErr(PtgErr.ERROR_VALUE);
                }
            }
            catch (Exception e) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
        } else {
            if (!type.equals("filename")) {
                throw new FunctionNotSupportedException("Worsheet function CELL with no reference parameter is not supported");
            }
            cell = operands[0].getParentRec();
        }
        try {
            if (type.equals("address")) {
                PtgRef newref = ref;
                newref.clearLocationCache();
                newref.fColRel = false;
                newref.fRwRel = false;
                return new PtgStr(newref.getLocation());
            }
            if (type.equals("col")) {
                return new PtgNumber(ref.getIntLocation()[1] + 1);
            }
            if (type.equals("color")) {
                String s = cell.getFormatPattern();
                if (s.indexOf(";[Red") > -1) {
                    return new PtgNumber(1.0);
                }
                return new PtgNumber(0.0);
            }
            if (type.equals("contents")) {
                return new PtgStr(cell.getStringVal());
            }
            if (type.equals("filename")) {
                String f = cell.getWorkBook().getFileName();
                sh = cell.getSheet().getSheetName();
                int i = f.lastIndexOf(File.separatorChar);
                f = String.valueOf(f.substring(0, i + 1)) + "[" + f.substring(i + 1);
                f = String.valueOf(f) + "]" + sh;
                return new PtgStr(f);
            }
            if (type.equals("format")) {
                String s = cell.getFormatPattern();
                String ret = "G";
                if (s.equals("General") || s.equals("# ?/?") || s.equals("# ??/??")) {
                    ret = "G";
                } else if (s.equals("0")) {
                    ret = "F0";
                } else if (s.equals("#,##0")) {
                    ret = ",0";
                } else if (s.equals("0.00")) {
                    ret = "F2";
                } else if (s.equals("#,##0.00")) {
                    ret = ", 2";
                } else if (s.equals("$#,##0_);($#,##0)")) {
                    ret = "C0";
                } else if (s.equals("$#,##0_);[Red]($#,##0)")) {
                    ret = "C0-";
                } else if (s.equals("$#,##0.00_);($#,##0.00)")) {
                    ret = "C2";
                } else if (s.equals("$#,##0.00_);[Red]($#,##0.00)")) {
                    ret = "C2-";
                } else if (s.equals("0%")) {
                    ret = "P0";
                } else if (s.equals("0.00%")) {
                    ret = "P2";
                } else if (s.equals("0.00E+00")) {
                    ret = "S2";
                } else if (s.equals("m/d/yy") || s.equals("m/d/yy h:mm") || s.equals("mm/dd/yy") || s.equals("mm-dd-yy")) {
                    ret = "D4";
                } else if (s.equals("d-mmm-yy") || s.equals("dd-mmm-yy")) {
                    ret = "D1";
                } else if (s.equals("d-mmm") || s.equals("dd-mmm")) {
                    ret = "D2";
                } else if (s.equals("mmm-yy")) {
                    ret = "D3";
                } else if (s.equals("mm/dd")) {
                    ret = "D5";
                } else if (s.equals("h:mm AM/PM")) {
                    ret = "D7";
                } else if (s.equals("h:mm:ss AM/PM")) {
                    ret = "D6";
                } else if (s.equals("h:mm")) {
                    ret = "D9";
                } else if (s.equals("h:mm:ss")) {
                    ret = "D8";
                }
                return new PtgStr(ret);
            }
            if (type.equals("parentheses")) {
                String s = cell.getFormatPattern();
                if (s.startsWith("(")) {
                    return new PtgNumber(1.0);
                }
                return new PtgNumber(0.0);
            }
            if (type.equals("prefix")) {
                int al = cell.getXfRec().getHorizontalAlignment();
                if (al == 1) {
                    return new PtgStr("'");
                }
                if (al == 2) {
                    return new PtgStr("^");
                }
                if (al == 3) {
                    return new PtgStr("\"");
                }
                if (al == 4) {
                    return new PtgStr("\\");
                }
                return new PtgStr("");
            }
            if (type.equals("protect")) {
                if (cell.getXfRec().isLocked()) {
                    return new PtgNumber(1.0);
                }
                return new PtgNumber(0.0);
            }
            if (type.equals("row")) {
                return new PtgNumber(ref.getIntLocation()[0] + 1);
            }
            if (type.equals("type")) {
                if (((XLSRecord)cell).isBlank) {
                    return new PtgStr("b");
                }
                if (cell instanceof Labelsst) {
                    return new PtgStr("l");
                }
                return new PtgStr("v");
            }
            if (type.equals("width")) {
                int n = 0;
                n = cell.getSheet().getColInfo(cell.getColNumber()).getColWidthInChars();
                return new PtgNumber(n);
            }
        }
        catch (Exception e) {
            Logger.logWarn("CELL: unable to calculate: " + e.toString());
        }
        return new PtgErr(PtgErr.ERROR_VALUE);
    }

    protected static Ptg calcErrorType(Ptg[] operands) {
        Object o = operands[0].getValue();
        String s = o.toString();
        if (s.equalsIgnoreCase("#NULL!")) {
            return new PtgInt(1);
        }
        if (s.equalsIgnoreCase("#DIV/0!")) {
            return new PtgInt(2);
        }
        if (s.equalsIgnoreCase("#VALUE!")) {
            return new PtgInt(3);
        }
        if (s.equalsIgnoreCase("#REF!")) {
            return new PtgInt(4);
        }
        if (s.equalsIgnoreCase("#NAME?")) {
            return new PtgInt(5);
        }
        if (s.equalsIgnoreCase("#NUM!")) {
            return new PtgInt(6);
        }
        if (s.equalsIgnoreCase("#N/A")) {
            return new PtgInt(7);
        }
        return new PtgErr(PtgErr.ERROR_NA);
    }

    protected static Ptg calcInfo(Ptg[] operands) {
        if (operands == null || operands.length == 0 || operands[0].getParentRec() == null) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        String type_text = operands[0].getString();
        String ret = "";
        if (type_text.equals("directory")) {
            return new PtgStr(String.valueOf(System.getProperty("user.dir").toLowerCase()) + "\\");
        }
        if (type_text.equals("numfile")) {
            return new PtgNumber(operands[0].getParentRec().getWorkBook().getNumWorkSheets());
        }
        if (type_text.equals("origin")) {
            String cell = operands[0].getParentRec().getSheet().getWindow2().getTopLeftCell();
            int i = cell.length() - 1;
            while (i >= 0) {
                if (!Character.isDigit(cell.charAt(i))) {
                    cell = String.valueOf(cell.substring(0, i + 1)) + "$" + cell.substring(i + 1);
                    break;
                }
                --i;
            }
            cell = "$A:$" + cell;
            return new PtgStr(cell);
        }
        if (type_text.equals("osversion")) {
            String osversion = System.getProperty("os.version");
            String n = System.getProperty("os.name");
            String os = "";
            if (n.startsWith("Windows")) {
                double v = new Double(osversion);
                os = "Windows (32-bit) ";
                if (v >= 5.0) {
                    os = String.valueOf(os) + "NT ";
                }
                DecimalFormat df = new DecimalFormat("##.00");
                os = String.valueOf(os) + df.format(v);
            } else {
                os = String.valueOf(os) + osversion;
            }
            return new PtgStr(os);
        }
        if (type_text.equals("recalc")) {
            if (operands[0].getParentRec().getWorkBook().getRecalculationMode() == 0) {
                return new PtgStr("Manual");
            }
            return new PtgStr("Automatic");
        }
        if (type_text.equals("release")) {
            Logger.logWarn("Worksheet Function INFO(\"release\") is not supported");
            return new PtgStr("");
        }
        if (type_text.equals("system")) {
            if (System.getProperty("os.name").indexOf("Windows") >= 0) {
                return new PtgStr("pcdos");
            }
            return new PtgStr("mac");
        }
        if (type_text.equals("memavail") || type_text.equals("memused") || type_text.equals("totmem")) {
            return new PtgErr(PtgErr.ERROR_NA);
        }
        return new PtgErr(PtgErr.ERROR_VALUE);
    }

    protected static Ptg calcIsBlank(Ptg[] operands) {
        Ptg[] allops = PtgCalculator.getAllComponents(operands);
        int i = 0;
        while (i < allops.length) {
            if (!allops[i].isBlank()) {
                return new PtgBool(false);
            }
            ++i;
        }
        return new PtgBool(true);
    }

    protected static Ptg calcIserror(Ptg[] operands) {
        if (operands[0] instanceof PtgErr) {
            return new PtgBool(true);
        }
        String[] errorstr = new String[]{"#N/A", "#VALUE!", "#REF!", "#DIV/0!", "#NUM!", "#NAME?", "#NULL!"};
        Object o = operands[0].getValue();
        String opval = o.toString();
        int i = 0;
        while (i < errorstr.length) {
            if (opval.equalsIgnoreCase(errorstr[i])) {
                return new PtgBool(true);
            }
            ++i;
        }
        return new PtgBool(false);
    }

    protected static Ptg calcIserr(Ptg[] operands) {
        String[] errorstr = new String[]{"#VALUE!", "#REF!", "#DIV/0!", "#NUM!", "#NAME?", "#NULL!"};
        if (operands.length != 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        Object o = operands[0].getValue();
        String opval = o.toString();
        int i = 0;
        while (i < errorstr.length) {
            if (opval.equalsIgnoreCase(errorstr[i])) {
                return new PtgBool(true);
            }
            ++i;
        }
        return new PtgBool(false);
    }

    protected static Ptg calcIsEven(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        Ptg[] allops = PtgCalculator.getAllComponents(operands);
        if (allops.length > 1) {
            return new PtgBool(false);
        }
        Object o = operands[0].getValue();
        if (o != null) {
            try {
                if (o instanceof Integer) {
                    int s = (Integer)o;
                    if (s < 0) {
                        return new PtgBool(false);
                    }
                    return new PtgBool(s % 2 == 0);
                }
                if (o instanceof Float) {
                    float s = ((Float)o).floatValue();
                    if (s < 0.0f) {
                        return new PtgBool(false);
                    }
                    return new PtgBool(s % 2.0f == 0.0f);
                }
                if (o instanceof Double) {
                    double s = (Double)o;
                    if (s < 0.0) {
                        return new PtgBool(false);
                    }
                    return new PtgBool(s % 2.0 == 0.0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PtgErr(PtgErr.ERROR_VALUE);
    }

    protected static Ptg calcIsLogical(Ptg[] operands) {
        Ptg[] allops = PtgCalculator.getAllComponents(operands);
        if (allops.length > 1) {
            return new PtgBool(false);
        }
        Object o = operands[0].getValue();
        try {
            Boolean b = (Boolean)o;
            return new PtgBool(true);
        }
        catch (ClassCastException classCastException) {
            return new PtgBool(false);
        }
    }

    protected static Ptg calcIsNumber(Ptg[] operands) {
        Ptg[] allops = PtgCalculator.getAllComponents(operands);
        if (allops.length > 1) {
            return new PtgBool(false);
        }
        Object o = operands[0].getValue();
        try {
            Float f = (Float)o;
            return new PtgBool(true);
        }
        catch (ClassCastException e) {
            try {
                Double d = (Double)o;
                return new PtgBool(true);
            }
            catch (ClassCastException ee) {
                try {
                    Integer ii = (Integer)o;
                    return new PtgBool(true);
                }
                catch (ClassCastException classCastException) {
                    return new PtgBool(false);
                }
            }
        }
    }

    protected static Ptg calcIsNonText(Ptg[] operands) {
        Ptg[] allops = PtgCalculator.getAllComponents(operands);
        if (allops.length > 1) {
            return new PtgBool(false);
        }
        if (allops[0].isBlank()) {
            return new PtgBool(true);
        }
        Object o = operands[0].getValue();
        if (o != null) {
            try {
                String s = (String)o;
                return new PtgBool(false);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return new PtgBool(true);
    }

    protected static Ptg calcIsna(Ptg[] operands) {
        Object o;
        PtgErr per;
        if (operands.length != 1) {
            return PtgCalculator.getError();
        }
        if (operands[0] instanceof PtgErr ? (per = (PtgErr)operands[0]).getErrorType() == PtgErr.ERROR_NA : operands[0].getIsReference() && (o = operands[0].getValue()).toString().equalsIgnoreCase(new PtgErr(PtgErr.ERROR_NA).toString())) {
            return new PtgBool(true);
        }
        return new PtgBool(false);
    }

    protected static Ptg calcNa(Ptg[] operands) {
        return new PtgErr(PtgErr.ERROR_NA);
    }

    protected static Ptg calcIsText(Ptg[] operands) {
        Ptg[] allops = PtgCalculator.getAllComponents(operands);
        if (allops.length > 1) {
            return new PtgBool(false);
        }
        Object o = operands[0].getValue();
        if (o != null) {
            try {
                String s = (String)o;
                return new PtgBool(true);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return new PtgBool(false);
    }

    protected static Ptg calcIsOdd(Ptg[] operands) {
        if (operands.length < 1) {
            return new PtgErr(PtgErr.ERROR_VALUE);
        }
        Ptg[] allops = PtgCalculator.getAllComponents(operands);
        if (allops.length > 1) {
            return new PtgBool(false);
        }
        Object o = operands[0].getValue();
        if (o != null) {
            try {
                if (o instanceof Integer) {
                    int s = (Integer)o;
                    if (s < 0) {
                        return new PtgBool(false);
                    }
                    return new PtgBool(s % 2 != 0);
                }
                if (o instanceof Float) {
                    float s = ((Float)o).floatValue();
                    if (s < 0.0f) {
                        return new PtgBool(false);
                    }
                    return new PtgBool(s % 2.0f != 0.0f);
                }
                if (o instanceof Double) {
                    double s = (Double)o;
                    if (s < 0.0) {
                        return new PtgBool(false);
                    }
                    return new PtgBool(s % 2.0 != 0.0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PtgErr(PtgErr.ERROR_VALUE);
    }

    protected static Ptg calcIsRef(Ptg[] operands) {
        if (operands[0].getIsReference()) {
            return new PtgBool(true);
        }
        return new PtgBool(false);
    }

    protected static Ptg calcN(Ptg[] operands) {
        Boolean b;
        boolean bo;
        Object o = operands[0].getValue();
        if (o instanceof Double || o instanceof Integer || o instanceof Float || o instanceof Long) {
            Double d = new Double(o.toString());
            return new PtgNumber(d);
        }
        if (o instanceof Boolean && (bo = (b = (Boolean)o).booleanValue())) {
            return new PtgInt(1);
        }
        return new PtgInt(0);
    }

    protected static Ptg calcType(Ptg[] operands) {
        if (operands[0] instanceof PtgArray) {
            return new PtgNumber(64.0);
        }
        if (operands[0] instanceof PtgErr) {
            return new PtgNumber(16.0);
        }
        Object value = operands[0].getValue();
        int type = 0;
        if (value instanceof String) {
            type = 2;
        } else if (value instanceof Number) {
            type = 1;
        } else if (value instanceof Boolean) {
            type = 4;
        }
        return new PtgNumber(type);
    }
}

