/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.Array;
import com.extentech.formats.XLS.BiffRec;
import com.extentech.formats.XLS.Boundsheet;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.Row;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea3d;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.FastAddVector;
import com.extentech.toolkit.Logger;
import java.util.Vector;

public class PtgArea
extends PtgRef
implements Ptg {
    public static final long serialVersionUID = 666555444333222L;
    protected PtgRef firstPtg;
    protected PtgRef lastPtg;

    @Override
    public boolean getIsOperand() {
        return true;
    }

    @Override
    public boolean getIsReference() {
        return true;
    }

    @Override
    public void init(byte[] b) {
        this.locax = null;
        this.ptgId = b[0];
        this.record = b;
        this.populateVals();
    }

    @Override
    public void populateVals() {
        byte[] temp1 = new byte[5];
        byte[] temp2 = new byte[5];
        temp1[0] = 36;
        temp2[0] = 36;
        System.arraycopy(this.record, 1, temp1, 1, 2);
        System.arraycopy(this.record, 5, temp1, 3, 2);
        System.arraycopy(this.record, 3, temp2, 1, 2);
        System.arraycopy(this.record, 7, temp2, 3, 2);
        try {
            this.getSheetName();
        }
        catch (WorkSheetNotFoundException we) {
            Logger.logErr(we);
        }
        this.firstPtg = new PtgRef(temp1, this.parent_rec, false);
        this.firstPtg.sheetname = this.sheetname;
        this.lastPtg = new PtgRef(temp2, this.parent_rec, false);
        this.lastPtg.sheetname = this.sheetname;
        this.setWholeRowCol();
        this.hashcode = this.getHashCode();
    }

    @Override
    public Ptg[] getComponents() {
        Vector<PtgRef> v = new Vector<PtgRef>();
        try {
            int startcol = -1;
            int startrow = -1;
            int endrow = -1;
            int endcol = -1;
            int[] startloc = null;
            int[] endloc = null;
            if (this.firstPtg != null) {
                startloc = this.firstPtg.getRealIntLocation();
                startcol = startloc[1];
                startrow = startloc[0];
            } else {
                startloc = ExcelTools.getRangeRowCol(this.locax);
                startcol = startloc[1];
                startrow = startloc[0];
            }
            if (this.lastPtg != null) {
                endloc = this.lastPtg.getRealIntLocation();
                endcol = endloc[1];
                endrow = endloc[0];
            } else {
                endloc = ExcelTools.getRangeRowCol(this.locax);
                endcol = endloc[3];
                endrow = endloc[2];
            }
            String sht = null;
            Boundsheet sh = this.parent_rec.getSheet();
            if (!(sh != null && (this.sheetname == null || this.sheetname.equals(sh.getSheetName())) || sh != null && GenericPtg.qualifySheetname(this.sheetname).equals(GenericPtg.qualifySheetname(sh.getSheetName())))) {
                sht = String.valueOf(this.sheetname) + "!";
            }
            while (startcol <= endcol) {
                int rowholder = startrow;
                while (rowholder <= endrow) {
                    String displaycol = ExcelTools.getAlphaVal(startcol);
                    int displayrow = rowholder + 1;
                    PtgRef pref = sht == null ? new PtgRef(String.valueOf(displaycol) + displayrow, this.parent_rec, false) : new PtgRef(String.valueOf(sht) + displaycol + displayrow, this.parent_rec, false);
                    v.add(pref);
                    ++rowholder;
                }
                ++startcol;
            }
        }
        catch (Exception e) {
            Logger.logErr("calculating formula range value failed.", e);
        }
        Ptg[] pref = new PtgRef[v.size()];
        v.toArray(pref);
        return pref;
    }

    @Override
    public int[] getRowCol() {
        if (this.firstPtg == null) {
            return null;
        }
        if (this.lastPtg == null && this.firstPtg != null) {
            int[] rc1 = this.firstPtg.getRowCol();
            int[] ret = new int[]{rc1[0], rc1[1], rc1[0], rc1[1]};
            return ret;
        }
        int[] rc1 = this.firstPtg.getRowCol();
        int[] rc2 = this.lastPtg.getRowCol();
        int[] ret = new int[]{rc1[0], rc1[1], rc2[0], rc2[1]};
        return ret;
    }

    public boolean contains(CellHandle ch) {
        XLSRecord b;
        String chsheet = ch.getWorkSheetName();
        String mysheet = "";
        if (this.getParentRec() != null && (b = this.getParentRec()).getSheet() != null) {
            mysheet = b.getSheet().getSheetName();
        }
        if (!chsheet.equalsIgnoreCase(mysheet)) {
            return false;
        }
        String adr = ch.getCellAddress();
        int[] rc = ExcelTools.getRowColFromString(adr);
        return this.contains(rc);
    }

    public boolean contains(String sn, int[] rc) {
        if (this.sheetname == null) {
            try {
                this.sheetname = this.getSheetName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!sn.equalsIgnoreCase(this.sheetname)) {
            return false;
        }
        return this.contains(rc);
    }

    public boolean contains(int[] rc) {
        int[] thisRange = this.getIntLocation();
        if (rc[0] < thisRange[0]) {
            return false;
        }
        if (rc[0] > thisRange[2]) {
            return false;
        }
        if (rc[1] < thisRange[1]) {
            return false;
        }
        return rc[1] <= thisRange[3];
    }

    @Override
    public String getString() {
        return this.getLocation();
    }

    public PtgArea(String range, XLSRecord parent) {
        this(range, parent, true);
    }

    public PtgArea(PtgRef ptg1, PtgRef ptg2, XLSRecord parent) {
        this();
        this.firstPtg = ptg1;
        this.lastPtg = ptg2;
        this.parent_rec = parent;
        this.hashcode = this.getHashCode();
        this.updateRecord();
    }

    public PtgArea(String range, XLSRecord parent, boolean relativeRefs) {
        this();
        int[] loc = ExcelTools.getRangeRowCol(range);
        int[] temp = new int[]{loc[0], loc[1]};
        String res = ExcelTools.formatLocation(temp, relativeRefs, relativeRefs);
        this.firstPtg = new PtgRef(res, parent, false);
        temp[0] = loc[2];
        temp[1] = loc[3];
        res = ExcelTools.formatLocation(temp, relativeRefs, relativeRefs);
        this.lastPtg = new PtgRef(res, parent, false);
        this.setWholeRowCol();
        this.parent_rec = parent;
        this.hashcode = this.getHashCode();
        this.updateRecord();
    }

    public PtgArea(int[] loc, XLSRecord parent, boolean relativeRefs) {
        int[] temp = new int[]{loc[0], loc[1]};
        String res = ExcelTools.formatLocation(temp, relativeRefs, relativeRefs);
        this.firstPtg = new PtgRef(res, parent, false);
        temp[0] = loc[2];
        temp[1] = loc[3];
        res = ExcelTools.formatLocation(temp, relativeRefs, relativeRefs);
        this.lastPtg = new PtgRef(res, parent, false);
        this.setWholeRowCol();
        this.parent_rec = parent;
        this.hashcode = this.getHashCode();
        this.updateRecord();
    }

    public void setWholeRowCol() {
        if (this.firstPtg.rw <= 1 && this.lastPtg.wholeCol) {
            this.wholeCol = true;
        }
        this.wholeRow = this.lastPtg.wholeRow;
        if (this.wholeCol) {
            this.useReferenceTracker = false;
        }
    }

    public PtgArea() {
        this.record = new byte[9];
        this.ptgId = (byte)37;
        this.record[0] = 37;
    }

    public PtgArea(boolean useReferenceTracker) {
        this();
        this.useReferenceTracker = useReferenceTracker;
    }

    @Override
    public void setPtgType(short type) {
        switch (type) {
            case 0: {
                this.ptgId = (byte)69;
                break;
            }
            case 1: {
                this.ptgId = (byte)37;
                break;
            }
            case 2: {
                this.ptgId = (byte)101;
            }
        }
        this.record[0] = this.ptgId;
    }

    @Override
    public String toString() {
        String ret = this.getString();
        if (this.getParentRec() != null && ret.indexOf("!") < 0) {
            try {
                this.getSheetName();
                if (this.sheetname != null) {
                    ret = String.valueOf(this.sheetname) + "!" + ret;
                }
            }
            catch (WorkSheetNotFoundException we) {
                Logger.logErr(we);
            }
        }
        return ret;
    }

    @Override
    public void setParentRec(XLSRecord rec) {
        super.setParentRec(rec);
        if (this.firstPtg != null) {
            this.firstPtg.setParentRec(this.parent_rec);
        }
        if (this.lastPtg != null) {
            this.lastPtg.setParentRec(this.parent_rec);
        }
    }

    @Override
    public void setLocation(String address) {
        String[] s = ExcelTools.stripSheetNameFromRange(address);
        this.setLocation(s);
        this.hashcode = this.getHashCode();
    }

    @Override
    public void setLocation(String[] loc) {
        int i;
        this.locax = null;
        if (this.firstPtg == null) {
            byte[] byArray = new byte[9];
            byArray[0] = 37;
            this.record = byArray;
            if (this.getParentRec() != null) {
                this.populateVals();
            }
        } else if (this.useReferenceTracker) {
            this.removeFromRefTracker();
        }
        if ((i = loc[1].indexOf(":")) == -1) {
            loc[1] = String.valueOf(loc[1]) + ":" + loc[1];
            i = loc[1].indexOf(":");
        }
        String firstloc = loc[1].substring(0, i);
        String lastloc = loc[1].substring(i + 1);
        if (loc[0] != null) {
            firstloc = String.valueOf(loc[0]) + "!" + firstloc;
        }
        if (loc[2] != null) {
            lastloc = String.valueOf(loc[2]) + "!" + lastloc;
        }
        if (loc[3] != null) {
            firstloc = String.valueOf(loc[3]) + firstloc;
        }
        if (loc[4] != null) {
            lastloc = String.valueOf(loc[4]) + lastloc;
        }
        this.firstPtg.setParentRec(this.getParentRec());
        this.lastPtg.setParentRec(this.getParentRec());
        this.firstPtg.setUseReferenceTracker(false);
        this.lastPtg.setUseReferenceTracker(false);
        this.firstPtg.setLocation(firstloc);
        this.lastPtg.setLocation(lastloc);
        this.setWholeRowCol();
        this.hashcode = this.getHashCode();
        this.updateRecord();
        if (this.useReferenceTracker) {
            if (!this.getIsWholeCol() && !this.getIsWholeRow()) {
                this.addToRefTracker();
            } else {
                this.useReferenceTracker = false;
            }
        }
    }

    @Override
    public int[] getIntLocation() {
        int[] first = this.firstPtg.getIntLocation();
        int[] last = this.lastPtg.getIntLocation();
        int[] returning = new int[4];
        System.arraycopy(first, 0, returning, 0, 2);
        System.arraycopy(last, 0, returning, 2, 2);
        return returning;
    }

    @Override
    public void setLocation(int[] rowcol) {
        this.locax = null;
        if (this.firstPtg == null) {
            if (this.getParentRec() != null) {
                this.populateVals();
            }
        } else if (this.useReferenceTracker) {
            this.removeFromRefTracker();
        }
        this.firstPtg.setParentRec(this.getParentRec());
        this.firstPtg.setSheetName(this.sheetname);
        this.lastPtg.setParentRec(this.getParentRec());
        this.lastPtg.setSheetName(this.sheetname);
        this.firstPtg.setUseReferenceTracker(false);
        this.lastPtg.setUseReferenceTracker(false);
        this.firstPtg.setLocation(rowcol);
        int[] rc = new int[]{rowcol[2], rowcol[3]};
        this.lastPtg.setLocation(rc);
        this.hashcode = this.getHashCode();
        this.updateRecord();
        if (this.useReferenceTracker) {
            this.addToRefTracker();
        }
    }

    @Override
    public String getLocation() {
        String lc;
        this.locax = lc = this.getLocationHelper();
        return lc;
    }

    private String getLocationHelper() {
        if (this.firstPtg == null || this.lastPtg == null) {
            this.populateVals();
            if (this.firstPtg == null || this.lastPtg == null) {
                throw new AssertionError((Object)"PtgArea.getLocationHelper null ptgs");
            }
        }
        String s = this.firstPtg.getLocation();
        String y = this.lastPtg.getLocation();
        String[] loc1 = ExcelTools.stripSheetNameFromRange(s);
        String[] loc2 = ExcelTools.stripSheetNameFromRange(y);
        String sh1 = loc1[0];
        String sh2 = loc2[0];
        String addr1 = loc1[1];
        String addr2 = loc2[1];
        if (!(this instanceof PtgArea3d)) {
            return String.valueOf(addr1) + ":" + addr2;
        }
        if (sh1 == null) {
            sh1 = this.sheetname;
        }
        if (sh1 == null) {
            return String.valueOf(addr1) + ":" + addr2;
        }
        if (this.externalLink1 > 0) {
            sh1 = "[" + this.externalLink1 + "]" + sh1;
        }
        if (this.externalLink2 > 0 && sh2 != null) {
            sh2 = "[" + this.externalLink2 + "]" + sh2;
        }
        if ((sh1 = PtgArea.qualifySheetname(sh1)).equals(sh2)) {
            if (!sh1.equals("")) {
                if (!addr1.equals(addr2)) {
                    return String.valueOf(sh1) + "!" + addr1 + ":" + addr2;
                }
                return String.valueOf(sh1) + "!" + addr1;
            }
            if (this.sheetname != null) {
                sh1 = this.sheetname;
                if (this.externalLink1 > 0) {
                    sh1 = "[" + this.externalLink1 + "]" + sh1;
                }
                sh1 = PtgArea.qualifySheetname(sh1);
                if (!addr1.equals(addr2)) {
                    return String.valueOf(sh1) + "!" + addr1 + ":" + addr2;
                }
                return String.valueOf(sh1) + "!" + addr1;
            }
        } else if (sh2 == null) {
            if (!addr1.equals(addr2)) {
                return String.valueOf(sh1) + "!" + addr1 + ":" + addr2;
            }
            return String.valueOf(sh1) + "!" + addr1;
        }
        sh2 = PtgArea.qualifySheetname(sh2);
        return String.valueOf(sh1) + ":" + sh2 + "!" + addr1 + ":" + addr2;
    }

    @Override
    public void updateRecord() {
        this.locax = null;
        int[] pols = new int[]{this.firstPtg.getLocationPolicy(), this.lastPtg.getLocationPolicy()};
        byte[] first = this.firstPtg.getRecord();
        byte[] last = this.lastPtg.getRecord();
        byte[] newrecord = new byte[9];
        newrecord[0] = this.record[0];
        System.arraycopy(first, 1, newrecord, 1, 2);
        System.arraycopy(last, 1, newrecord, 3, 2);
        System.arraycopy(first, 3, newrecord, 5, 2);
        System.arraycopy(last, 3, newrecord, 7, 2);
        this.record = newrecord;
        if (this.parent_rec != null) {
            if (this.parent_rec instanceof Formula) {
                ((Formula)this.parent_rec).updateRecord();
            } else if (this.parent_rec instanceof Name) {
                ((Name)this.parent_rec).updatePtgs();
            }
        }
        this.firstPtg.setLocationPolicy(pols[0]);
        this.lastPtg.setLocationPolicy(pols[1]);
    }

    @Override
    public int getLength() {
        return 9;
    }

    @Override
    public Object getValue() {
        this.refCell = this.getRefCells();
        Object returnval = new Double(0.0);
        String retstr = null;
        String array = "";
        boolean isArray = this.parent_rec instanceof Array;
        int t = 0;
        while (t < this.refCell.length) {
            BiffRec cel = this.refCell[t];
            if (cel != null) {
                try {
                    Formula f = cel.getFormulaRec();
                    if (f != null) {
                        Object oby = f.calculateFormula();
                        String s = String.valueOf(oby);
                        try {
                            returnval = new Double(s);
                        }
                        catch (NumberFormatException ex) {
                            retstr = s;
                        }
                    } else {
                        returnval = cel.getInternalVal();
                    }
                }
                catch (FunctionNotSupportedException f) {
                }
                catch (Exception e) {
                    returnval = cel.getInternalVal();
                }
                if (!isArray) break;
                array = retstr != null ? String.valueOf(array) + retstr + "," : String.valueOf(array) + returnval + ",";
                retstr = null;
            }
            ++t;
        }
        if (isArray && array != null && array.length() > 1) {
            array = "{" + array.substring(0, array.length() - 1) + "}";
            PtgArray pa = new PtgArray();
            pa.setVal(array);
            return pa;
        }
        if (retstr != null) {
            return retstr;
        }
        return returnval;
    }

    public Ptg[] getColComponents(int colNum) {
        PtgArea par;
        Ptg[] ret;
        if (colNum < 0) {
            return null;
        }
        String lu = this.toString();
        Object p = this.parent_rec.getWorkBook().getRefTracker().getVlookups().get(lu);
        if (p != null && (ret = (Ptg[])(par = (PtgArea)p).getParentRec().getWorkBook().getRefTracker().getLookupColCache().get(String.valueOf(lu) + ":" + Integer.valueOf(colNum))) != null) {
            return ret;
        }
        Ptg[] v = null;
        try {
            int[] startloc = this.firstPtg.getRealIntLocation();
            int startcol = colNum;
            int startrow = startloc[0];
            int[] endloc = this.lastPtg.getRealIntLocation();
            int endrow = endloc[0];
            if (endrow < startrow) {
                endrow = startrow;
            }
            int sz = endrow - startrow;
            v = new PtgRef[++sz];
            int rowholder = startrow;
            int pos = 0;
            String sht = this.toString();
            if (sht.indexOf("!") > -1) {
                sht = sht.substring(0, sht.indexOf("!"));
            }
            while (rowholder <= endrow) {
                String displaycol = ExcelTools.getAlphaVal(startcol);
                int displayrow = rowholder + 1;
                String loc = String.valueOf(sht) + "!" + displaycol + displayrow;
                PtgRef pref = new PtgRef(loc, this.parent_rec, this.useReferenceTracker);
                v[pos++] = pref;
                ++rowholder;
            }
        }
        catch (Exception e) {
            Logger.logErr("Getting column range in PtgArea failed.", e);
        }
        this.parent_rec.getWorkBook().getRefTracker().getVlookups().put(this.toString(), this);
        this.parent_rec.getWorkBook().getRefTracker().getLookupColCache().put(String.valueOf(lu) + ":" + Integer.valueOf(colNum), v);
        return v;
    }

    public Ptg[] getRowComponents(int rowNum) {
        FastAddVector v = new FastAddVector();
        Ptg[] allComponents = this.getComponents();
        int i = 0;
        while (i < allComponents.length) {
            PtgRef p = (PtgRef)allComponents[i];
            int[] x = p.getRealIntLocation();
            if (x[0] == rowNum) {
                v.add(p);
            }
            ++i;
        }
        Object[] pref = new PtgRef[v.size()];
        v.toArray(pref);
        return pref;
    }

    public PtgRef getFirstPtg() {
        return this.firstPtg;
    }

    public PtgRef getLastPtg() {
        return this.lastPtg;
    }

    public void setFirstPtg(PtgRef ref) {
        this.locax = null;
        this.firstPtg = ref;
    }

    public void setLastPtg(PtgRef ref) {
        this.locax = null;
        this.lastPtg = ref;
    }

    @Override
    public BiffRec[] getRefCells() {
        double returnval = 0.0;
        try {
            int totcell;
            Boundsheet bs = null;
            this.getSheetName();
            if (this.sheetname != null) {
                try {
                    bs = this.parent_rec.getWorkBook().getWorkSheetByName(this.sheetname);
                }
                catch (Exception ex) {
                    bs = this.parent_rec.getSheet();
                }
            } else {
                bs = this.parent_rec.getSheet();
                this.sheetname = bs.getSheetName();
            }
            int[] startloc = this.firstPtg.getIntLocation();
            int startcol = startloc[1];
            int startrow = startloc[0];
            int[] endloc = this.lastPtg.getRealIntLocation();
            int endcol = endloc[1];
            int endrow = endloc[0];
            int numcols = endcol - startcol;
            if (numcols < 0) {
                numcols = startcol - endcol;
            }
            ++numcols;
            int numrows = endrow - startrow;
            if (numrows < 0) {
                numrows = startrow - endrow;
            }
            if ((totcell = numcols * ++numrows) == 0) {
                ++totcell;
            }
            if (totcell < 0) {
                Logger.logErr("PtgArea.getRefCells.  Error in Ptg locations: " + this.firstPtg.toString() + ":" + this.lastPtg.toString());
                totcell = 0;
            }
            this.refCell = new BiffRec[totcell];
            int rowctr = 0;
            endcol = startcol < endcol ? ++endcol : --endcol;
            endrow = startrow < endrow ? ++endrow : --endrow;
            while (startcol != endcol) {
                int rowpos = startrow;
                while (rowpos != endrow) {
                    Row r2 = bs.getRowByNumber(rowpos);
                    if (r2 != null) {
                        this.refCell[rowctr] = r2.getCell((short)startcol);
                    }
                    ++rowctr;
                    if (rowpos < endrow) {
                        ++rowpos;
                        continue;
                    }
                    --rowpos;
                }
                if (startcol < endcol) {
                    ++startcol;
                    continue;
                }
                --startcol;
            }
        }
        catch (Exception ex) {
            Logger.logErr("PtgArea.getRefCells failed.", ex);
        }
        return this.refCell;
    }

    @Override
    protected long getHashCode() {
        return this.lastPtg.hashcode + this.firstPtg.hashcode * 0x400004000L;
    }
}

