/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.formulas.CalculationException;
import com.extentech.formats.XLS.formulas.CircularReferenceException;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.formats.XLS.formulas.PtgInt;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.CompatibleVector;
import com.extentech.toolkit.FastAddVector;
import com.extentech.toolkit.Logger;
import java.util.Enumeration;

public class PtgCalculator {
    protected static long getLongValue(Ptg[] operands) {
        Ptg[] components = operands[0].getComponents();
        if (components != null && components.length > 1) {
            return 0L;
        }
        if (operands.length > 1) {
            Logger.logWarn("PtgCalculator getting Long Value for operand failed: - UNSUPPORTED BY FUNCTION");
            return 0L;
        }
        Double d = null;
        try {
            d = new Double(operands[0].getDoubleVal());
        }
        catch (NumberFormatException e) {
            Logger.logWarn("PtgCalculator getting Long Value for operand failed: " + e);
            return 0L;
        }
        return d.longValue();
    }

    protected static long getLongValue(Ptg operand) {
        Ptg[] ptgArr = new Ptg[]{operand};
        return PtgCalculator.getLongValue(ptgArr);
    }

    protected static long[] getLongValueArray(Ptg[] operands) {
        Ptg[] alloperands = PtgCalculator.getAllComponents(operands);
        long[] l = new long[alloperands.length];
        int i = 0;
        while (i < alloperands.length) {
            try {
                Double dd = new Double(operands[i].getDoubleVal());
                l[i] = dd.longValue();
            }
            catch (NumberFormatException e) {
                Logger.logWarn("PtgCalculator getting Long value array failed: " + e);
                l[i] = 0L;
            }
            ++i;
        }
        return l;
    }

    protected static double[] getDoubleValueArray(Ptg[] operands) throws CalculationException {
        Double d = null;
        CompatibleVector cv = new CompatibleVector();
        int i = 0;
        while (i < operands.length) {
            Ptg[] pthings = operands[i].getComponents();
            if (pthings != null) {
                int x = 0;
                while (x < pthings.length) {
                    cv.add(pthings[x]);
                    ++x;
                }
            } else {
                cv.add(operands[i]);
            }
            ++i;
        }
        double[] darr = new double[cv.size()];
        int i2 = 0;
        Enumeration en = cv.elements();
        while (en.hasMoreElements()) {
            d = null;
            Ptg pthing = (Ptg)en.nextElement();
            Object ob = pthing.getValue();
            if (ob == null || ob.toString().trim().equals("")) {
                darr[i2] = 0.0;
            } else {
                if (ob.toString().equals("#CIR_ERR!")) {
                    throw new CircularReferenceException(15);
                }
                try {
                    if (ob instanceof Double) {
                        d = (Double)ob;
                    } else {
                        String s = ob.toString();
                        d = new Double(s);
                    }
                }
                catch (NumberFormatException e) {
                    try {
                        String s = ob.toString();
                        if (s.equals("#N/A")) {
                            return null;
                        }
                    }
                    catch (Exception ee) {
                        Logger.logWarn("PtgCalculator getting Double value array failed: " + ee);
                        d = new Double(Double.NaN);
                    }
                }
                if (d != null) {
                    darr[i2] = d;
                }
            }
            ++i2;
        }
        return darr;
    }

    protected static double[] getDoubleValueArray(Ptg operands) throws CalculationException {
        Ptg[] ptgarr = new Ptg[]{operands};
        return PtgCalculator.getDoubleValueArray(ptgarr);
    }

    protected static double[][] getArray(Ptg operand) throws Exception {
        Object arr = null;
        if (operand instanceof PtgRef) {
            int[] rc = ((PtgRef)operand).getIntLocation();
            String sheet = ((PtgRef)operand).getSheetName();
            WorkBook bk = operand.getParentRec().getWorkBook();
            int nrows = rc[2] - rc[0] + 1;
            int ncols = rc[3] - rc[1] + 1;
            arr = new double[nrows][ncols];
            int j = rc[1];
            while (j <= rc[3]) {
                int i = rc[0];
                while (i <= rc[2]) {
                    String cell = ExcelTools.formatLocation(new int[]{i, j});
                    arr[i - rc[0]][j - rc[1]] = bk.getCell(sheet, cell).getDblVal();
                    ++i;
                }
                ++j;
            }
        } else {
            String arrStr = ((PtgArray)operand).toString().substring(1);
            arrStr = arrStr.substring(0, arrStr.length() - 1);
            String[] rows = arrStr.split(";");
            arr = new double[rows.length][];
            int i = 0;
            while (i < rows.length) {
                String[] s = rows[i].split(",", -1);
                arr[i] = new double[s.length];
                int j = 0;
                while (j < s.length) {
                    arr[i][j] = new Double(s[j]);
                    ++j;
                }
                ++i;
            }
        }
        return arr;
    }

    protected static Ptg getError() {
        PtgErr perr = new PtgErr(PtgErr.ERROR_NULL);
        return perr;
    }

    protected static Ptg getValueError() {
        return new PtgErr(PtgErr.ERROR_VALUE);
    }

    protected static Ptg getNAError() {
        return new PtgErr(PtgErr.ERROR_NA);
    }

    protected static Ptg[] getAllComponents(Ptg[] operands) {
        Ptg[] ret;
        if (operands.length == 1 && (ret = operands[0].getComponents()) == null) {
            return operands;
        }
        FastAddVector v = new FastAddVector();
        int i = 0;
        while (i < operands.length) {
            Ptg[] pthings = operands[i].getComponents();
            if (pthings != null) {
                int x = 0;
                while (x < pthings.length) {
                    v.add(pthings[x]);
                    ++x;
                }
            } else {
                v.add(operands[i]);
            }
            ++i;
        }
        Object[] res = new Ptg[v.size()];
        res = (Ptg[])v.toArray(res);
        return res;
    }

    protected static Ptg[] getAllComponents(Ptg operand) {
        Ptg[] ptgArr = new Ptg[]{operand};
        return PtgCalculator.getAllComponents(ptgArr);
    }

    protected static boolean getBooleanValue(Ptg operand) {
        if (operand instanceof PtgBool) {
            PtgBool b = (PtgBool)operand;
            return b.getBooleanValue();
        }
        if (operand instanceof PtgInt) {
            PtgInt i = (PtgInt)operand;
            return i.getBooleanVal();
        }
        return false;
    }
}

