/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.ExpressionParser;
import com.extentech.formats.XLS.FunctionNotSupportedException;
import com.extentech.formats.XLS.formulas.CalculationException;
import com.extentech.formats.XLS.formulas.FormulaCalculator;
import com.extentech.formats.XLS.formulas.FormulaParser;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgCalculator;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.Logger;
import java.util.ArrayList;
import java.util.Stack;

public class PtgMemArea
extends GenericPtg {
    private static final long serialVersionUID = -6869393084367355874L;
    int cce = 0;
    Stack subexpression = null;
    Ptg[] ptgs = null;
    byte[] postExp = null;
    ArrayList refsheets = new ArrayList();

    @Override
    public boolean getIsOperand() {
        return true;
    }

    @Override
    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
        this.populateVals();
    }

    public int getnTokens() {
        return this.cce;
    }

    public void setSubExpression(byte[] b) {
        byte[] retbytes = new byte[7];
        System.arraycopy(this.record, 0, retbytes, 0, this.record.length);
        retbytes = ByteTools.append(b, retbytes);
        this.record = retbytes;
        this.populateVals();
    }

    public void setPostExpression(byte[] b, int expressionLen) {
        int len = b.length - expressionLen;
        this.postExp = new byte[len];
        System.arraycopy(b, expressionLen, this.postExp, 0, len);
    }

    public byte[] getPostRecord() {
        short cce = 0;
        int i = 0;
        while (i < this.subexpression.size()) {
            Ptg p = (Ptg)this.subexpression.get(i);
            if (p instanceof PtgRef) {
                cce = (short)(cce + 1);
            }
            ++i;
        }
        byte[] b = ByteTools.shortToLEBytes(cce);
        byte[] recbytes = new byte[cce * 8 + 2];
        recbytes[0] = b[0];
        recbytes[1] = b[1];
        int pos = 2;
        int i2 = 0;
        while (i2 < this.subexpression.size() && pos + 7 < recbytes.length) {
            Ptg p = (Ptg)this.subexpression.get(i2);
            if (p instanceof PtgRef) {
                int[] rc = ((PtgRef)p).getRowCol();
                System.arraycopy(ByteTools.shortToLEBytes((short)rc[0]), 0, recbytes, pos, 2);
                System.arraycopy(ByteTools.shortToLEBytes((short)rc[1]), 0, recbytes, pos + 4, 2);
                if (rc.length == 2) {
                    System.arraycopy(ByteTools.shortToLEBytes((short)rc[0]), 0, recbytes, pos + 2, 2);
                    System.arraycopy(ByteTools.shortToLEBytes((short)rc[1]), 0, recbytes, pos + 6, 2);
                } else {
                    System.arraycopy(ByteTools.shortToLEBytes((short)rc[2]), 0, recbytes, pos + 2, 2);
                    System.arraycopy(ByteTools.shortToLEBytes((short)rc[3]), 0, recbytes, pos + 6, 2);
                }
                pos += 8;
            }
            ++i2;
        }
        return recbytes;
    }

    void populateVals() {
        this.cce = ByteTools.readShort(this.record[5], this.record[6]);
        if (this.record.length > 7) {
            byte[] subexp = new byte[this.cce];
            System.arraycopy(this.record, 7, subexp, 0, this.cce);
            this.subexpression = ExpressionParser.parseExpression(subexp, this.parent_rec);
            try {
                Object o = FormulaCalculator.calculateFormula(this.subexpression);
                ArrayList<Ptg> components = new ArrayList<Ptg>();
                if (o != null && o instanceof Ptg[]) {
                    this.ptgs = (Ptg[])o;
                    int i = 0;
                    while (i < this.ptgs.length) {
                        if (!this.refsheets.contains(((PtgRef)this.ptgs[i]).getSheetName())) {
                            this.refsheets.add(((PtgRef)this.ptgs[i]).getSheetName());
                        }
                        if (this.ptgs[i] instanceof PtgArea) {
                            Ptg[] p = this.ptgs[i].getComponents();
                            int j = 0;
                            while (j < p.length) {
                                components.add(p[j]);
                                ++j;
                            }
                        } else {
                            components.add(this.ptgs[i]);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.subexpression.size()) {
                        try {
                            PtgRef pr = (PtgRef)this.subexpression.get(i);
                            if (!this.refsheets.contains(pr.getSheetName())) {
                                this.refsheets.add(pr.getSheetName());
                            }
                            if (pr instanceof PtgArea) {
                                Ptg[] pa = pr.getComponents();
                                int j = 0;
                                while (j < pa.length) {
                                    components.add(pa[j]);
                                    ++j;
                                }
                            } else {
                                components.add(pr);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                this.ptgs = new Ptg[components.size()];
                components.toArray(this.ptgs);
            }
            catch (Exception e) {
                Logger.logErr("PtgMemArea init: " + e.toString());
            }
        }
    }

    @Override
    public byte[] getRecord() {
        int len = 0;
        int i = 0;
        while (i < this.subexpression.size()) {
            Ptg p = (Ptg)this.subexpression.get(i);
            len += p.getRecord().length;
            ++i;
        }
        this.cce = len;
        byte[] rec = new byte[len + 7];
        byte[] b = ByteTools.shortToLEBytes((short)this.cce);
        rec[0] = 38;
        rec[5] = b[0];
        rec[6] = b[1];
        int offset = 7;
        int i2 = 0;
        while (i2 < this.subexpression.size()) {
            Ptg p = (Ptg)this.subexpression.get(i2);
            System.arraycopy(p.getRecord(), 0, rec, offset, p.getRecord().length);
            offset += p.getRecord().length;
            ++i2;
        }
        this.record = rec;
        return this.record;
    }

    @Override
    public int getLength() {
        return this.cce + 7;
    }

    @Override
    public Ptg[] getComponents() {
        return this.ptgs;
    }

    public String toString() {
        return FormulaParser.getExpressionString(this.subexpression).substring(1);
    }

    @Override
    public Object getValue() {
        double[] dub;
        try {
            dub = PtgCalculator.getDoubleValueArray(this.ptgs);
        }
        catch (CalculationException e) {
            return null;
        }
        try {
            double result = 0.0;
            int i = 0;
            while (i < dub.length) {
                result += dub[i];
                ++i;
            }
            return new Double(result);
        }
        catch (FunctionNotSupportedException e) {
            Logger.logWarn("Function Unsupported error in PtgMemFunction: " + e);
            return null;
        }
    }
}

