/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.formulas.PtgMemArea;
import com.extentech.toolkit.ByteTools;

public class PtgMemAreaA
extends PtgMemArea {
    private static final long serialVersionUID = 5528547215693511069L;
    int cce = 0;
    int cref = 0;
    MemArea[] areas;

    @Override
    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
        this.populateVals();
    }

    @Override
    void populateVals() {
        this.cce = ByteTools.readInt(this.record[6], (int)this.record[5]);
        this.cref = ByteTools.readInt(this.record[8], (int)this.record[7]);
        this.areas = new MemArea[this.cref];
        int holder = 9;
        int i = 0;
        while (i < this.cref) {
            byte[] arr = new byte[6];
            System.arraycopy(this.record, holder, arr, 0, 6);
            this.areas[i].init(arr);
            holder += 6;
            ++i;
        }
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public Object getValue() {
        String res = "";
        int i = 0;
        while (i < this.areas.length) {
            res = String.valueOf(res) + this.areas[i].getString();
            if (i != this.areas.length - 1) {
                res = String.valueOf(res) + ",";
            }
            ++i;
        }
        String o = res;
        return o;
    }

    private class MemArea {
        int rwFirst;
        int rwLast;
        int colFirst;
        int colLast;

        private MemArea() {
        }

        void init(byte[] b) {
            this.rwFirst = ByteTools.readInt(b[0], (int)b[1]);
            this.rwLast = ByteTools.readInt(b[2], (int)b[3]);
            this.colFirst = b[4];
            this.colLast = b[5];
        }

        String getString() {
            if (this.rwFirst == this.rwLast && this.colFirst == this.colLast) {
                String retstr = ExcelTools.getAlphaVal(this.colLast);
                retstr = String.valueOf(retstr) + (this.rwLast + 1);
                return retstr;
            }
            int[] arr = new int[]{this.rwFirst, this.colFirst, this.rwLast, this.colLast};
            return ExcelTools.formatRangeRowCol(arr);
        }
    }
}

