/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.formats.XLS.formulas.PtgBool;
import com.extentech.formats.XLS.formulas.PtgErr;
import com.extentech.toolkit.Logger;
import java.lang.reflect.Array;

public class PtgNE
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = 6901661166166179786L;

    @Override
    public boolean getIsOperator() {
        return true;
    }

    @Override
    public boolean getIsPrimitiveOperator() {
        return true;
    }

    @Override
    public boolean getIsBinaryOperator() {
        return true;
    }

    public PtgNE() {
        this.ptgId = (byte)14;
        this.record = new byte[1];
        this.record[0] = 14;
    }

    @Override
    public String getString() {
        return "<>";
    }

    @Override
    public int getLength() {
        return 1;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Ptg calculatePtg(Ptg[] form) {
        try {
            Object[] o = GenericPtg.getValuesFromPtgs(form);
            if (!o[0].getClass().isArray()) {
                if (o == null || o.length != 2) {
                    Logger.logWarn("calculating formula failed, wrong number of values in PtgNE");
                    return null;
                }
                boolean isDouble = false;
                int i = 0;
                while (i < 2 && !isDouble) {
                    isDouble = o[i] instanceof Double;
                    ++i;
                }
                i = 0;
                while (i < 2) {
                    if (o[i] != null && o[i].toString().equals("")) {
                        o[i] = isDouble ? new Double(0.0) : "";
                    }
                    ++i;
                }
                boolean res = o[0] instanceof Double && o[1] instanceof Double ? Math.abs((Double)o[0] - (Double)o[1]) > this.doublePrecision : !o[0].toString().equalsIgnoreCase(o[1].toString());
                PtgBool pboo = new PtgBool(res);
                return pboo;
            }
            String retArry = "";
            int nArrays = Array.getLength(o);
            if (nArrays != 2) {
                return new PtgErr(PtgErr.ERROR_VALUE);
            }
            int nVals = Array.getLength(o[0]);
            int i = 0;
            while (i < nArrays - 1) {
                boolean res = false;
                Object secondOp = null;
                boolean comparitorIsArray = o[i + 1].getClass().isArray();
                if (!comparitorIsArray) {
                    secondOp = o[i + 1];
                }
                int j = 0;
                while (j < nVals) {
                    Object firstOp = Array.get(o[i], j);
                    if (comparitorIsArray) {
                        secondOp = Array.get(o[i + 1], j);
                    }
                    res = firstOp instanceof Double && secondOp instanceof Double ? Math.abs((Double)firstOp - (Double)secondOp) > this.doublePrecision : firstOp.toString().equalsIgnoreCase(secondOp.toString());
                    retArry = String.valueOf(retArry) + res + ",";
                    ++j;
                }
                i += 2;
            }
            retArry = "{" + retArry.substring(0, retArry.length() - 1) + "}";
            PtgArray pa = new PtgArray();
            pa.setVal(retArry);
            return pa;
        }
        catch (Exception e) {
            PtgErr perr = new PtgErr(PtgErr.ERROR_VALUE);
            return perr;
        }
    }
}

