/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.Array;
import com.extentech.formats.XLS.Formula;
import com.extentech.formats.XLS.FormulaNotFoundException;
import com.extentech.formats.XLS.Name;
import com.extentech.formats.XLS.WorkBook;
import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.IlblListener;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgArray;
import com.extentech.toolkit.ByteTools;
import com.extentech.toolkit.FastAddVector;
import com.extentech.toolkit.Logger;

public class PtgName
extends GenericPtg
implements Ptg,
IlblListener {
    private static final long serialVersionUID = 8047146848365098162L;
    short ilbl;
    String name;

    @Override
    public boolean getIsOperand() {
        return true;
    }

    public Name getName() {
        WorkBook b = this.getParentRec().getWorkBook();
        Name n = null;
        try {
            n = b.getName(this.ilbl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    @Override
    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
        this.populateVals();
        this.addToRefTracker();
    }

    public PtgName() {
        this.ptgId = (byte)35;
    }

    public void setPtgType(short type) {
        switch (type) {
            case 0: {
                this.ptgId = (byte)67;
                break;
            }
            case 1: {
                this.ptgId = (byte)35;
                break;
            }
            case 2: {
                this.ptgId = (byte)99;
            }
        }
        this.record[0] = this.ptgId;
    }

    public PtgName(int id) {
        this.ptgId = (byte)id;
    }

    public void addToRefTracker() {
        try {
            if (this.parent_rec != null) {
                this.parent_rec.getWorkBook().getRefTracker().addPtgNameReference(this);
            }
        }
        catch (Exception ex) {
            Logger.logErr("PtgRef.addToRefTracker() failed.", ex);
        }
    }

    public void setName(String name) {
        this.record = new byte[5];
        this.record[0] = this.ptgId;
        WorkBook b = this.getParentRec().getWorkBook();
        this.ilbl = (short)b.getNameNumber(name);
        this.addListener();
        this.record[1] = (byte)this.ilbl;
    }

    private void populateVals() {
        this.ilbl = ByteTools.readShort(this.record[1], this.record[2]);
    }

    public int getVal() {
        return this.ilbl;
    }

    @Override
    public short getIlbl() {
        return this.ilbl;
    }

    @Override
    public void storeName(String nm) {
        this.name = nm;
    }

    @Override
    public void setIlbl(short i) {
        if (this.ilbl != i) {
            this.ilbl = i;
            this.updateRecord();
        }
    }

    @Override
    public Object getValue() {
        Name n = this.getName();
        try {
            Ptg[] p = n.getCellRangePtgs();
            if (p.length == 0) {
                return new String("#NAME?");
            }
            if (p.length == 1 || !(this.parent_rec instanceof Array)) {
                return p[0].getValue();
            }
            String retarry = "";
            int i = 0;
            while (i < p.length) {
                retarry = String.valueOf(retarry) + p[i].getValue() + ",";
                ++i;
            }
            retarry = "{" + retarry.substring(0, retarry.length() - 1) + "}";
            PtgArray pa = new PtgArray();
            pa.setVal(retarry);
            return pa;
        }
        catch (Exception exception) {
            return new String("#NAME?");
        }
    }

    @Override
    public String getTextString() {
        Name n = this.getName();
        if (n == null) {
            return "#NAME!";
        }
        return n.getName();
    }

    @Override
    public String getStoredName() {
        return this.name;
    }

    public void setVal(int i) {
        this.ilbl = (short)i;
        this.updateRecord();
    }

    @Override
    public void updateRecord() {
        byte[] brow = ByteTools.cLongToLEBytes(this.ilbl);
        this.record[1] = brow[0];
        this.record[2] = brow[1];
        if (this.parent_rec != null && this.parent_rec instanceof Formula) {
            ((Formula)this.parent_rec).updateRecord();
        }
    }

    @Override
    public int getLength() {
        if (this.record != null) {
            return this.record.length;
        }
        return 5;
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName().getName();
        }
        return "[Null]";
    }

    @Override
    public Ptg[] getComponents() {
        FastAddVector v = new FastAddVector();
        Ptg p = this.getName().getPtga();
        Ptg[] pcomps = p.getComponents();
        if (pcomps != null) {
            int x = 0;
            while (x < pcomps.length) {
                v.add(pcomps[x]);
                ++x;
            }
        } else {
            v.add(p);
        }
        Object[] retPtgs = new Ptg[v.size()];
        retPtgs = (Ptg[])v.toArray(retPtgs);
        return retPtgs;
    }

    @Override
    public String getLocation() throws FormulaNotFoundException {
        if (this.getName() != null) {
            try {
                return this.getName().getLocation();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void addListener() {
        Name n = this.getName();
        if (n != null) {
            n.addIlblListener(this);
            this.storeName(n.getName());
        }
    }
}

