/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.formats.XLS.formulas.GenericPtg;
import com.extentech.formats.XLS.formulas.Ptg;
import com.extentech.formats.XLS.formulas.PtgNumber;
import com.extentech.toolkit.Logger;

public class PtgPercent
extends GenericPtg
implements Ptg {
    private static final long serialVersionUID = -8559541841405018157L;

    @Override
    public boolean getIsOperator() {
        return true;
    }

    @Override
    public boolean getIsPrimitiveOperator() {
        return true;
    }

    @Override
    public boolean getIsUnaryOperator() {
        return true;
    }

    @Override
    public String getString() {
        return "%";
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public Ptg calculatePtg(Ptg[] form) {
        Object[] o = GenericPtg.getValuesFromPtgs(form);
        if (!(o[0].getClass().isArray() || o != null && o.length == 1)) {
            Logger.logWarn("calculating formula failed, wrong number of values in PtgPercent");
            return null;
        }
        double res = (Double)o[0] / 100.0;
        return new PtgNumber(res);
    }
}

