/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS.formulas;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.Shrfmla;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.Logger;

public class PtgRefN
extends PtgRef {
    private static final long serialVersionUID = 2652944516984815274L;
    private int realRow;
    private int realCol;
    short column;
    private PtgArea parea = null;

    @Override
    public boolean getIsReference() {
        return true;
    }

    @Override
    public void init(byte[] b) {
        this.ptgId = b[0];
        this.record = b;
        this.populateVals();
        this.hashcode = this.getHashCode();
    }

    public PtgRefN(boolean useReference) {
        this.setUseReferenceTracker(useReference);
    }

    @Override
    public String getLocation() {
        this.realRow = this.rw;
        this.realCol = this.col;
        if (this.fRwRel) {
            this.realRow += (short)this.formulaRow;
        }
        if (this.fColRel) {
            this.realCol = (short)this.formulaCol;
            if (this.realCol >= 16384) {
                this.realCol -= 16384;
            }
        }
        String s = ExcelTools.getAlphaVal(this.realCol);
        String y = String.valueOf(this.realRow + 1);
        return String.valueOf(this.fColRel ? "" : "$") + s + (this.fRwRel ? "" : "$") + y;
    }

    @Override
    public void setLocation(int[] rowcol) {
        if (this.useReferenceTracker) {
            this.removeFromRefTracker();
        }
        if (this.record != null) {
            if (this.fRwRel) {
                this.formulaRow = rowcol[0];
            } else {
                this.rw = rowcol[0];
            }
            if (this.fColRel) {
                this.formulaCol = rowcol[1];
            } else {
                this.col = rowcol[1];
            }
            this.updateRecord();
            this.init(this.record);
        } else {
            Logger.logWarn("PtgRefN.setLocation() failed: NO record data: " + rowcol.toString());
        }
        this.hashcode = this.getHashCode();
        if (this.useReferenceTracker) {
            this.addToRefTracker();
        }
    }

    @Override
    public int[] getRowCol() {
        this.realRow = this.rw;
        this.realCol = this.col;
        if (this.fRwRel) {
            this.realRow += (short)this.formulaRow;
        }
        if (this.fColRel) {
            this.realCol = (short)this.formulaCol;
            if (this.realCol >= 16384) {
                this.realCol -= 16384;
            }
        }
        int[] ret = new int[]{this.realRow, this.realCol};
        return ret;
    }

    public int[] getRealRowCol() {
        return new int[]{this.rw, this.col};
    }

    @Override
    public void setLocation(String address) {
        if (this.record != null) {
            String[] s = ExcelTools.stripSheetNameFromRange(address);
            address = s[1];
            int[] res = ExcelTools.getRowColFromString(address);
            if (this.fRwRel) {
                this.rw += this.formulaRow - res[0];
                if (this.rw < 0) {
                    this.rw = 0;
                }
                this.formulaRow = res[0];
            } else {
                this.rw = res[0];
            }
            if (this.fColRel) {
                this.col += this.formulaCol - res[1];
                this.formulaCol = res[1];
            } else {
                this.col = res[1];
            }
            this.updateRecord();
            this.init(this.record);
            if (s[3] != null) {
                this.externalLink1 = Integer.valueOf(s[3].substring(1, s[3].length() - 1));
            }
            if (s[4] != null) {
                this.externalLink2 = Integer.valueOf(s[4].substring(1, s[4].length() - 1));
            }
        } else {
            Logger.logWarn("PtgRefN.setLocation() failed: NO record data: " + address.toString());
        }
    }

    public PtgRef convertToPtgRef(XLSRecord r2) {
        int[] i = new int[]{this.fRwRel ? r2.getRowNumber() + this.rw : this.rw, this.fColRel ? r2.getColNumber() + this.col : this.col};
        if (i[1] >= 256 && !r2.getWorkBook().getIsExcel2007()) {
            i[1] = i[1] - 256;
        }
        PtgRef prf = new PtgRef(i, r2, false);
        return prf;
    }

    @Override
    public int[] getIntLocation() {
        int rowNew = this.rw;
        int colNew = this.col;
        if (this.fRwRel) {
            rowNew += this.formulaRow;
        }
        if (this.fColRel) {
            colNew += this.formulaCol;
        }
        if (colNew >= 16384) {
            colNew -= 16384;
        }
        int[] returning = new int[]{rowNew, colNew};
        return returning;
    }

    public void setFormulaRow(int r2) {
        this.formulaRow = r2;
    }

    public void setFormulaCol(int c) {
        this.formulaCol = c;
    }

    public PtgArea getArea() {
        Shrfmla sh = (Shrfmla)this.getParentRec();
        int[] i = new int[]{this.fRwRel ? sh.getFirstRow() + this.rw : this.rw, this.fColRel ? sh.getFirstCol() + this.col : this.col, this.fRwRel ? sh.getLastRow() + this.rw : this.rw, this.fColRel ? sh.getLastCol() + this.col : this.col};
        if (i[1] >= 256 && !this.parent_rec.getWorkBook().getIsExcel2007()) {
            i[1] = i[1] - 256;
        }
        if (i[3] >= 256 && !this.parent_rec.getWorkBook().getIsExcel2007()) {
            i[3] = i[3] - 256;
        }
        PtgArea parea = new PtgArea(i, (XLSRecord)sh, true);
        return parea;
    }

    @Override
    public void addToRefTracker() {
        short iParent = this.getParentRec().getOpcode();
        if (iParent == 1212) {
            PtgArea parea = this.getArea();
            parea.addToRefTracker();
        }
    }

    @Override
    public void removeFromRefTracker() {
        PtgArea parea;
        short iParent = this.getParentRec().getOpcode();
        if (iParent == 1212 && (parea = this.getArea()) != null) {
            parea.removeFromRefTracker();
        }
    }

    @Override
    public void close() {
        if (this.parea != null) {
            this.parea.close();
        }
        this.parea = null;
    }
}

