/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.XLS;

import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.formats.XLS.XLSRecord;
import com.extentech.formats.XLS.formulas.PtgArea;
import com.extentech.formats.XLS.formulas.PtgRef;
import com.extentech.toolkit.ByteTools;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

class refPtgs
extends TreeMap
implements Serializable {
    private static final long serialVersionUID = -7923448634000437926L;
    static final long SECONDPTGFACTOR = 0x400004000L;

    public refPtgs(Comparator c) {
        super(c);
    }

    private Object getKey(Object o) throws IllegalArgumentException {
        long loc = ((PtgRef)o).hashcode;
        if (loc == -1L) {
            throw new IllegalArgumentException();
        }
        long ploc = ((PtgRef)o).getParentRec().hashCode();
        return new long[]{loc, ploc};
    }

    private Object getKey(long loc, long ploc) {
        return new long[]{loc, ploc};
    }

    public boolean add(Object o) {
        try {
            super.put(this.getKey(o), o);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return true;
    }

    public boolean add(byte[] b, XLSRecord parentRec) {
        short row = ByteTools.readShort(b[0], b[1]);
        short col = ByteTools.readShort(b[4], b[5]);
        int row2 = ByteTools.readShort(b[2], b[3]);
        if (row2 < 0) {
            row2 += 65536;
        }
        short col2 = ByteTools.readShort(b[6], b[7]);
        int[] rc = new int[]{row, col, row2, col2};
        boolean[] bool = new boolean[]{true, true, true, true};
        String location = ExcelTools.formatRangeRowCol(rc, bool);
        PtgArea pa = new PtgArea(location, parentRec);
        pa.addToRefTracker();
        return this.add(pa);
    }

    public boolean add(String range, XLSRecord parentRec) {
        if (range != null && !range.equals("")) {
            PtgArea pa = new PtgArea(range, parentRec);
            pa.addToRefTracker();
            return this.add(pa);
        }
        return false;
    }

    public boolean contains(Object o) {
        return super.containsKey(this.getKey(o));
    }

    public boolean containsReference(int[] rc) {
        Object key2;
        long testkey;
        Iterator ii;
        long loc = PtgRef.getHashCode(rc[0], rc[1]);
        SortedMap m = this.subMap(this.getKey(loc, 0L), this.getKey(loc + 1L, 0L));
        if (m != null && m.size() > 0 && (ii = m.keySet().iterator()).hasNext() && (testkey = ((long[])(key2 = ii.next()))[0]) == loc) {
            return true;
        }
        m = this.tailMap(this.getKey(0x400004000L, 0L));
        if (m != null) {
            for (Object key2 : m.keySet()) {
                testkey = ((long[])key2)[0];
                double firstkey = testkey / 0x400004000L;
                double secondkey = testkey % 0x400004000L;
                if ((long)firstkey <= loc && (long)secondkey >= loc) {
                    int rw0 = (int)(firstkey / 16384.0) - 1;
                    int col0 = (int)firstkey % 16384;
                    int rw1 = (int)(secondkey / 16384.0) - 1;
                    int col1 = (int)secondkey % 16384;
                    if (!this.isaffected(rc, new int[]{rw0, col0, rw1, col1})) continue;
                    return true;
                }
                if (firstkey > (double)loc) break;
            }
        }
        return false;
    }

    private boolean isaffected(int[] cellrc, int[] arearc) {
        if (cellrc[0] < arearc[0]) {
            return false;
        }
        if (cellrc[0] > arearc[2]) {
            return false;
        }
        if (cellrc[1] < arearc[1]) {
            return false;
        }
        return cellrc[1] <= arearc[3];
    }

    @Override
    public Object remove(Object o) {
        return super.remove(this.getKey(o));
    }

    public Object[] toArray() {
        return this.values().toArray();
    }
}

