/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.cellformat;

import com.extentech.formats.cellformat.CellFormat;
import com.extentech.formats.cellformat.DateCellFormat;
import com.extentech.formats.cellformat.GeneralCellFormat;
import com.extentech.formats.cellformat.NumberCellFormat;
import com.extentech.toolkit.StringTool;

public class CellFormatFactory {
    private CellFormatFactory() {
        throw new UnsupportedOperationException();
    }

    public static CellFormat fromPatternString(String pattern) {
        if (pattern == null || "".equals(pattern) || "General".equalsIgnoreCase(pattern)) {
            return new GeneralCellFormat();
        }
        String[] pats = pattern.split(";");
        String tester = StringTool.convertPatternExtractBracketedExpression(pats[0]);
        if (tester.matches(".*(((y{1,4}|m{1,5}|d{1,4}|h{1,2}|s{1,2}).*)+).*")) {
            String string = pats.length > 3 ? StringTool.convertPatternFromExcelToStringFormatter(pats[3], false) : "%s";
            return new DateCellFormat(StringTool.convertDatePatternFromExcelToStringFormatter(tester), string);
        }
        String positive = StringTool.convertPatternFromExcelToStringFormatter(pats[0], false);
        String negative = StringTool.convertPatternFromExcelToStringFormatter(pats[pats.length > 1 ? 1 : 0], true);
        String zero = pats.length > 2 ? StringTool.convertPatternFromExcelToStringFormatter(pats[2], false) : positive;
        String string = pats.length > 3 ? StringTool.convertPatternFromExcelToStringFormatter(pats[3], false) : "%s";
        return new NumberCellFormat(positive, negative, zero, string);
    }
}

