/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.formats.escher;

import com.extentech.formats.escher.EscherRecord;
import com.extentech.toolkit.ByteTools;

public class MsofbtSpgr
extends EscherRecord {
    private static final long serialVersionUID = 5591214948365806058L;
    int left = 0;
    int top = 0;
    int right = 0;
    int bottom = 0;

    public MsofbtSpgr(int fbt, int inst, int version) {
        super(fbt, inst, version);
    }

    @Override
    protected byte[] getData() {
        byte[] leftBytes = ByteTools.cLongToLEBytes(this.left);
        byte[] topBytes = ByteTools.cLongToLEBytes(this.top);
        byte[] rightBytes = ByteTools.cLongToLEBytes(this.right);
        byte[] bottomBytes = ByteTools.cLongToLEBytes(this.bottom);
        byte[] retBytes = new byte[16];
        System.arraycopy(leftBytes, 0, retBytes, 0, 4);
        System.arraycopy(topBytes, 0, retBytes, 4, 4);
        System.arraycopy(rightBytes, 0, retBytes, 8, 4);
        System.arraycopy(bottomBytes, 0, retBytes, 12, 4);
        this.setLength(retBytes.length);
        return retBytes;
    }

    public void setRect(int left, int top, int right, int bottom) {
        this.left = left;
        this.right = right;
        this.bottom = bottom;
        this.top = top;
    }
}

