/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.naming;

import com.extentech.naming.NameImpl;
import com.extentech.naming.NameParserImpl;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class InitialContextImpl
implements Context {
    NameParser nameParser = new NameParserImpl();
    protected Hashtable env;
    public static String CONTEXT_ID = "com.extentech.naming.InitialContextImpl_instance";
    public static String LOAD_CONTEXT = "com.extentech.naming.load_context";
    private boolean closed = false;

    public InitialContextImpl() {
        if (System.getProperties().get(CONTEXT_ID) != null) {
            this.env = (Hashtable)System.getProperties().get(CONTEXT_ID);
        } else {
            String loadme = System.getProperty(LOAD_CONTEXT);
            this.env = new Hashtable();
            if (loadme != null && loadme.equals("true")) {
                System.getProperties().put(CONTEXT_ID, this.env);
            }
        }
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.env.contains(propVal)) {
            throw new NamingException("Object " + propName + " already exists in NamingContext.");
        }
        this.env.put(propName, propVal);
        return propVal;
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        String str = name.toString();
        this.bind(str, obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        try {
            this.addToEnvironment(name, obj);
        }
        catch (NamingException e) {
            this.env.remove(obj);
            this.env.put(name, obj);
        }
    }

    @Override
    public void close() throws NamingException {
        this.closed = true;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        NameImpl retval = new NameImpl();
        retval.addAll(prefix);
        retval.addAll(name);
        return retval;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append(prefix);
        return sb.toString();
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        this.nameParser.parse(name);
        return this.nameParser;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.nameParser;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.env.get(name);
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.env.get(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.env.get(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.env.get(name);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.bind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.bind(name, obj);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        Object ob = this.env.get(oldName);
        this.env.remove(oldName);
        this.env.put(newName, ob);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        Object ob = this.env.get(oldName);
        this.env.remove(oldName);
        this.env.put(newName, ob);
    }

    @Override
    public void unbind(String name) throws NamingException {
        try {
            this.env.remove(this.env.get(name));
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        try {
            this.env.remove(this.env.get(name));
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        return null;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return null;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return null;
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return null;
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return null;
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return null;
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return null;
    }
}

