/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import com.extentech.toolkit.Logger;
import java.lang.reflect.Method;
import java.math.BigDecimal;

public class CompatibleBigDecimal
extends BigDecimal {
    private static final long serialVersionUID = -6816994951413033200L;
    private static Method _methodToString = null;

    static {
        try {
            _methodToString = BigDecimal.class.getMethod("toPlainString", null);
        }
        catch (NoSuchMethodException e) {
            try {
                _methodToString = BigDecimal.class.getMethod("toString", null);
            }
            catch (NoSuchMethodException ex) {
                Logger.logWarn("Error creating toString method in CompatibleBigDecimal");
            }
        }
    }

    public CompatibleBigDecimal(BigDecimal bd) {
        super(bd.unscaledValue(), bd.scale());
    }

    public CompatibleBigDecimal(String num) {
        super(num);
    }

    public String toCompatibleString() {
        if (_methodToString != null) {
            try {
                return (String)_methodToString.invoke((Object)this, null);
            }
            catch (Exception e) {
                Logger.logWarn("Error in calling CompatibleBigDecimal.toString");
            }
        }
        return null;
    }
}

