/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import com.extentech.toolkit.Logger;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class InFile
extends DataInputStream {
    StringBuffer sb = new StringBuffer();

    public InFile(String filename) throws FileNotFoundException {
        super(new BufferedInputStream(new FileInputStream(new File(filename))));
    }

    public InFile(File file) throws FileNotFoundException {
        this(file.getPath());
    }

    public String readFile() {
        try {
            while (this.available() != 0) {
                this.sb.append(this.readLine());
            }
        }
        catch (FileNotFoundException e) {
            Logger.logInfo("FNF Exception in InFile: " + e);
        }
        catch (IOException e) {
            Logger.logInfo("IO Exception in InFile: " + e);
        }
        return this.sb.toString();
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        long length = file.length();
        byte[] ret = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < ret.length && (numRead = ((InputStream)fis).read(ret, offset, ret.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < ret.length) {
            throw new IOException("Read file failed -- all bytes not retreived. " + file.getName());
        }
        ((InputStream)fis).close();
        return ret;
    }
}

