/*
 * Decompiled with CFR 0.152.
 */
package com.extentech.toolkit;

import com.extentech.ExtenXLS.ExcelTools;
import java.text.NumberFormat;
import java.util.Hashtable;

public class XSLConverterTool {
    private Hashtable styles = new Hashtable();
    private String lastCell = "A1";

    public String getDateFormatPattern(String ifmt) {
        if (ifmt.equals("14")) {
            return "m/d/yy";
        }
        if (ifmt.equals("15")) {
            return "d-mmm-yy";
        }
        if (ifmt.equals("16")) {
            return "d-mmm";
        }
        if (ifmt.equals("17")) {
            return "mmm-yy";
        }
        if (ifmt.equals("22")) {
            return "m/d/yy h:mm";
        }
        return "m/d/yy";
    }

    public String getJsCalendarFormatPattern(String ifmt) {
        if (ifmt.equals("14")) {
            return "%m/%d/%Y";
        }
        if (ifmt.equals("15")) {
            return "%d-%b-%y";
        }
        if (ifmt.equals("16")) {
            return "%d-%b";
        }
        if (ifmt.equals("17")) {
            return "%m-%y";
        }
        if (ifmt.equals("22")) {
            return "%m/%d/%Y %h:%M";
        }
        return "%m/%d/%Y";
    }

    public String getCurrencyFormat(String fmt, String value) {
        try {
            NumberFormat nf = NumberFormat.getCurrencyInstance();
            Double d = new Double(value);
            String retStr = nf.format(d);
            return retStr;
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    private Style getStyle(String styleId) {
        Object o = this.styles.get(styleId);
        if (o != null) {
            return (Style)o;
        }
        Style thisStyle = new Style(styleId);
        this.styles.put(styleId, thisStyle);
        return thisStyle;
    }

    public String getPreviousCellData(String sheet, String currCell, String colspan) {
        StringBuffer returnString = new StringBuffer();
        int colSpan = 1;
        if (colspan != null && colspan != "") {
            colSpan = Integer.parseInt(colspan);
        }
        int[] newCell = ExcelTools.getRowColFromString(currCell);
        int[] oldCell = ExcelTools.getRowColFromString(this.lastCell);
        int newCol = newCell[1];
        int oldCol = oldCell[1] + 1;
        while (oldCol < newCol) {
            String newAddress = String.valueOf(ExcelTools.getAlphaVal(oldCol)) + (oldCell[0] + 1);
            returnString.append(this.getEmptyCellHTML(sheet, newAddress));
            ++oldCol;
        }
        newCell[1] = newCol + colSpan - 1;
        this.lastCell = currCell = ExcelTools.formatLocation(newCell);
        return returnString.toString();
    }

    private String getEmptyCellHTML(String sheet, String address) {
        return "<td id=\"" + address + "\" > </td>";
    }

    public void setStyleColor(String styleId, String color) {
        Style thisStyle = this.getStyle(styleId);
        thisStyle.setColor(color);
    }

    public String getStyleColor(String styleId) {
        Style thisStyle = this.getStyle(styleId);
        return thisStyle.getColor();
    }

    public void setIsDate(String styleId, String isDate) {
        Style thisStyle = this.getStyle(styleId);
        thisStyle.setIsDate(isDate);
    }

    public String getIsDate(String styleId) {
        Style thisStyle = this.getStyle(styleId);
        String s = thisStyle.getIsDate();
        if (s == null) {
            return "0";
        }
        return s;
    }

    public void setIsCurrency(String styleId, String isCurrency) {
        if (isCurrency.equals("")) {
            isCurrency = "0";
        }
        Style thisStyle = this.getStyle(styleId);
        thisStyle.setIsCurrency(isCurrency);
    }

    public String getIsCurrency(String styleId) {
        Style thisStyle = this.getStyle(styleId);
        String s = thisStyle.getIsCurrency();
        if (s == null) {
            return "0";
        }
        return s;
    }

    public void setFormatId(String styleId, String formatId) {
        Style thisStyle = this.getStyle(styleId);
        thisStyle.setFormatId(formatId);
    }

    public String getFormatId(String styleId) {
        Style thisStyle = this.getStyle(styleId);
        String s = thisStyle.getFormatId();
        if (s == null) {
            return "0";
        }
        return s;
    }

    public String getFormatPattern(String styleId) {
        Style thisStyle = this.getStyle(styleId);
        return thisStyle.getFormatPattern();
    }

    public void setFormatPattern(String styleId, String pattern) {
        Style thisStyle = this.getStyle(styleId);
        thisStyle.setFormatPattern(pattern);
    }

    private class Style {
        private String ID;
        private String formatId;
        private String color = "";
        private String test;
        private String fontFamily;
        private String fontSize;
        private String fontWeight;
        private String fontColor;
        private String textAlign;
        private String isDate;
        private String isCurrency;
        private String formatPattern;

        public String getFormatPattern() {
            return this.formatPattern;
        }

        public void setFormatPattern(String pattern) {
            this.formatPattern = pattern;
        }

        protected Style(String id) {
            this.ID = id;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public String getFontColor() {
            return this.fontColor;
        }

        public void setFontColor(String fontColor) {
            this.fontColor = fontColor;
        }

        public String getFontFamily() {
            return this.fontFamily;
        }

        public void setFontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
        }

        public String getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(String fontSize) {
            this.fontSize = fontSize;
        }

        public String getFontWeight() {
            return this.fontWeight;
        }

        public void setFontWeight(String fontWeight) {
            this.fontWeight = fontWeight;
        }

        public String getID() {
            return this.ID;
        }

        public void setID(String id) {
            this.ID = id;
        }

        public String getFormatId() {
            return this.formatId;
        }

        public void setFormatId(String formatId) {
            this.formatId = formatId;
        }

        public String getTextAlign() {
            return this.textAlign;
        }

        public void setTextAlign(String textAlign) {
            this.textAlign = textAlign;
        }

        public String getIsCurrency() {
            return this.isCurrency;
        }

        public void setIsCurrency(String isCurrency) {
            this.isCurrency = isCurrency;
        }

        public String getIsDate() {
            return this.isDate;
        }

        public void setIsDate(String isDate) {
            this.isDate = isDate;
        }
    }
}

