/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.extentech.ExtenXLS.CellHandle;
import com.extentech.ExtenXLS.ExcelTools;
import com.extentech.ExtenXLS.WorkBookHandle;
import com.extentech.ExtenXLS.WorkSheetHandle;
import com.extentech.formats.XLS.WorkSheetNotFoundException;
import com.extentech.toolkit.Logger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSheet {
    private final boolean COPYSHEET = false;
    int numadds = 2500;
    int numcols = 5;
    WorkBookHandle book = null;
    WorkSheetHandle sheet = null;
    String outputdir = String.valueOf(System.getProperty("user.dir")) + "/test/scratch/";
    String workingdir = "";

    public void testWrite(WorkBookHandle b, String nm) {
        try {
            File f = new File(nm);
            StringBuffer lockdown = new StringBuffer();
            try {
                if (!f.exists()) {
                    f.mkdirs();
                    f.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            FileOutputStream fos = new FileOutputStream(nm);
            if (b.getIsExcel2007() && !nm.toLowerCase().endsWith(".xls")) {
                b.write(fos);
                lockdown = new StringBuffer("Excel 2007 Input File: " + b.toString() + ". Not using lockdown.");
            } else {
                BufferedOutputStream bbout = new BufferedOutputStream(fos);
                lockdown = b.writeBytes(bbout);
                bbout.flush();
                bbout.close();
                fos.flush();
                fos.close();
            }
            System.gc();
        }
        catch (IOException e) {
            Assert.fail((String)("IOException in Tester.  " + e));
        }
    }

    @Test
    public void testAddOverWritingCell() {
        this.book = new WorkBookHandle();
        try {
            this.sheet = this.book.getWorkSheet("Sheet1");
            this.sheet.add(new Integer(123), "AK25");
            this.sheet.add(new Integer(234), "K25");
            this.sheet.add(new Integer(555), "L25");
            this.sheet.add(new Integer(333), "M25");
            CellHandle fmx = this.sheet.add("=IF(AK25>1,\"Duplicate Row\",SUM(K25:Z25))", "A1");
            fmx.clearContents();
            this.sheet.add((Object)"", 0, 0);
            fmx = this.sheet.add("=IF(AK25>1,\"Duplicate Row\",SUM(K25:Z25))", "A1");
            this.sheet.add((Object)"hello world", 0, 0);
            fmx = this.sheet.add("=IF(AK25>1,\"Duplicate Row\",SUM(K25:Z25))", "A1");
            this.sheet.add(new Integer(222), "A1");
            this.testWrite(this.book, String.valueOf(this.outputdir) + "testAddOverWritingCell.xls");
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testAddNumberWithFormatting() throws Exception {
        this.book = new WorkBookHandle();
        this.sheet = this.book.getWorkSheet("Sheet1");
        CellHandle a2 = this.sheet.add((Object)"\u20ac22", "A2", true);
        Assert.assertEquals((Object)"22", (Object)a2.getVal().toString());
        Assert.assertEquals((Object)"\u20ac22", (Object)a2.getFormattedStringVal());
        CellHandle a1 = this.sheet.add((Object)"22%", "A1", true);
        Assert.assertEquals((Object)"0.22", (Object)a1.getVal().toString());
        Assert.assertEquals((Object)"22%", (Object)a1.getFormattedStringVal());
        CellHandle a4 = this.sheet.add((Object)22, "A4", true);
        Assert.assertEquals((Object)"22", (Object)a4.getFormattedStringVal());
    }

    @Test
    public void testAddDataTypes() {
        this.book = new WorkBookHandle();
        try {
            this.sheet = this.book.getWorkSheet("Sheet1");
            CellHandle cellHandle = this.sheet.add((Object)new Boolean(true), 2, 2);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed adding boolean." + ex));
        }
        this.testWrite(this.book, String.valueOf(this.outputdir) + "testAddDataTypes_out.xls");
    }

    @Test
    public void testAddDupeStrings() {
        String bk = null;
        String sht = "Sheet1";
        this.book = bk != null ? new WorkBookHandle(String.valueOf(this.workingdir) + bk) : new WorkBookHandle();
        try {
            WorkSheetHandle sht1 = this.book.getWorkSheet(sht);
            Assert.assertEquals((Object)"test1", (Object)sht1.add((Object)"test1", 0, 0).getStringVal());
        }
        catch (Exception e) {
            Assert.fail((String)("ERROR: testRowCols.doit() failed: " + e));
        }
        WorkSheetHandle sheet = this.book.createWorkSheet("testDupes");
        Assert.assertEquals((Object)"Month", (Object)sheet.add((Object)"Month", 0, 0).getStringVal());
        Assert.assertEquals((Object)"test2", (Object)sheet.add((Object)"test2", 0, 1).getStringVal());
        Assert.assertEquals((Object)"test3", (Object)sheet.add((Object)"test3", 0, 2).getStringVal());
        this.testWrite(this.book, String.valueOf(this.outputdir) + "testAddDupeStringsOut.xls");
    }

    @Test
    public void testAddCellsNoTemplate() {
        CellHandle c;
        int i;
        boolean localDebugOutput = false;
        long lt = System.currentTimeMillis();
        long lm = Runtime.getRuntime().freeMemory();
        WorkBookHandle book = new WorkBookHandle();
        book.setDupeStringMode(0);
        book.setStringEncodingMode(2);
        try {
            this.sheet = book.getWorkSheet("Sheet1");
            this.sheet.setFastCellAdds(false);
        }
        catch (WorkSheetNotFoundException e) {
            Logger.logErr(e);
        }
        long ltimr = 0L;
        ExcelTools.benchmark("==> BEGIN BiffRec Adds", this);
        String addr = "";
        String coladdr = "";
        String teststr = "Extentech Inc. 1032 Irving Street #910 \n";
        teststr = String.valueOf(teststr) + "San Francisco, CA  94122 \n";
        teststr = String.valueOf(teststr) + "(415) 759-5292 \n";
        if (localDebugOutput) {
            ExcelTools.benchmark("Beginning " + this.numadds * this.numcols + " String cell adds.", this);
        }
        int x = 1;
        while (x < this.numcols + 1) {
            coladdr = ExcelTools.getAlphaVal(x);
            if (localDebugOutput) {
                ExcelTools.benchmark("Beginning " + this.numadds + " String cell adds.  " + coladdr, this);
            }
            ltimr = System.currentTimeMillis();
            i = 0;
            while (i < this.numadds) {
                addr = String.valueOf(coladdr) + String.valueOf(i);
                if (i % 1000 == 0 || i == 0) {
                    if (localDebugOutput) {
                        Logger.logInfo("Adding 1000 String Cells took: " + (System.currentTimeMillis() - ltimr));
                    }
                    ltimr = System.currentTimeMillis();
                }
                c = this.sheet.add((Object)(String.valueOf(teststr) + addr), i, x);
                Assert.assertEquals((Object)c.getStringVal(), (Object)(String.valueOf(teststr) + addr));
                ++i;
            }
            ++x;
        }
        x = 101;
        while (x < this.numcols + 101) {
            coladdr = ExcelTools.getAlphaVal(x);
            if (localDebugOutput) {
                ExcelTools.benchmark("Beginning " + this.numadds + " String cell adds.  " + coladdr, this);
            }
            ltimr = System.currentTimeMillis();
            i = 0;
            while (i < this.numadds) {
                addr = String.valueOf(coladdr) + String.valueOf(i);
                if (i % 1000 == 0 || i == 0) {
                    if (localDebugOutput) {
                        Logger.logInfo("Adding 1000 String Cells took: " + (System.currentTimeMillis() - ltimr));
                    }
                    ltimr = System.currentTimeMillis();
                }
                c = this.sheet.add((Object)(String.valueOf(teststr) + addr), i, x);
                Assert.assertEquals((Object)c.getStringVal(), (Object)(String.valueOf(teststr) + addr));
                ++i;
            }
            ++x;
        }
        x = 0;
        while (x < 1) {
            coladdr = ExcelTools.getAlphaVal(x);
            if (localDebugOutput) {
                ExcelTools.benchmark("Beginning " + this.numadds + " numeric cell adds.  " + coladdr, this);
            }
            i = 0;
            while (i < this.numadds) {
                if (i % 1000 == 0) {
                    if (localDebugOutput) {
                        Logger.logInfo("Adding 1000 Numeric Cells took: " + (System.currentTimeMillis() - ltimr));
                    }
                    ltimr = System.currentTimeMillis();
                }
                Double addd = new Double(17.237 * (double)i);
                Assert.assertEquals((Object)new Double(this.sheet.add((Object)addd, i, x).getDoubleVal()), (Object)addd);
                ++i;
            }
            ++x;
        }
        String bknm = String.valueOf(this.outputdir) + "testAddCellout.xls";
        if (localDebugOutput) {
            ExcelTools.benchmark("Begin writing file:" + bknm, this);
        }
        this.testWrite(book, bknm);
        if (localDebugOutput) {
            ExcelTools.benchmark("Done.", this);
        }
        if (localDebugOutput) {
            ExcelTools.benchmark("Begin re-reading file.", this);
        }
        WorkBookHandle testb = new WorkBookHandle(bknm, 0);
        try {
            WorkSheetHandle testsheet = testb.getWorkSheet("Sheet1");
            if (localDebugOutput) {
                Logger.logInfo("Got: " + testsheet.getSheetName() + " OKAY.");
            }
        }
        catch (Exception e) {
            Logger.logErr(e);
        }
        ExcelTools.benchmark("Test AddBiffRec Complete", this);
        if (localDebugOutput) {
            Logger.logInfo("ELAPSED TIME: " + (System.currentTimeMillis() - lt) + " millis " + lm + ":" + Runtime.getRuntime().freeMemory() + " USED BYTES.");
        }
    }

    @Test
    public void testAddObjectArrayCells() {
        long begintime = System.currentTimeMillis();
        this.book = new WorkBookHandle();
        this.book.setDupeStringMode(0);
        this.book.setStringEncodingMode(2);
        try {
            this.sheet = this.book.getWorkSheet("Sheet1");
        }
        catch (WorkSheetNotFoundException e) {
            Logger.logErr(e);
        }
        long ltimr = 0L;
        Object[] objs = new Object[]{new Integer(700000), new Integer(855000), new String("ABCD"), new String("1st ABC USER - DO NOT DELETE"), new String("SUS"), new String("4zb87491de23qf01hd0a10q2b6554692"), new String(""), new Date(System.currentTimeMillis()), new String("2003-08-01 20:22:55.0"), new String("2001-04-03 12:42:51.0"), new Integer(0), new String(""), new String("2003-08-01 20:22:55.0")};
        int i = 1;
        while (i < this.numadds + 1) {
            if (i % 1000 == 0 || i == 0) {
                ltimr = System.currentTimeMillis();
            }
            objs[0] = new Integer(i * 2345);
            objs[7] = new Date(System.currentTimeMillis());
            this.sheet.insertRow(i, objs);
            ++i;
        }
        String bknm = String.valueOf(this.outputdir) + "testAddCustomerCellout.xls";
        this.testWrite(this.book, bknm);
        long elapsed = System.currentTimeMillis() - begintime;
        Assert.assertTrue(((elapsed /= 1000L) < 3000L ? 1 : 0) != 0);
    }

    @Test
    public void testXLSX() throws Exception {
        this.book = new WorkBookHandle(String.valueOf(System.getProperty("user.dir")) + "/test/reports/WorkBook1.xlsx");
        this.book.setFormulaCalculationMode(1);
        this.sheet = this.book.getWorkSheet("Sheet1");
        Object[] vals = new Object[]{"ABCDE", 1000, 2.5, new Double(2500.0)};
        this.sheet.add(vals[0], "A10");
        this.sheet.add(vals[1], "B10");
        this.sheet.add(vals[2], "C10");
        CellHandle cell = this.sheet.add("=B10*C10", "D10");
        Object v = cell.getVal();
        Assert.assertEquals(null, (Object)v);
        Assert.assertEquals((Object)"", (Object)cell.getStringVal());
    }

    @Test
    public void testAddCellsWithCalcExplicit() throws Exception {
        this.book = new WorkBookHandle();
        this.book.setFormulaCalculationMode(1);
        this.sheet = this.book.getWorkSheet("Sheet1");
        Object[] vals = new Object[]{"ABCDE", 1000, 2.5, new Double(2500.0)};
        this.sheet.add(vals[0], "A10");
        this.sheet.add(vals[1], "B10");
        this.sheet.add(vals[2], "C10");
        CellHandle cell = this.sheet.add("=B10*C10", "D10");
        Object v = cell.getVal();
        Assert.assertEquals(null, (Object)v);
        Assert.assertEquals((Object)"", (Object)cell.getStringVal());
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }
}

