(defproject adgoji/coendou "0.1.0-SNAPSHOT"
  :description "FIXME: write description"
  :url "http://example.com/FIXME"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
 
            :scm {:url ""}
 
            :profiles {:repl {;; We should start in user and not in the configured main
                               :repl-options {:init-ns user}
                               ;; To prevent issues with reloading code we need to clear :aot, see
                               ;; https://github.com/clojure/tools.namespace/blob/b3cd423ef3838b72dfe252c11a025a3ee8313f4b/README.md#warnings-and-potential-problems
                               :aot nil}
                        :dev
                        {:source-paths ["dev/src"]

                         ;; Turn on validation!
                         :injections [(require 'schema.core)
                                      (schema.core/set-fn-validation! true)]

                         :plugins [[lein-midje "3.1.3"]
                                   ;; For private deps (e.g. adgoji-rtb-data)
                                   [s3-wagon-private "1.1.2" :exclusions [commons-logging commons-codec]]]

                         :dependencies [
                                        [compojure "1.4.0"]
                                        [org.clojure/tools.reader "0.9.2"]
                                        [org.clojure/tools.namespace "0.2.10"]
                                        [midje "1.8.2" :exclusions [commons-codec clj-time]]
                                        
                                        
                                        [com.stuartsierra/component "0.2.2"]

                                        [com.taoensso/timbre "3.4.0"]

                                        [prismatic/schema "0.4.3" :exclusions [prismatic/cljs-test]]

                                        ;; Experiment with hybrid of prismatics graph
                                        [com.redbrainlabs/system-graph "0.2.0"]
                                        [prismatic/plumbing "0.4.3"]
                                        
                                        [cheshire "5.4.0"]
                                        
                                        [manifold "0.1.1"]
                                        [aleph "0.4.1-beta2"]
                                        [org.clojure/clojure "1.7.0"]
                                       ]}

                        :provided
                        {:dependencies [;; This is a required dependency of ring-core (it doesn't compile without), see README
                                        [javax.servlet/servlet-api "2.5"]]}

                       }
  :dependencies [[com.tdunning/t-digest "3.1"]
                 [amalloy/ring-buffer "1.2" :exclusions [org.clojure/clojurescript]]
                 [org.clojure/core.async "0.2.371"]]
  
    :jvm-opts ["-XX:MaxPermSize=512M"
               "-XX:-OmitStackTraceInFastThrow"
               "-XX:+UseConcMarkSweepGC"
               "-Xms1g" "-Xmx1g" "-server"]
    
  )
