# adtile-lambda

[![Clojars Project](https://img.shields.io/clojars/v/adtile/lambda-core.svg)](https://clojars.org/adtile/lambda-core)

## Usage

1. Add adtile-lambda-core to project.clj:

      `[adtile/lambda-core "0.2.0"]`

2. Create your lambda:

      ```
      (ns lambda-foobar
        (:require [uswitch.lambada.core :refer [deflambdafn]]
                  [adtile.lambda.core :as lambda]))

      (System/setProperty "loggly.inputKey" "secret-loggly-input-key")
      (System/setProperty "loggly.tags" "foobar,bar,foo") ; environment tag will be added automatically

      (defn handle [context payload output]
        ;; context - the context (see https://github.com/aws/aws-lambda-java-libs/blob/master/aws-lambda-java-core/src/main/java/com/amazonaws/services/lambda/runtime/Context.java)
        ;; payload - the function invokation payload, parsed from JSON (keywordized)
        ;; output - a Writer for output
        ;;
        ;; the function return value will be written to the output automatically
        ;; unless you return nil from here. in case of not nil, the return
        ;; value must be something that can be converted to json.

        {:message (str "Hello, " (:name payload) "!")})

      (deflambdafn lambda.Fn [is os context]
        (lambda/handle-invoke is os context handle))
      ```

3. Add configuration to resources/config/application.edn:

      ```
      {:nomad/environments
       {"local"
        {:delivery-stream {:name "NOT-IN-USE"
                           :region "us-east-1"}}
        "staging"
        {:delivery-stream {:name "adtile-staging-analytics-to-s3-stream-us-east-1"
                           :region "us-east-1"}}
        "production"
        {:delivery-stream {:name "adtile-production-analytics-to-s3-stream-us-east-1"
                           :region "us-east-1"}}}}
      ```

(local is the environment name used locally, development is reserved for
running development lambdas in actual aws environment)

4. Profit
