(ns adtile.lambda.core
  (:require [uswitch.lambada.core :refer [deflambdafn]]
            [clojure.string :refer [split]]
            [clojure.tools.logging :as log]
            [cheshire.core :refer [parse-stream generate-stream generate-string parse-string]]
            [clojure.java.io :as io])
  (:import [com.amazonaws.services.lambda.runtime Context]
           [org.slf4j LoggerFactory]
           [ch.qos.logback.classic.joran JoranConfigurator]
           [java.io ByteArrayInputStream ByteArrayOutputStream]))

(defn handle-invoke [is os context handler-fn]
  (let [env (second (split (.getFunctionName context) #"-|_"))]
    (when-not (= "local" env)
      (System/setProperty "nomad.env" env)
      (System/setProperty "logback.configurationFile" "logback-production.xml"))
    (with-open [writer (io/writer os)]
      (let [payload (parse-stream (io/reader is :encoding "UTF-8") true)
            output (handler-fn context payload writer)]
        (when output (generate-stream output writer))
        nil))))

(defn mock-context [function-name]
  (reify Context
    (getFunctionName [this]
      function-name)))

(defn local-invoke [handler-fn payload]
  (let [context (mock-context (str "adtile-local-testlambda"))
        is (ByteArrayInputStream. (.getBytes (generate-string payload)))
        os (ByteArrayOutputStream.)]
    (handle-invoke is os context handler-fn)
    (parse-string (String. (.toByteArray os) "UTF-8") true)))

