(ns crap.exceptions
  (:require [clojure.tools.logging :as log]))


(defn log-stack-trace []
  (let [st (with-out-str
             (mapv #(print (str %) " ")
               (rest (.. (Thread/currentThread) (getStackTrace)))))]
    (log/warn st)))

(defn gen-exception-clause [exception as exception-clause]
  `(catch ~exception ~as
     ~exception-clause))

(defmacro with-exceptions [{:keys [exceptions as]} body exception-clause]
  `(try
     ~body
     ~@(mapv #(gen-exception-clause % as exception-clause) exceptions)))
