/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.Counted;
import clojure.lang.IChunk;
import clojure.lang.IChunkedSeq;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.Numbers;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Reduced;
import clojure.lang.Repeat;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongRange
extends ASeq
implements Counted,
IChunkedSeq,
IReduce {
    private static final int CHUNK_SIZE = 32;
    final long start;
    final long end;
    final long step;
    final BoundsCheck boundsCheck;
    private volatile LongChunk _chunk;
    private volatile ISeq _chunkNext;
    private volatile ISeq _next;

    private static BoundsCheck positiveStep(final long end) {
        return new BoundsCheck(){

            @Override
            public boolean exceededBounds(long val2) {
                return val2 >= end;
            }
        };
    }

    private static BoundsCheck negativeStep(final long end) {
        return new BoundsCheck(){

            @Override
            public boolean exceededBounds(long val2) {
                return val2 <= end;
            }
        };
    }

    private LongRange(long start, long end, long step, BoundsCheck boundsCheck) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.boundsCheck = boundsCheck;
    }

    private LongRange(long start, long end, long step, BoundsCheck boundsCheck, LongChunk chunk2, ISeq chunkNext) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.boundsCheck = boundsCheck;
        this._chunk = chunk2;
        this._chunkNext = chunkNext;
    }

    private LongRange(IPersistentMap meta, long start, long end, long step, BoundsCheck boundsCheck, LongChunk chunk2, ISeq chunkNext) {
        super(meta);
        this.start = start;
        this.end = end;
        this.step = step;
        this.boundsCheck = boundsCheck;
        this._chunk = chunk2;
        this._chunkNext = chunkNext;
    }

    public static ISeq create(long end) {
        if (end > 0L) {
            return new LongRange(0L, end, 1L, LongRange.positiveStep(end));
        }
        return PersistentList.EMPTY;
    }

    public static ISeq create(long start, long end) {
        if (start >= end) {
            return PersistentList.EMPTY;
        }
        return new LongRange(start, end, 1L, LongRange.positiveStep(end));
    }

    public static ISeq create(long start, long end, long step) {
        if (step > 0L) {
            if (end <= start) {
                return PersistentList.EMPTY;
            }
            return new LongRange(start, end, step, LongRange.positiveStep(end));
        }
        if (step < 0L) {
            if (end >= start) {
                return PersistentList.EMPTY;
            }
            return new LongRange(start, end, step, LongRange.negativeStep(end));
        }
        if (end == start) {
            return PersistentList.EMPTY;
        }
        return Repeat.create(start);
    }

    @Override
    public Obj withMeta(IPersistentMap meta) {
        if (meta == this._meta) {
            return this;
        }
        return new LongRange(meta, this.start, this.end, this.step, this.boundsCheck, this._chunk, this._chunkNext);
    }

    @Override
    public Object first() {
        return this.start;
    }

    public void forceChunk() {
        long count2;
        if (this._chunk != null) {
            return;
        }
        try {
            count2 = this.rangeCount(this.start, this.end, this.step);
        }
        catch (ArithmeticException e2) {
            count2 = this.steppingCount(this.start, this.end, this.step);
        }
        if (count2 > 32L) {
            long nextStart = this.start + this.step * 32L;
            this._chunk = new LongChunk(this.start, this.step, 32);
            this._chunkNext = new LongRange(nextStart, this.end, this.step, this.boundsCheck);
        } else {
            this._chunk = new LongChunk(this.start, this.step, (int)count2);
        }
    }

    @Override
    public ISeq next() {
        if (this._next != null) {
            return this._next;
        }
        this.forceChunk();
        if (this._chunk.count() > 1) {
            LongChunk smallerChunk = this._chunk.dropFirst();
            this._next = new LongRange(smallerChunk.first(), this.end, this.step, this.boundsCheck, smallerChunk, this._chunkNext);
            return this._next;
        }
        return this.chunkedNext();
    }

    @Override
    public IChunk chunkedFirst() {
        this.forceChunk();
        return this._chunk;
    }

    @Override
    public ISeq chunkedNext() {
        return this.chunkedMore().seq();
    }

    @Override
    public ISeq chunkedMore() {
        this.forceChunk();
        if (this._chunkNext == null) {
            return PersistentList.EMPTY;
        }
        return this._chunkNext;
    }

    long steppingCount(long start, long end, long step) {
        long count2;
        long s = start;
        for (count2 = 1L; count2 <= 32L; ++count2) {
            try {
                s = Numbers.add(s, step);
                if (this.boundsCheck.exceededBounds(s)) break;
                continue;
            }
            catch (ArithmeticException e2) {
                break;
            }
        }
        return count2;
    }

    long rangeCount(long start, long end, long step) {
        return Numbers.add(Numbers.add(Numbers.minus(end, start), step), this.step > 0L ? -1L : 1L) / step;
    }

    @Override
    public int count() {
        try {
            long c = this.rangeCount(this.start, this.end, this.step);
            if (c > Integer.MAX_VALUE) {
                return Numbers.throwIntOverflow();
            }
            return (int)c;
        }
        catch (ArithmeticException e2) {
            Iterator iter = this.iterator();
            long count2 = 0L;
            while (iter.hasNext()) {
                iter.next();
                ++count2;
            }
            if (count2 > Integer.MAX_VALUE) {
                return Numbers.throwIntOverflow();
            }
            return (int)count2;
        }
    }

    @Override
    public Object reduce(IFn f) {
        Object acc = this.start;
        long i = this.start + this.step;
        while (!this.boundsCheck.exceededBounds(i)) {
            if ((acc = f.invoke(acc, i)) instanceof Reduced) {
                return ((Reduced)acc).deref();
            }
            i += this.step;
        }
        return acc;
    }

    @Override
    public Object reduce(IFn f, Object val2) {
        Object acc = val2;
        long i = this.start;
        do {
            if (!RT.isReduced(acc = f.invoke(acc, i))) continue;
            return ((Reduced)acc).deref();
        } while (!this.boundsCheck.exceededBounds(i += this.step));
        return acc;
    }

    @Override
    public Iterator iterator() {
        return new LongRangeIterator();
    }

    private static class LongChunk
    implements IChunk,
    Serializable {
        final long start;
        final long step;
        final int count;

        public LongChunk(long start, long step, int count2) {
            this.start = start;
            this.step = step;
            this.count = count2;
        }

        public long first() {
            return this.start;
        }

        @Override
        public Object nth(int i) {
            return this.start + (long)i * this.step;
        }

        @Override
        public Object nth(int i, Object notFound) {
            if (i >= 0 && i < this.count) {
                return this.start + (long)i * this.step;
            }
            return notFound;
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public LongChunk dropFirst() {
            if (this.count <= 1) {
                throw new IllegalStateException("dropFirst of empty chunk");
            }
            return new LongChunk(this.start + this.step, this.step, this.count - 1);
        }

        @Override
        public Object reduce(IFn f, Object init2) {
            long x = this.start;
            Object ret = init2;
            for (int i = 0; i < this.count; ++i) {
                if (RT.isReduced(ret = f.invoke(ret, x))) {
                    return ret;
                }
                x += this.step;
            }
            return ret;
        }
    }

    class LongRangeIterator
    implements Iterator {
        private long next;
        private boolean hasNext;

        public LongRangeIterator() {
            this.next = LongRange.this.start;
            this.hasNext = true;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            if (this.hasNext) {
                long ret = this.next;
                try {
                    this.next = Numbers.add(this.next, LongRange.this.step);
                    this.hasNext = !LongRange.this.boundsCheck.exceededBounds(this.next);
                }
                catch (ArithmeticException e2) {
                    this.hasNext = false;
                }
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface BoundsCheck
    extends Serializable {
        public boolean exceededBounds(long var1);
    }
}

