/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.channels;

import com.amazon.channels.AbstractSocketChannel;
import com.amazon.channels.ISocketChannelReadCallback;
import com.amazon.channels.SocketChannelMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

public class PlainSocketChannel
extends AbstractSocketChannel {
    protected static final int READ_BUFFER_CAPACITY = 512000;
    private ByteBuffer m_readBuffer = ByteBuffer.allocateDirect(512000);

    public PlainSocketChannel(SocketChannel internal, ISocketChannelReadCallback readCallback, ILogger logger) throws ErrorException {
        super(internal, readCallback, logger);
        this.m_readBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public boolean write(ByteBuffer writeBuffer) throws ErrorException {
        if (null == this.m_internal || this.isClosed()) {
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name());
        }
        int bytesWritten = 0;
        while (writeBuffer.hasRemaining()) {
            try {
                bytesWritten = this.m_internal.write(writeBuffer);
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug("Writing " + bytesWritten + " bytes", this.m_log);
                }
                if (0 != bytesWritten) continue;
                return true;
            }
            catch (IOException ex) {
                String message;
                if (this.m_log.isEnabled()) {
                    LogUtilities.logDebug(ex, this.m_log);
                }
                if (null != (message = ex.getMessage())) {
                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), message, (Throwable)ex);
                }
                throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name(), ex);
            }
        }
        return true;
    }

    @Override
    public void read() throws ErrorException {
        int bytesRead = -2;
        do {
            try {
                bytesRead = this.m_internal.read(this.m_readBuffer);
            }
            catch (IOException ex) {
                LogUtilities.logFatal(ex, this.m_log);
                String message = ex.getMessage();
                if (null != message) {
                    throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_GENERAL_ERR.name(), message, (Throwable)ex);
                }
                throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name(), ex);
            }
            if (this.m_log.isEnabled()) {
                LogUtilities.logDebug("Bytes read from channel: " + bytesRead, this.m_log);
            }
            if (-1 != bytesRead) continue;
            this.readCallback(this.m_readBuffer);
            throw EXCEPTION_BUILDER.createGeneralException(SocketChannelMessageKey.CHANNEL_SERVER_CLOSED.name());
        } while (bytesRead > 0);
        this.readCallback(this.m_readBuffer);
    }

    @Override
    public int getReadBufferCapacity() {
        return 512000;
    }
}

