/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.jdbc41;

import com.amazon.jdbc.jdbc41.S41PooledConnection;
import com.amazon.jdbc.jdbc41.S41PreparedStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class S41PreparedStatementHandle
implements PreparedStatement {
    private S41PreparedStatement m_preparedStatement;
    private S41PooledConnection m_pooledConnection;

    public S41PreparedStatementHandle(S41PooledConnection s41PooledConnection, S41PreparedStatement s41PreparedStatement) {
        this.m_pooledConnection = s41PooledConnection;
        this.m_preparedStatement = s41PreparedStatement;
    }

    @Override
    public synchronized void addBatch() throws SQLException {
    }

    @Override
    public synchronized void addBatch(String string) throws SQLException {
        this.m_preparedStatement.addBatch(string);
    }

    @Override
    public void cancel() throws SQLException {
        this.m_preparedStatement.cancel();
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        this.m_preparedStatement.clearBatch();
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        this.m_preparedStatement.clearParameters();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.m_preparedStatement.clearWarnings();
    }

    @Override
    public synchronized void close() throws SQLException {
        this.m_preparedStatement.close();
        this.m_pooledConnection.onHandleStatementClose(this.m_preparedStatement);
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        try {
            return this.m_preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized boolean execute(String string) throws SQLException {
        try {
            return this.m_preparedStatement.execute(string);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized boolean execute(String string, int n) throws SQLException {
        try {
            return this.m_preparedStatement.execute(string, n);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized boolean execute(String string, int[] nArray) throws SQLException {
        try {
            return this.m_preparedStatement.execute(string, nArray);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            return this.m_preparedStatement.execute(string, stringArray);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        try {
            return this.m_preparedStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        try {
            return this.m_preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        try {
            return this.m_preparedStatement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized int executeUpdate(String string) throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int n) throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate(string, n);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate(string, nArray);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate(string, stringArray);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.m_preparedStatement.getConnection();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        try {
            return this.m_preparedStatement.getFetchDirection();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        try {
            return this.m_preparedStatement.getFetchSize();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.m_preparedStatement.getGeneratedKeys();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this.m_preparedStatement.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this.m_preparedStatement.getMaxRows();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.m_preparedStatement.getMetaData();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this.m_preparedStatement.getMoreResults();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized boolean getMoreResults(int n) throws SQLException {
        try {
            return this.m_preparedStatement.getMoreResults(n);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.m_preparedStatement.getParameterMetaData();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this.m_preparedStatement.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.m_preparedStatement.getResultSet();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.m_preparedStatement.getResultSetConcurrency();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.m_preparedStatement.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this.m_preparedStatement.getResultSetType();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this.m_preparedStatement.getUpdateCount();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.m_preparedStatement.getWarnings();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_preparedStatement.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            return this.m_preparedStatement.isPoolable();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return this.m_preparedStatement.isWrapperFor(clazz);
    }

    @Override
    public synchronized void setArray(int n, Array array) throws SQLException {
        try {
            this.m_preparedStatement.setArray(n, array);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setAsciiStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            this.m_preparedStatement.setAsciiStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            this.m_preparedStatement.setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setBinaryStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            this.m_preparedStatement.setBinaryStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        try {
            this.m_preparedStatement.setBlob(n, blob);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setBlob(n, inputStream);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setBlob(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        try {
            this.m_preparedStatement.setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setByte(int n, byte by) throws SQLException {
        try {
            this.m_preparedStatement.setByte(n, by);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            this.m_preparedStatement.setBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            this.m_preparedStatement.setCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setClob(int n, Clob clob) throws SQLException {
        try {
            this.m_preparedStatement.setClob(n, clob);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setClob(n, reader);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        try {
            this.m_preparedStatement.setCursorName(string);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setDate(int n, Date date) throws SQLException {
        try {
            this.m_preparedStatement.setDate(n, date);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setDate(int n, Date date, Calendar calendar) throws SQLException {
        try {
            this.m_preparedStatement.setDate(n, date, calendar);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setDouble(int n, double d) throws SQLException {
        try {
            this.m_preparedStatement.setDouble(n, d);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            this.m_preparedStatement.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setFetchDirection(int n) throws SQLException {
        try {
            this.m_preparedStatement.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        try {
            this.m_preparedStatement.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setFloat(int n, float f) throws SQLException {
        try {
            this.m_preparedStatement.setFloat(n, f);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setInt(int n, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setInt(n, n2);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setLong(int n, long l) throws SQLException {
        try {
            this.m_preparedStatement.setLong(n, l);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        try {
            this.m_preparedStatement.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        try {
            this.m_preparedStatement.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setNCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setNCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setNClob(n, nClob);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setNClob(n, reader);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setNClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setNString(int n, String string) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setNString(n, string);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setNull(int n, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setNull(n, n2);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        try {
            this.m_preparedStatement.setNull(n, n2, string);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setObject(int n, Object object) throws SQLException {
        try {
            this.m_preparedStatement.setObject(n, object);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            this.m_preparedStatement.setObject(n, object, n2, n3);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        try {
            this.m_preparedStatement.setPoolable(bl);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.m_preparedStatement.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setRef(int n, Ref ref) throws SQLException {
        try {
            this.m_preparedStatement.setRef(n, ref);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setRowId(n, rowId);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setShort(int n, short s) throws SQLException {
        try {
            this.m_preparedStatement.setShort(n, s);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setSQLXML(n, sQLXML);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setString(int n, String string) throws SQLException {
        try {
            this.m_preparedStatement.setString(n, string);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setTime(int n, Time time) throws SQLException {
        try {
            this.m_preparedStatement.setTime(n, time);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setTime(int n, Time time, Calendar calendar) throws SQLException {
        try {
            this.m_preparedStatement.setTime(n, time, calendar);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            this.m_preparedStatement.setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            this.m_preparedStatement.setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            this.m_preparedStatement.setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public synchronized void setURL(int n, URL uRL) throws SQLException {
        try {
            this.m_preparedStatement.setURL(n, uRL);
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return this.m_preparedStatement.unwrap(clazz);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            this.m_preparedStatement.closeOnCompletion();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            return this.m_preparedStatement.isCloseOnCompletion();
        }
        catch (SQLException sQLException) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, sQLException);
            }
            throw sQLException;
        }
    }
}

