/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.jdbc41.utilities;

import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.SArray;
import com.amazon.jdbc.common.SForwardResultSet;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ExceptionType;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

public class ResultSetUtilities {
    public static <T> T getObjectByType(SForwardResultSet sForwardResultSet, int n, Class<T> clazz) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(sForwardResultSet.getLogger(), n, clazz);
            if (clazz.equals(BigDecimal.class)) {
                return (T)sForwardResultSet.getBigDecimal(n);
            }
            if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                return (T)Boolean.valueOf(sForwardResultSet.getBoolean(n));
            }
            if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
                return (T)Byte.valueOf(sForwardResultSet.getByte(n));
            }
            if (clazz.equals(byte[].class)) {
                return (T)sForwardResultSet.getBytes(n);
            }
            if (clazz.equals(Date.class)) {
                return (T)sForwardResultSet.getDate(n);
            }
            if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
                return (T)Double.valueOf(sForwardResultSet.getDouble(n));
            }
            if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
                return (T)Float.valueOf(sForwardResultSet.getFloat(n));
            }
            if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(sForwardResultSet.getInt(n));
            }
            if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
                return (T)Long.valueOf(sForwardResultSet.getLong(n));
            }
            if (clazz.equals(Object.class)) {
                return (T)sForwardResultSet.getObject(n);
            }
            if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
                return (T)Short.valueOf(sForwardResultSet.getShort(n));
            }
            if (clazz.equals(String.class)) {
                return (T)sForwardResultSet.getString(n);
            }
            if (clazz.equals(Time.class)) {
                return (T)sForwardResultSet.getTime(n);
            }
            if (clazz.equals(Timestamp.class)) {
                return (T)sForwardResultSet.getTimestamp(n);
            }
            if (Array.class.equals(clazz) || SArray.class.isAssignableFrom(clazz)) {
                return (T)sForwardResultSet.getArray(n);
            }
            if (clazz.equals(Blob.class) || clazz.equals(Clob.class) || clazz.equals(Ref.class) || clazz.equals(URL.class) || clazz.equals(NClob.class) || clazz.equals(RowId.class) || clazz.equals(SQLXML.class)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)sForwardResultSet.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)sForwardResultSet.getWarningListener(), ExceptionType.NON_TRANSIENT, String.valueOf(n), clazz.getName());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, sForwardResultSet.getWarningListener(), sForwardResultSet.getLogger());
        }
    }
}

