/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.api;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.Nullable;
import com.amazon.dsi.dataengine.utilities.ParameterType;
import com.amazon.dsi.dataengine.utilities.TimestampTz;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.dataengine.utilities.Updatable;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.exceptions.NumericOverflowException;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.jdbc.utils.DataTypeUtilities;
import com.amazon.redshift.api.PGArrayColumnMetaData;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.inbound.FieldDescription;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.dataengine.metadata.PGColumnMetadata;
import com.amazon.redshift.dataengine.metadata.PGParameterMetadata;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class PGDataTypeUtilities
extends DataTypeUtilities
implements PGConstants {
    private static final byte TRUE_BYTE_VALUE = 116;
    private static final byte ONE_BYTE_VALUE = 49;
    private static final byte ZERO_BYTE_VALUE = 48;
    private static final byte FALSE_BYTE_VALUE = 102;
    private static final int utf8InvalidValue = -1;
    private static final byte asciiInvalidValue = 127;
    private static final int OCTAL_FORMAT_MASK_UPPER = 240;
    private static final int OCTAL_FORMAT_MASK_LOWER = 15;
    private static final byte HEX_ENCODE_BYTE = 120;
    private static final byte HEX_BINARY_ESCAPE = 92;
    private static ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    public static final int DEFAULT_PARAMETER_LENGTH = -1;
    private static ThreadLocal<SimpleDateFormat> TIMESTAMP_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.");
        }
    };
    private static final NumberFormat NANOSECONDS_FORMAT = new DecimalFormat("000000000");
    public static final String INFINITY_KEYWORD = "infinity";
    public static final String MINUS_INFINITY_KEYWORD = "-infinity";
    public static final Timestamp INFINITY_DATE_VALUE = new Timestamp(Long.MAX_VALUE);
    public static final Timestamp MINUS_INFINITY_DATE_VALUE = new Timestamp(Long.MIN_VALUE);

    public static ColumnMetadata createColumn(String catalog, String schema, String table, String column, FieldDescription field, Boolean isNullable) throws ErrorException {
        int length = field.getDataTypeSize();
        boolean exactNumericTypeLengthOverride = false;
        ColumnMetadata columnMeta = null;
        switch (field.getDataTypeObjectID()) {
            case 2206: {
                length = 255;
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "regtype"));
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 24: {
                length = 255;
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "regproc"));
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 19: {
                length = 64;
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "name"));
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 25: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "text"));
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 1043: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "varchar"));
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 1033: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "aclitem"));
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 2211: {
                length = 255;
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 12, length, "_regtype");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 1008: {
                length = 255;
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 12, length, "_regproc");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 1003: {
                length = 64;
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 12, length, "_name");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 1009: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 12, length, "_text");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 1034: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 12, length, "aclitem");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 1015: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 12, length, "_varchar");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 18: {
                length = 1;
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(1, "char"));
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 1042: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(1, "bpchar"));
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 1002: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 1, length, "_char");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 1014: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 1, length, "_bpchar");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 21: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(5, "int2"));
                break;
            }
            case 1005: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 5, length, "_int2");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 28: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(4, "xid"));
                break;
            }
            case 23: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(4, "int4"));
                break;
            }
            case 1011: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 4, length, "_xid");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 1007: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 4, length, "_int4");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 20: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(-5, "int8"));
                break;
            }
            case 26: {
                exactNumericTypeLengthOverride = true;
                length = 10;
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(-5, "oid"));
                break;
            }
            case 1016: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, -5, length, "_int8");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 1028: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, -5, length, "_oid");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 700: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(7, "float4"));
                break;
            }
            case 1021: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 7, length, "_float4");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 701: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(8, "float8"));
                break;
            }
            case 1022: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 8, length, "_float8");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 1082: {
                columnMeta = new PGColumnMetadata(PGDataTypeUtilities.createTypeMetadata(91, "date"));
                break;
            }
            case 1182: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 91, length, "_date");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 1083: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(92, "time"));
                break;
            }
            case 1183: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 92, length, "_time");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 1114: {
                columnMeta = new PGColumnMetadata(PGDataTypeUtilities.createTypeMetadata(93, "timestamp"));
                break;
            }
            case 1115: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 93, length, "_timestamp");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 702: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "abstime"));
                break;
            }
            case 1023: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 12, length, "_abstime");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 1186: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "interval"));
                break;
            }
            case 703: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "reltime"));
                break;
            }
            case 1024: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 12, length, "_reltime");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 16: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(-7, "bool"));
                break;
            }
            case 1560: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(-7, "bit"));
                break;
            }
            case 1000: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, -7, length, "_bool");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 1561: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, -7, length, "_bit");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 1700: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(2, "numeric"));
                break;
            }
            case 1231: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 2, length, "_numeric");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 27: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "tid"));
                columnMeta.setCaseSensitive(true);
                break;
            }
            case 1010: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, 12, length, "_tid");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 17: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(-4, "bytea"));
                break;
            }
            case 1001: {
                IColumn baseColumn = PGDataTypeUtilities.createBaseArrayColumn(catalog, schema, table, column, -4, length, "_bytea");
                columnMeta = new PGArrayColumnMetaData(baseColumn);
                break;
            }
            case 22: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, "int2vector"));
                break;
            }
            default: {
                columnMeta = new ColumnMetadata(PGDataTypeUtilities.createTypeMetadata(12, null));
                break;
            }
        }
        if (columnMeta.getTypeMetadata().isIntervalType() || columnMeta.getTypeMetadata().isCharacterType()) {
            columnMeta.getTypeMetadata().setIntervalPrecision(length);
        }
        if (columnMeta.getTypeMetadata().isCharacterType()) {
            try {
                columnMeta.setColumnLength(length);
            }
            catch (NumericOverflowException e) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_METADATA_INITIALIZATION_ERR.name(), e);
            }
        }
        if (exactNumericTypeLengthOverride) {
            columnMeta.getTypeMetadata().setPrecision((short)length);
        } else if (columnMeta.getTypeMetadata().isExactNumericType()) {
            int precision = length - 4 >> 16 & 0xFFFF;
            int scale = length - 4 & 0xFFFF;
            columnMeta.getTypeMetadata().setPrecision((short)precision);
            columnMeta.getTypeMetadata().setScale((short)scale);
        }
        columnMeta.setName(PGDataTypeUtilities.toUTF8String(field.getFieldName()));
        columnMeta.setLabel(columnMeta.getName());
        columnMeta.setCatalogName(catalog);
        columnMeta.setTableName(table);
        columnMeta.setUpdatable(Updatable.READ_ONLY);
        if (null != isNullable) {
            if (isNullable.booleanValue()) {
                columnMeta.setNullable(Nullable.NULLABLE);
            } else {
                columnMeta.setNullable(Nullable.NO_NULLS);
            }
        } else {
            columnMeta.setNullable(Nullable.UNKNOWN);
        }
        return columnMeta;
    }

    public static TypeMetadata createTypeMetadata(int sqlType, String typeName) throws ErrorException {
        switch (sqlType) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return PGDataTypeUtilities.createTypeMetadata(sqlType, true, typeName);
            }
            case -11: 
            case -10: 
            case -9: 
            case -8: 
            case -7: 
            case -6: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 2003: {
                return PGDataTypeUtilities.createTypeMetadata(sqlType, false, typeName);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(sqlType), ExceptionType.DATA);
    }

    public static String sqlTypeToString(short sqlType) {
        switch (sqlType) {
            case 2003: {
                return "SQL_ARRAY";
            }
            case -5: {
                return "int8";
            }
            case 3: {
                return "float8";
            }
            case 8: {
                return "float8";
            }
            case 6: {
                return "float4";
            }
            case 4: {
                return "int4";
            }
            case 2: {
                return "numeric";
            }
            case 0: {
                return "NULL";
            }
            case 7: {
                return "float4";
            }
            case 5: {
                return "int2";
            }
            case -2: {
                return "bytea";
            }
            case -7: {
                return "bit";
            }
            case 16: {
                return "bool";
            }
            case 1: {
                return "char";
            }
            case -4: {
                return "bytea";
            }
            case -1: {
                return "varchar";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "timestamp";
            }
            case -6: {
                return "SQL_TINYINT";
            }
            case -3: {
                return "bytea";
            }
            case 12: {
                return "varchar";
            }
            case -11: {
                return "SQL_GUID";
            }
            case -8: {
                return "SQL_WCHAR";
            }
            case -9: {
                return "SQL_WVARCHAR";
            }
            case -10: {
                return "SQL_WLONGVARCHAR";
            }
            case 103: {
                return "SQL_INTERVAL_DAY";
            }
            case 108: {
                return "SQL_INTERVAL_DAY_TO_HOUR";
            }
            case 109: {
                return "SQL_INTERVAL_DAY_TO_MINUTE";
            }
            case 110: {
                return "SQL_INTERVAL_DAY_TO_SECOND";
            }
            case 104: {
                return "SQL_INTERVAL_HOUR";
            }
            case 111: {
                return "SQL_INTERVAL_HOUR_TO_MINUTE";
            }
            case 112: {
                return "SQL_INTERVAL_HOUR_TO_SECOND";
            }
            case 105: {
                return "SQL_INTERVAL_MINUTE";
            }
            case 113: {
                return "SQL_INTERVAL_MINUTE_TO_SECOND";
            }
            case 102: {
                return "SQL_INTERVAL_MONTH";
            }
            case 106: {
                return "SQL_INTERVAL_SECOND";
            }
            case 101: {
                return "SQL_INTERVAL_YEAR";
            }
            case 107: {
                return "SQL_INTERVAL_YEAR_TO_MONTH";
            }
        }
        return null;
    }

    public static int SQLTypeToOid(short sqlType) {
        switch (sqlType) {
            case -5: {
                return 20;
            }
            case 2: 
            case 3: {
                return 1700;
            }
            case 8: {
                return 701;
            }
            case 6: 
            case 7: {
                return 701;
            }
            case 4: {
                return 23;
            }
            case -6: 
            case 5: {
                return 21;
            }
            case -4: 
            case -3: 
            case -2: {
                return 17;
            }
            case -7: {
                return 1560;
            }
            case 16: {
                return 16;
            }
            case 1: {
                return 18;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 12: {
                return 1043;
            }
            case 91: {
                return 1082;
            }
            case 92: {
                return 1083;
            }
            case 93: {
                return 1114;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return 1186;
            }
        }
        return 1043;
    }

    public static TypeMetadata createTypeMetadata(int sqlType, boolean isSigned, String typeName) throws ErrorException {
        switch (sqlType) {
            case 2003: {
                TypeMetadata tm = new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_ARRAY", 0, 0, 0, isSigned);
                tm.setIsSortable(false);
                return tm;
            }
            case -5: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_BIGINT", 19, 0, 19, isSigned);
            }
            case -2: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_BINARY", 1, 0, 1, isSigned);
            }
            case -7: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_BIT", 1, 0, 0, isSigned);
            }
            case 16: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_BOOLEAN", 1, 0, 0, isSigned);
            }
            case 1: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_CHAR", 1, 0, 1, isSigned);
            }
            case 3: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_DECIMAL", 38, 0, 38, isSigned);
            }
            case 8: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_DOUBLE", 17, 17, 53, isSigned);
            }
            case 6: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_FLOAT", 15, 0, 53, isSigned);
            }
            case -11: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_GUID", 36, 0, 36, isSigned);
            }
            case 4: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTEGER", 10, 0, 0, isSigned);
            }
            case -4: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_LONGVARBINARY", 1, 0, 1, isSigned);
            }
            case -1: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_LONGVARCHAR", 1, 0, 1, isSigned);
            }
            case 0: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "NULL", 0, 0, 0, isSigned);
            }
            case 2: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_NUMERIC", 38, 0, 38, isSigned);
            }
            case 7: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_REAL", 7, 0, 24, isSigned);
            }
            case 5: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_SMALLINT", 5, 0, 5, isSigned);
            }
            case -6: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_TINYINT", 3, 0, 3, isSigned);
            }
            case 91: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_TYPE_DATE", 0, 0, 10, isSigned);
            }
            case 92: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_TYPE_TIME", 0, 0, 8, isSigned);
            }
            case 93: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_TYPE_TIMESTAMP", 6, 6, 0, isSigned);
            }
            case -3: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_VARBINARY", 1, 0, 1, isSigned);
            }
            case 12: {
                return new TypeMetadata((short)sqlType, null != typeName ? typeName : "SQL_VARCHAR", 1, 0, 1, isSigned);
            }
            case 103: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTERVAL_DAY", 0, 0, 2, isSigned);
            }
            case 108: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTERVAL_DAY_TO_HOUR", 0, 0, 2, isSigned);
            }
            case 109: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTERVAL_DAY_TO_MINUTE", 0, 0, 2, isSigned);
            }
            case 110: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTERVAL_DAY_TO_SECOND", 6, 6, 2, isSigned);
            }
            case 104: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTERVAL_HOUR", 0, 0, 2, isSigned);
            }
            case 111: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTERVAL_HOUR_TO_MINUTE", 0, 0, 2, isSigned);
            }
            case 112: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTERVAL_HOUR_TO_SECOND", 6, 6, 2, isSigned);
            }
            case 105: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTERVAL_MINUTE", 0, 0, 2, isSigned);
            }
            case 113: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTERVAL_MINUTE_TO_SECOND", 6, 6, 2, isSigned);
            }
            case 102: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTERVAL_MONTH", 0, 0, 2, isSigned);
            }
            case 106: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTERVAL_SECOND", 6, 6, 2, isSigned);
            }
            case 101: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTERVAL_YEAR", 0, 0, 2, isSigned);
            }
            case 107: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_INTERVAL_YEAR_TO_MONTH", 0, 0, 2, isSigned);
            }
            case -8: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_WCHAR", 0, 0, 0, isSigned);
            }
            case -10: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_WLONGVARCHAR", 0, 0, 0, isSigned);
            }
            case -9: {
                return new TypeMetadata((short)sqlType, typeName != null ? typeName : "SQL_WVARCHAR", 0, 0, 0, isSigned);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(sqlType), ExceptionType.DATA);
    }

    public static int oidToSQLType(int oid) {
        switch (oid) {
            case 19: 
            case 24: 
            case 25: 
            case 1033: 
            case 1043: 
            case 2206: {
                return 12;
            }
            case 18: 
            case 1042: {
                return 1;
            }
            case 21: {
                return 5;
            }
            case 23: 
            case 28: {
                return 4;
            }
            case 20: 
            case 26: {
                return -5;
            }
            case 700: {
                return 7;
            }
            case 701: {
                return 8;
            }
            case 1082: {
                return 91;
            }
            case 1083: {
                return 92;
            }
            case 1114: {
                return 93;
            }
            case 702: {
                return 12;
            }
            case 703: 
            case 1186: {
                return 12;
            }
            case 16: 
            case 1560: {
                return -7;
            }
            case 1700: {
                return 2;
            }
            case 27: {
                return 12;
            }
            case 17: {
                return -4;
            }
            case 22: {
                return 12;
            }
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1005: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1021: 
            case 1022: 
            case 1023: 
            case 1024: 
            case 1028: 
            case 1034: 
            case 1115: 
            case 1182: 
            case 1183: 
            case 1231: 
            case 1561: 
            case 2211: {
                return 2003;
            }
        }
        return 12;
    }

    public static PGParameterMetadata createParameter(int oid, int parameterIndex, PGMessagingContext context) throws NumericOverflowException, ErrorException {
        PGParameterMetadata parameterMeta = null;
        int parameterLength = -1;
        switch (oid) {
            case 2206: {
                parameterLength = 255;
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "regtype"), parameterLength, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 24: {
                parameterLength = 255;
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "regproc"), parameterLength, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 19: {
                parameterLength = 64;
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "name"), parameterLength, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 25: {
                parameterLength = 255;
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "text"), parameterLength, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 1043: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "varchar"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 27: {
                parameterLength = 4;
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "tid"), parameterLength, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 18: {
                parameterLength = 1;
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(1, "char"), parameterLength, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 1042: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(1, "bpchar"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 21: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(5, "int2"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 23: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(4, "int4"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 28: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(4, "xid"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 26: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(-5, "oid"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 20: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(-5, "int8"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 700: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(7, "float4"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 701: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(8, "float8"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 1082: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(91, "date"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 1083: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(92, "time"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 1114: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(93, "timestamp"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 702: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(93, "abstime"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 1186: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "interval"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 703: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(12, "reltime"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 16: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(-7, "bool"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 1560: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(-7, "bit"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            case 1700: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(2, "numeric"), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
            default: {
                parameterMeta = new PGParameterMetadata(parameterIndex, ParameterType.INPUT, PGDataTypeUtilities.createTypeMetadata(1111, null), -1L, null, false, Nullable.UNKNOWN, context);
                break;
            }
        }
        if (parameterMeta.getTypeMetadata().isIntervalType() || parameterMeta.getTypeMetadata().isCharacterType()) {
            parameterMeta.getTypeMetadata().setIntervalPrecision(parameterLength);
        }
        if (parameterMeta.getTypeMetadata().isCharacterType()) {
            parameterMeta.setColumnLength(parameterLength);
        }
        return parameterMeta;
    }

    public static String convertStringToUTF8(String original) {
        try {
            original = new String(original.getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return original;
    }

    public static byte[] toUTF8ByteArray(DataWrapper wrapper) throws ErrorException {
        try {
            if (wrapper.isNull()) {
                return null;
            }
            switch (wrapper.getType()) {
                case 12: {
                    return PGDataTypeUtilities.toUTF8ByteArray(wrapper.getVarChar());
                }
                case 1: {
                    return PGDataTypeUtilities.toUTF8ByteArray(wrapper.getChar());
                }
                case 5: {
                    return PGDataTypeUtilities.toUTF8ByteArray(wrapper.getSmallInt().toString());
                }
                case 4: {
                    return PGDataTypeUtilities.toUTF8ByteArray(wrapper.getInteger().toString());
                }
                case -5: {
                    return PGDataTypeUtilities.toUTF8ByteArray(wrapper.getBigInt().toString());
                }
                case 7: {
                    return PGDataTypeUtilities.toUTF8ByteArray(wrapper.getReal().toString());
                }
                case 8: {
                    return PGDataTypeUtilities.toUTF8ByteArray(wrapper.getDouble().toString());
                }
                case 91: {
                    Date date = wrapper.getDate();
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(date);
                    String dateValue = DATE_FORMAT.get().format(date);
                    if (0 == cal.get(0)) {
                        dateValue = dateValue.concat(" BC");
                    }
                    return PGDataTypeUtilities.toUTF8ByteArray(dateValue);
                }
                case 92: {
                    return PGDataTypeUtilities.toUTF8ByteArray(wrapper.getTime().toString());
                }
                case 93: {
                    TimestampTz ts = wrapper.getTimestampTz();
                    Calendar cal = ts.getTimezoneCalendar();
                    cal.setTime(ts.getAdjustedTimestamp());
                    StringBuilder tsValue = new StringBuilder();
                    tsValue.append(TIMESTAMP_FORMAT.get().format(cal.getTime()));
                    tsValue.append(NANOSECONDS_FORMAT.format(ts.getNanos()));
                    TimeZone tz = TimeZone.getTimeZone("UTC");
                    int offsetInMillis = tz.getOffset(cal.getTimeInMillis());
                    String offset = String.format("%02d:%02d", Math.abs(offsetInMillis / 3600000), Math.abs(offsetInMillis / 60000 % 60));
                    offset = (offsetInMillis >= 0 ? " +" : " -") + offset;
                    tsValue.append(offset);
                    if (0 == cal.get(0)) {
                        tsValue.append(" BC");
                    }
                    return PGDataTypeUtilities.toUTF8ByteArray(tsValue.toString());
                }
                case -7: {
                    return PGDataTypeUtilities.toUTF8ByteArray(wrapper.getBit().toString());
                }
                case 2: {
                    return PGDataTypeUtilities.toUTF8ByteArray(wrapper.getNumeric().toString());
                }
                case 1111: {
                    ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_BYTE_BUFFER_CONVERT_ERR.name(), "Not Supported data type");
                    throw err;
                }
            }
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_BYTE_BUFFER_CONVERT_ERR.name(), "Not Supported data type");
            throw err;
        }
        catch (IncorrectTypeException ex) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_BYTE_BUFFER_CONVERT_ERR.name(), ex.getMessage(), (Throwable)ex);
        }
        catch (NullPointerException ex) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_BYTE_BUFFER_CONVERT_ERR.name(), ex.getMessage(), (Throwable)ex);
        }
        catch (ErrorException ex) {
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] toDate(byte[] bytes, int beginIndex, int length) throws ErrorException {
        int year = 0;
        int month = 0;
        int day = 0;
        try {
            int yearLength = -1;
            int monthLength = -1;
            int byteArrayIndex = beginIndex;
            int hyphenCounter = 0;
            if (bytes[byteArrayIndex] == 45) {
                ++byteArrayIndex;
            }
            block6: while (byteArrayIndex < beginIndex + length) {
                if (bytes[byteArrayIndex] == 45) {
                    switch (hyphenCounter) {
                        case 0: {
                            yearLength = byteArrayIndex - beginIndex;
                            ++hyphenCounter;
                            break;
                        }
                        case 1: {
                            monthLength = byteArrayIndex - beginIndex;
                            break block6;
                        }
                    }
                }
                ++byteArrayIndex;
            }
            if (-1 == yearLength) throw new Exception();
            if (-1 == monthLength) throw new Exception();
            year = PGDataTypeUtilities.toInteger(bytes, beginIndex, yearLength);
            month = PGDataTypeUtilities.toInteger(bytes, beginIndex + yearLength + 1, 2);
            if (length > monthLength + 3) {
                day = PGDataTypeUtilities.toInteger(bytes, beginIndex + monthLength + 1, 2);
                if (beginIndex + length - 2 < 0 || bytes[beginIndex + length - 2] != 66 || bytes[beginIndex + length - 1] != 67) return new int[]{year, month, day};
                year = -year;
                return new int[]{year, month, day};
            }
            int dayBeginIndex = beginIndex + monthLength + 1;
            day = PGDataTypeUtilities.toInteger(bytes, dayBeginIndex, length - monthLength - 1);
            return new int[]{year, month, day};
        }
        catch (Exception e) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_DATA_CONVERSION_ERROR_DATE.name(), PGDataTypeUtilities.toUTF8String(bytes, beginIndex, length), (Throwable)e, ExceptionType.DATA);
        }
    }

    public static Date toSqlDate(int[] dateValueList) {
        Calendar calForDate = GregorianCalendar.getInstance();
        if (dateValueList[0] < 0) {
            dateValueList[0] = -dateValueList[0];
            calForDate.set(0, 0);
        }
        calForDate.set(1, dateValueList[0]);
        calForDate.set(2, dateValueList[1] - 1);
        calForDate.set(5, dateValueList[2]);
        Date date = new Date(calForDate.getTime().getTime());
        return date;
    }

    public static int[] toTime(byte[] bytes, int beginIndex, int length) throws ErrorException {
        int highestHourDigitValue = 10;
        int highestMinDigitValue = 10;
        int highestSecondDigitValue = 10;
        int NANOSECOND_TIMESTAMP_LENGTH = 15;
        int highestNanoSecondDigitValue = 100000;
        int hour = 0;
        int min = 0;
        int sec = 0;
        int nanoSecond = 0;
        try {
            hour = (bytes[beginIndex] - 48) * 10 + (bytes[beginIndex + 1] - 48) * 1;
            min = (bytes[beginIndex + 3] - 48) * 10 + (bytes[beginIndex + 4] - 48) * 1;
            sec = (bytes[beginIndex + 6] - 48) * 10 + (bytes[beginIndex + 7] - 48) * 1;
            if (bytes.length == 15) {
                nanoSecond = (bytes[beginIndex + 9] - 48) * highestNanoSecondDigitValue + (bytes[beginIndex + 10] - 48) * (highestNanoSecondDigitValue / 10) + (bytes[beginIndex + 11] - 48) * (highestNanoSecondDigitValue / 100) + (bytes[beginIndex + 12] - 48) * (highestNanoSecondDigitValue / 1000) + (bytes[beginIndex + 13] - 48) * (highestNanoSecondDigitValue / 10000) + (bytes[beginIndex + 14] - 48) * (highestNanoSecondDigitValue / 100000);
            }
        }
        catch (Exception e) {
            throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_DATA_CONVERSION_ERROR_TIME.name(), PGDataTypeUtilities.toUTF8String(bytes, beginIndex, length), (Throwable)e, ExceptionType.DATA);
        }
        int[] utf8ToTime = new int[]{hour, min, sec, nanoSecond / 1000};
        return utf8ToTime;
    }

    public static int[] toTimestamp(byte[] bytes, int beginIndex, int length) throws ErrorException {
        int yearDataLength = 15;
        int timeDataLength = 8;
        int REGULAR_TIMESTAMP_LENGTH = 19;
        int utf8Space = 32;
        int highestNanoSecondDigitValue = 100000000;
        byte[] tempYearDataList = new byte[yearDataLength];
        byte[] tempTimeDataList = new byte[8];
        int nanoSecond = 0;
        boolean dateTimeSeparatorFound = false;
        for (int i = 0; i < length; ++i) {
            int currentDigit;
            if (!dateTimeSeparatorFound) {
                if (bytes[beginIndex + i] != 32) {
                    tempYearDataList[i] = bytes[beginIndex + i];
                    continue;
                }
                dateTimeSeparatorFound = true;
                yearDataLength = i;
                continue;
            }
            if (bytes[beginIndex + i] != 32 && i < 19) {
                if (bytes[beginIndex + i] == 32) continue;
                tempTimeDataList[i - 1 - yearDataLength] = bytes[beginIndex + i];
                continue;
            }
            if (bytes.length <= 19 || i < 19 || (currentDigit = PGDataTypeUtilities.utf8Lookup(bytes[beginIndex + i])) == -1) continue;
            int currentDigitValue = currentDigit * highestNanoSecondDigitValue;
            highestNanoSecondDigitValue /= 10;
            nanoSecond += currentDigitValue;
        }
        int[] YearDataValueList = PGDataTypeUtilities.toDate(tempYearDataList, 0, tempYearDataList.length);
        int[] YearTimeValueList = PGDataTypeUtilities.toTime(tempTimeDataList, 0, tempTimeDataList.length);
        if (beginIndex + length - 2 >= 0 && bytes[beginIndex + length - 2] == 66 && bytes[beginIndex + length - 1] == 67) {
            YearDataValueList[0] = -YearDataValueList[0];
        }
        int[] utf8ToTimeStamp = new int[]{YearDataValueList[0], YearDataValueList[1], YearDataValueList[2], YearTimeValueList[0], YearTimeValueList[1], YearTimeValueList[2], nanoSecond};
        return utf8ToTimeStamp;
    }

    public static Timestamp toSqlTimestamp(int[] timestampValueList) {
        Calendar calForTimestamp = GregorianCalendar.getInstance();
        if (timestampValueList[0] < 0) {
            timestampValueList[0] = -timestampValueList[0];
            calForTimestamp.set(0, 0);
        }
        calForTimestamp.set(1, timestampValueList[0]);
        calForTimestamp.set(2, timestampValueList[1] - 1);
        calForTimestamp.set(5, timestampValueList[2]);
        calForTimestamp.set(11, timestampValueList[3]);
        calForTimestamp.set(12, timestampValueList[4]);
        calForTimestamp.set(13, timestampValueList[5]);
        Timestamp timestamp = new Timestamp(calForTimestamp.getTimeInMillis());
        timestamp.setNanos(timestampValueList[6]);
        return timestamp;
    }

    public static Boolean toBit(byte[] bytes, int beginIndex) {
        if (bytes[beginIndex] == 116 || bytes[beginIndex] == 49) {
            return true;
        }
        if (bytes[beginIndex] == 102 || bytes[beginIndex] == 48) {
            return false;
        }
        return null;
    }

    public static byte[] transformByteFormat(byte[] bytes, int beginIndex, int length) {
        boolean errorFlag = false;
        int pointer = beginIndex;
        if (null == bytes) {
            return null;
        }
        if (0 == length) {
            return new byte[0];
        }
        if (92 != bytes[pointer]) {
            byte[] newArray = new byte[length];
            System.arraycopy(bytes, beginIndex, newArray, 0, length);
            return newArray;
        }
        if (120 != bytes[++pointer]) {
            if (length % 4 != 0) {
                byte[] newArray = new byte[length];
                System.arraycopy(bytes, beginIndex, newArray, 0, length);
                return newArray;
            }
            byte[] result = new byte[length / 4];
            int i = 0;
            while (pointer < beginIndex + length) {
                int stage1 = PGDataTypeUtilities.hexEncodingLookup(bytes[pointer]) << 6;
                errorFlag = (byte)stage1 == 127 || errorFlag;
                int stage2 = PGDataTypeUtilities.hexEncodingLookup(bytes[++pointer]) << 3;
                errorFlag = (byte)stage2 == 127 || errorFlag;
                int stage3 = PGDataTypeUtilities.hexEncodingLookup(bytes[++pointer]);
                errorFlag = (byte)stage3 == 127 || errorFlag;
                ++pointer;
                int stage4 = (stage1 | stage2) & 0xF0;
                int stage5 = (stage2 | stage3) & 0xF;
                result[i] = (byte)(stage4 | stage5);
                ++pointer;
                ++i;
            }
            if (errorFlag) {
                byte[] newArray = new byte[length];
                System.arraycopy(bytes, beginIndex, newArray, 0, length);
                return newArray;
            }
            return result;
        }
        if (1 == (beginIndex + length - ++pointer) % 2) {
            byte[] newArray = new byte[length];
            System.arraycopy(bytes, beginIndex, newArray, 0, length);
            return newArray;
        }
        byte[] result = new byte[(beginIndex + length - pointer) / 2];
        errorFlag = false;
        int i = 0;
        while (pointer < beginIndex + length) {
            int stage = PGDataTypeUtilities.hexEncodingLookup(bytes[pointer]) << 4;
            errorFlag = (byte)stage == 127 || errorFlag;
            int stage2 = PGDataTypeUtilities.hexEncodingLookup(bytes[++pointer]);
            errorFlag = (byte)stage2 == 127 || errorFlag;
            ++pointer;
            result[i] = (byte)(stage | stage2);
            ++i;
        }
        if (errorFlag) {
            byte[] newArray = new byte[length];
            System.arraycopy(bytes, beginIndex, newArray, 0, length);
            return newArray;
        }
        return result;
    }

    public static int toInt(byte[] bytes, int beginIndex) {
        if (bytes.length - beginIndex > 3) {
            return (bytes[beginIndex] & 0xFF) << 24 | (bytes[beginIndex + 1] & 0xFF) << 16 | (bytes[beginIndex + 2] & 0xFF) << 8 | bytes[beginIndex + 3] & 0xFF;
        }
        if (bytes.length - beginIndex == 3) {
            return (bytes[beginIndex] & 0xFF) << 16 | (bytes[beginIndex + 1] & 0xFF) << 8 | bytes[beginIndex + 2] & 0xFF;
        }
        if (bytes.length - beginIndex == 2) {
            return (bytes[beginIndex] & 0xFF) << 8 | bytes[beginIndex + 1] & 0xFF;
        }
        return bytes[beginIndex] & 0xFF;
    }

    private static IColumn createBaseArrayColumn(String catalog, String schema, String table, String column, int type, int length, String typeName) throws ErrorException {
        TypeMetadata typeMeta = PGDataTypeUtilities.createTypeMetadata(type, typeName);
        ColumnMetadata columnMeta = new ColumnMetadata(typeMeta);
        if (typeMeta.isIntervalType() || typeMeta.isCharacterType()) {
            typeMeta.setIntervalPrecision(length);
        }
        if (typeMeta.isCharacterType()) {
            try {
                columnMeta.setColumnLength(length);
            }
            catch (NumericOverflowException e) {
                throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_METADATA_INITIALIZATION_ERR.name(), e);
            }
        }
        if (typeMeta.isExactNumericType()) {
            int precision = length - 4 >> 16 & 0xFFFF;
            int scale = length - 4 & 0xFFFF;
            typeMeta.setPrecision((short)precision);
            typeMeta.setScale((short)scale);
        }
        columnMeta.setName(column);
        columnMeta.setLabel(columnMeta.getName());
        columnMeta.setCatalogName(catalog);
        columnMeta.setTableName(table);
        return columnMeta;
    }

    private static int hexEncodingLookup(byte inputValue) {
        int result = 127;
        switch (inputValue) {
            case 48: {
                result = 0;
                break;
            }
            case 49: {
                result = 1;
                break;
            }
            case 50: {
                result = 2;
                break;
            }
            case 51: {
                result = 3;
                break;
            }
            case 52: {
                result = 4;
                break;
            }
            case 53: {
                result = 5;
                break;
            }
            case 54: {
                result = 6;
                break;
            }
            case 55: {
                result = 7;
                break;
            }
            case 56: {
                result = 8;
                break;
            }
            case 57: {
                result = 9;
                break;
            }
            case 97: {
                result = 10;
                break;
            }
            case 98: {
                result = 11;
                break;
            }
            case 99: {
                result = 12;
                break;
            }
            case 100: {
                result = 13;
                break;
            }
            case 101: {
                result = 14;
                break;
            }
            case 102: {
                result = 15;
            }
        }
        return result;
    }

    private static int utf8Lookup(byte inputValue) {
        int result = -1;
        switch (inputValue) {
            case 48: {
                result = 0;
                break;
            }
            case 49: {
                result = 1;
                break;
            }
            case 50: {
                result = 2;
                break;
            }
            case 51: {
                result = 3;
                break;
            }
            case 52: {
                result = 4;
                break;
            }
            case 53: {
                result = 5;
                break;
            }
            case 54: {
                result = 6;
                break;
            }
            case 55: {
                result = 7;
                break;
            }
            case 56: {
                result = 8;
                break;
            }
            case 57: {
                result = 9;
            }
        }
        return result;
    }
}

