/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.inbound;

import com.amazon.jdbc.communications.interfaces.AbstractInboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.messages.inbound.FieldDescription;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class RowDescription
extends AbstractInboundMessage
implements PGConstants {
    private final short m_numberOfFields;
    private final FieldDescription[] m_fieldDescriptions;

    public RowDescription(ByteBuffer buffer, IPGLogger logger) {
        this.m_numberOfFields = buffer.getShort();
        this.m_fieldDescriptions = new FieldDescription[this.m_numberOfFields];
        for (int i = 0; i < this.m_numberOfFields; ++i) {
            this.m_fieldDescriptions[i] = new FieldDescription(buffer, logger);
        }
        if (logger.isExternalLoggerEnabled()) {
            this.logMessageContent(logger);
        }
    }

    public int getNumberOfFields() {
        return this.m_numberOfFields;
    }

    public FieldDescription[] getFieldDescriptions() {
        return this.m_fieldDescriptions;
    }

    public void logMessageContent(IPGLogger logger) {
        String message = "<=BE RowDescription(" + this.getNumberOfFields() + ")";
        logger.logDebugExternal(message);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nRowDescription: getNumberOfFields - ");
        str.append(this.getNumberOfFields());
        for (FieldDescription field : this.m_fieldDescriptions) {
            str.append(field.toString());
        }
        return str.toString();
    }
}

