/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.dsi.core.impl.DSILogger;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.support.LogLevel;
import com.amazon.support.SettingReader;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PGLogger
extends DSILogger
implements IPGLogger {
    private PrintWriter m_externalLogWriter = null;
    private LogLevel m_externallevel = LogLevel.OFF;
    private int m_connectionId = -1;

    public PGLogger(String fileName, int connectionId) {
        super(fileName + connectionId);
        String clientLogLevel = SettingReader.readSetting("DriverLogLevel");
        this.m_externallevel = this.getExternalLogLevel(clientLogLevel);
        this.m_externalLogWriter = DriverManager.getLogWriter();
        this.m_connectionId = connectionId;
    }

    @Override
    public LogLevel getExternalLogLevel() {
        return this.m_externallevel;
    }

    @Override
    public boolean isExternalLoggerEnabled() {
        return this.m_externallevel != LogLevel.OFF;
    }

    @Override
    public void logDebugExternal(String message) {
        this.logMessage(LogLevel.DEBUG, message);
    }

    @Override
    public void logInfoExternal(String message) {
        this.logMessage(LogLevel.INFO, message);
    }

    @Override
    public void setExternalLogLevel(LogLevel logLevel) {
        this.m_externallevel = logLevel;
    }

    private String formatLogLine(LogLevel logLevel, String message) {
        if (null == this.m_externalLogWriter) {
            return null;
        }
        String formattedLine = null;
        if (this.isInExternalLevel(logLevel)) {
            StringBuffer lineBuffer = new StringBuffer();
            SimpleDateFormat dateFormat = null;
            dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
            dateFormat.format(new Date(), lineBuffer, new FieldPosition(0));
            lineBuffer.append(" (");
            lineBuffer.append(this.m_connectionId);
            lineBuffer.append(") ");
            lineBuffer.append(message);
            lineBuffer.append("\n");
            formattedLine = lineBuffer.toString();
        }
        return formattedLine;
    }

    private boolean isInExternalLevel(LogLevel level) {
        return level.ordinal() <= this.m_externallevel.ordinal();
    }

    private void logMessage(LogLevel level, String message) {
        message = this.formatLogLine(level, message);
        if (null != this.m_externalLogWriter && null != message) {
            this.m_externalLogWriter.print(message);
            this.m_externalLogWriter.flush();
        }
    }

    private LogLevel getExternalLogLevel(String clientLogLevel) {
        LogLevel result = LogLevel.OFF;
        try {
            int logLevelId = Integer.parseInt(clientLogLevel);
            if (logLevelId == 1) {
                result = LogLevel.INFO;
            } else if (logLevelId >= 2) {
                result = LogLevel.DEBUG;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }
}

