/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.utilities.ExecutionContext;
import com.amazon.dsi.dataengine.utilities.ExecutionContexts;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.exceptions.DefaultParamException;
import com.amazon.dsi.exceptions.ParamAlreadyPushedException;
import com.amazon.jdbc.communications.exceptions.InboundErrorMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.dataengine.PGAbstractQueryExecutor;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;

public class PGQueryExecutor
extends PGAbstractQueryExecutor {
    private PGMessagingContext m_messagingContext;
    private String m_query;
    private PGCoreUtils.TransactionVerb m_txVerb = PGCoreUtils.TransactionVerb.NONE;

    public PGQueryExecutor(String query, PGClient client, ILogger log, boolean isDirectExecute, PGJDBCStatement statement, int socketTimeoutMS) throws ErrorException {
        LogUtilities.logFunctionEntrance(log, query, client);
        this.m_query = query;
        this.m_log = log;
        this.m_client = client;
        this.m_isDirectExecute = isDirectExecute;
        this.m_statement = statement;
        this.m_socketTimeoutMS = socketTimeoutMS;
        if (!isDirectExecute) {
            this.m_txVerb = PGCoreUtils.parseTransactionVerb(query);
            this.m_messagingContext = this.m_client.prepareStatement(query, statement.getWarningListener(), false);
            this.m_messagingContext.addSocketCloseListener(this);
            this.m_contexts.add(this.m_messagingContext);
            this.m_statement.pushContexts(this.m_contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContexts contexts, IWarningListener warningListener) throws ErrorException {
        int fetchSize;
        LogUtilities.logFunctionEntrance(this.m_log, contexts, warningListener);
        this.m_prepareStage = false;
        if (null != this.m_fatalException) {
            throw this.m_fatalException;
        }
        try {
            fetchSize = this.m_statement.getProperty(6).getInt();
        }
        catch (Exception ex) {
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Fetch size retrieval failed", this.m_query}, (Throwable)ex);
            throw err;
        }
        int maxRows = 0;
        try {
            maxRows = this.m_statement.getProperty(2).getInt();
        }
        catch (Exception ex) {
            ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_QUERY_EXE_GENERAL_ERR.name(), new String[]{"Max rows retrieval failed", this.m_query}, (Throwable)ex);
            throw err;
        }
        ++this.m_currentExecuteIndex;
        if (this.m_isDirectExecute) {
            PGCoreUtils.TransactionVerb txVerb = PGCoreUtils.parseTransactionVerb(this.m_query);
            if (PGCoreUtils.TransactionVerb.NONE != txVerb) {
                Lock txLock = this.m_statement.getTransactionLock();
                txLock.lock();
                try {
                    this.m_contexts = Collections.singletonList(this.m_client.directExecuteImmediately(this.m_query, this.m_statement.getWarningListener()));
                    this.m_statement.notifyTransaction(txVerb);
                }
                finally {
                    txLock.unlock();
                }
            } else {
                this.m_messagingContext = this.m_client.directExecuteExtraMetadata(this.m_query, fetchSize, maxRows, this.m_statement.getWarningListener(), false);
                this.m_contexts.add(this.m_messagingContext);
            }
            this.m_statement.pushContexts(this.m_contexts);
            for (PGMessagingContext currentCtx : this.m_contexts) {
                currentCtx.addSocketCloseListener(this);
            }
        } else {
            try {
                int parameterCounter = contexts.getMetadata().size();
                if (this.m_statement.isCallableStatement() && this.m_statement.hasReturnQuestionMark()) {
                    --parameterCounter;
                }
                this.executePreparedStatement(this.m_messagingContext, contexts, fetchSize, maxRows, parameterCounter, this.m_txVerb);
            }
            catch (Exception ex) {
                --this.m_currentExecuteIndex;
                if (!(ex instanceof ErrorException)) {
                    ErrorException err = PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.PG_PREPARE_EXECUTE_ERR.name(), ex.getMessage());
                    err.initCause(ex);
                    throw err;
                }
                throw (ErrorException)ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executePreparedStatement(PGMessagingContext messagingContext, ExecutionContexts contexts, int fetchSize, int maxRows, int parameterCounter, PGCoreUtils.TransactionVerb txVerb) throws InboundErrorMessage, ErrorException, ParamAlreadyPushedException, DefaultParamException {
        if (parameterCounter != 0) {
            ArrayList<byte[][]> paramSetBuilder = new ArrayList<byte[][]>();
            Iterator<ExecutionContext> parameterItr = contexts.contextIterator();
            while (parameterItr.hasNext()) {
                byte[][] paramSet = new byte[parameterCounter][];
                ExecutionContext paramDataContext = parameterItr.next();
                for (int i = 0; i < paramDataContext.getInputs().size(); ++i) {
                    ParameterInputValue paramDataStruct = paramDataContext.getInputs().get(i);
                    paramSet[i] = PGDataTypeUtilities.toUTF8ByteArray(paramDataStruct.getData());
                }
                paramSetBuilder.add(paramSet);
            }
            if (1 == paramSetBuilder.size()) {
                this.m_client.executePreparedStatement(messagingContext, fetchSize, maxRows, false, (byte[][])paramSetBuilder.get(0));
            } else {
                byte[][][] paramSets = new byte[paramSetBuilder.size()][][];
                for (int paramValueIndex = 0; paramValueIndex < paramSets.length; ++paramValueIndex) {
                    paramSets[paramValueIndex] = (byte[][])paramSetBuilder.get(paramValueIndex);
                }
                this.m_client.executePreparedStatementParameterSets(messagingContext, this.m_currentExecuteIndex, paramSets);
            }
        } else if (PGCoreUtils.TransactionVerb.NONE != txVerb) {
            Lock txLock = this.m_statement.getTransactionLock();
            txLock.lock();
            try {
                this.m_client.executePreparedStatement(messagingContext, fetchSize, maxRows, false, null);
                messagingContext.closeOperation();
                this.m_statement.notifyTransaction(txVerb);
            }
            finally {
                txLock.unlock();
            }
        } else {
            this.m_client.executePreparedStatement(messagingContext, fetchSize, maxRows, false, null);
        }
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        List<ParameterMetadata> parameterColumnMetadata = this.getMetadataForParameters(this.m_messagingContext);
        return (ArrayList)parameterColumnMetadata;
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return PGCoreUtils.parameterCounter(this.m_query);
    }

    @Override
    protected int getParamCountForContext(PGMessagingContext context) {
        return context.m_parameterMetadata.size();
    }
}

