/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aetree.bool;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.sqlengine.aeprocessor.aetree.IAEBinaryNode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.aeprocessor.metadatautil.AECoercionColumnInfo;
import com.amazon.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.amazon.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.amazon.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AELikePredicate
extends AEBooleanExpr
implements IAEBinaryNode<AEValueExpr, AEValueExpr> {
    private final ICoercionHandler m_coercionHandler;
    private AEValueExpr m_leftExpr;
    private AEValueExpr m_rightExpr;
    private AEValueExpr m_escape;
    private IAENode m_parent = null;
    private IColumn m_coercedMeta;

    public AELikePredicate(SqlDataEngineContext sqlDataEngineContext, AEValueExpr aEValueExpr, AEValueExpr aEValueExpr2, AEValueExpr aEValueExpr3) throws ErrorException {
        if (null == sqlDataEngineContext || null == aEValueExpr || null == aEValueExpr2) {
            throw new NullPointerException("Arguments cannot be null.");
        }
        this.m_coercionHandler = sqlDataEngineContext.getCoercionHandler();
        this.m_leftExpr = aEValueExpr;
        this.m_leftExpr.setParent(this);
        this.m_rightExpr = aEValueExpr2;
        this.m_rightExpr.setParent(this);
        this.m_escape = aEValueExpr3;
        if (this.m_escape != null) {
            this.m_escape.setParent(this);
        }
        this.initalizeMetadata(this.m_coercionHandler);
    }

    private AELikePredicate(AELikePredicate aELikePredicate) {
        this.setIsOptimized(aELikePredicate.isOptimized());
        this.m_coercionHandler = aELikePredicate.m_coercionHandler;
        this.m_leftExpr = aELikePredicate.m_leftExpr.copy();
        this.m_leftExpr.setParent(this);
        this.m_rightExpr = aELikePredicate.m_rightExpr.copy();
        this.m_rightExpr.setParent(this);
        if (null != aELikePredicate.m_escape) {
            this.m_escape = aELikePredicate.m_escape.copy();
            this.m_escape.setParent(this);
        }
        this.m_coercedMeta = ColumnMetadata.copyOf(aELikePredicate.m_coercedMeta);
    }

    private void initalizeMetadata(ICoercionHandler iCoercionHandler) throws ErrorException {
        this.m_coercedMeta = iCoercionHandler.coerceLikeColumns(new AECoercionColumnInfo(this.m_leftExpr), new AECoercionColumnInfo(this.m_rightExpr));
        assert (null != this.m_coercedMeta);
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    public Iterator<IAENode> getChildItr() {
        return this.asList().iterator();
    }

    public IColumn getCoercedColumnMetadata() {
        return this.m_coercedMeta;
    }

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.getLogString();
    }

    @Override
    public int getNumChildren() {
        return this.asList().size();
    }

    @Override
    public IAENode getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(IAENode iAENode) {
        this.m_parent = iAENode;
    }

    @Override
    public AEBooleanExpr.AEBooleanType getType() {
        return AEBooleanExpr.AEBooleanType.LIKE_PRED;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AELikePredicate)) {
            return false;
        }
        AELikePredicate aELikePredicate = (AELikePredicate)iAENode;
        if (!this.m_leftExpr.isEquivalent(aELikePredicate.m_leftExpr) || !this.m_rightExpr.isEquivalent(aELikePredicate.m_rightExpr)) {
            return false;
        }
        if (null == this.m_escape) {
            return null == aELikePredicate.m_escape;
        }
        return this.m_escape.isEquivalent(aELikePredicate.m_escape);
    }

    @Override
    public AEBooleanExpr copy() {
        return new AELikePredicate(this);
    }

    @Override
    public AEValueExpr getLeftOperand() {
        return this.m_leftExpr;
    }

    @Override
    public AEValueExpr getRightOperand() {
        return this.m_rightExpr;
    }

    public AEValueExpr getEscapeChar() {
        return this.m_escape;
    }

    public boolean hasEscapeChar() {
        return null != this.m_escape;
    }

    public void setLeftOperand(AEValueExpr aEValueExpr) {
        if (aEValueExpr == null) {
            throw new NullPointerException("can not set null to like operand.");
        }
        this.m_leftExpr = aEValueExpr;
        this.m_leftExpr.setParent(this);
    }

    public void setRightOperand(AEValueExpr aEValueExpr) {
        if (aEValueExpr == null) {
            throw new NullPointerException("can not set null to like operand.");
        }
        this.m_rightExpr = aEValueExpr;
        this.m_rightExpr.setParent(this);
    }

    public void setEscape(AEValueExpr aEValueExpr) {
        this.m_escape = aEValueExpr;
        this.m_escape.setParent(this);
    }

    @Override
    public void updateCoercion() throws ErrorException {
        this.initalizeMetadata(this.m_coercionHandler);
    }

    private List<IAENode> asList() {
        return new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                switch (n) {
                    case 0: {
                        return AELikePredicate.this.m_leftExpr;
                    }
                    case 1: {
                        return AELikePredicate.this.m_rightExpr;
                    }
                    case 2: {
                        if (null == AELikePredicate.this.m_escape) break;
                        return AELikePredicate.this.m_escape;
                    }
                }
                throw new IndexOutOfBoundsException("Index: " + n);
            }

            @Override
            public int size() {
                if (null != AELikePredicate.this.m_escape) {
                    return 3;
                }
                return 2;
            }
        };
    }
}

