/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aetree.relation;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.aeprocessor.AEQTableName;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AETable
extends AENamedRelationalExpr {
    private List<? extends IColumn> m_tableColumns;
    private DSIExtJResultSet m_table;

    public AETable(DSIExtJResultSet dSIExtJResultSet) throws ErrorException {
        if (null == dSIExtJResultSet) {
            throw new NullPointerException("table cannot be null.");
        }
        this.m_table = dSIExtJResultSet;
        this.m_tableColumns = new ArrayList<IColumn>(this.m_table.getSelectColumns());
    }

    private AETable(AETable aETable) {
        super(aETable);
        this.m_table = aETable.m_table;
        this.m_tableColumns = new ArrayList<IColumn>(aETable.m_tableColumns);
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AETable copy() {
        return new AETable(this);
    }

    public Iterator<IAENode> getChildItr() {
        return Collections.emptyList().iterator();
    }

    @Override
    public String getLogString() {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append("AETable: ");
        stringBuilder.append(new AEQTableName(this.m_table.getCatalogName(), this.m_table.getSchemaName(), this.m_table.getTableName()));
        if (this.hasCorrelationName()) {
            stringBuilder.append(" AS ").append(this.getQTableName());
        }
        return stringBuilder.toString();
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AETable)) {
            return false;
        }
        AETable aETable = (AETable)iAENode;
        return aETable.m_table == this.m_table;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AETable)) {
            return false;
        }
        return this.isEquivalent((AETable)object);
    }

    public int hashCode() {
        return this.m_table.hashCode();
    }

    @Override
    public IColumn getBaseColumn(int n) {
        return this.m_tableColumns.get(n);
    }

    public AEQTableName getBaseQTableName() {
        String string;
        AEQTableName.AEQTableNameBuilder aEQTableNameBuilder = new AEQTableName.AEQTableNameBuilder();
        String string2 = this.m_table.getCatalogName();
        if (null != string2) {
            aEQTableNameBuilder.setCatalogName(string2);
        }
        if (null != (string = this.m_table.getSchemaName())) {
            aEQTableNameBuilder.setSchemaName(string);
        }
        aEQTableNameBuilder.setTableName(this.m_table.getTableName());
        return aEQTableNameBuilder.build();
    }

    public String getBaseTableName() {
        return this.m_table.getTableName();
    }

    @Override
    public String getCatalogName() {
        if (this.hasCorrelationName()) {
            return "";
        }
        return this.m_table.getCatalogName();
    }

    @Override
    public String getSchemaName() {
        if (this.hasCorrelationName()) {
            return "";
        }
        return this.m_table.getSchemaName();
    }

    @Override
    public String getTableName() {
        if (this.hasCorrelationName()) {
            return this.getCorrelationName();
        }
        return this.m_table.getTableName();
    }

    public DSIExtJResultSet getTable() {
        return this.m_table;
    }

    public void setTable(DSIExtJResultSet dSIExtJResultSet) {
        if (dSIExtJResultSet == null) {
            throw new NullPointerException("null set on a AETable.");
        }
        this.m_table = dSIExtJResultSet;
    }

    @Override
    public int getColumnCount() {
        return this.m_tableColumns.size();
    }

    public boolean hasCorrelationName() {
        return this.getCorrelationName().length() > 0;
    }

    @Override
    public int setDataNeeded(AERelationalExpr aERelationalExpr, int n) throws ErrorException {
        if (aERelationalExpr.equals(this)) {
            this.m_table.setDataNeeded(n);
            return n;
        }
        return -1;
    }

    @Override
    public void setDataNeededOnChild() throws ErrorException {
    }

    @Override
    public boolean getDataNeeded(int n) {
        return this.m_table.getDataNeeded(n);
    }
}

